/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.SecurityActions;
import org.infinispan.configuration.parsing.ParseUtils;

public class GlobalStatePathConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> PATH = AttributeDefinition.builder((String)"path", null, String.class).initializer(() -> SecurityActions.getSystemProperty("user.dir")).immutable().build();
    public static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((String)"relativeTo", null, String.class).immutable().build();
    private final Attribute<String> path;
    private final Attribute<String> relativeTo;
    private final String elementName;
    private final ElementDefinition elementDefinition;
    private final String location;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{PATH, RELATIVE_TO});
    }

    public GlobalStatePathConfiguration(AttributeSet attributes, String elementName) {
        this.attributes = attributes.checkProtection();
        this.path = attributes.attribute(PATH);
        this.relativeTo = attributes.attribute(RELATIVE_TO);
        this.elementName = elementName;
        this.location = ParseUtils.resolvePath((String)this.path.get(), (String)this.relativeTo.get());
        this.elementDefinition = new DefaultElementDefinition(elementName);
    }

    public ElementDefinition getElementDefinition() {
        return this.elementDefinition;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String getLocation() {
        return this.location;
    }

    public String path() {
        return (String)this.path.get();
    }

    public String relativeTo() {
        return (String)this.relativeTo.get();
    }

    String elementName() {
        return this.elementName;
    }

    public boolean isModified() {
        return this.path.isModified() || this.relativeTo.isModified();
    }
}

