package org.infinispan.remoting.rpc;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Generated;

import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.impl.MBeanMetadata.AttributeMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationMetadata;
import org.infinispan.factories.impl.MBeanMetadata.OperationParameterMetadata;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.lifecycle.ModuleLifecycle;

/**
 * @api.private 
 */
@Generated(value = "org.infinispan.component.processor.Generator", date = "2022-09-13T09:10:04.123305Z")
public final class CorePackageImpl {
   public static void registerMetadata(ModuleMetadataBuilder.ModuleBuilder builder) {
//start org.infinispan.remoting.rpc.RpcManagerImpl
      builder.registerComponentAccessor("org.infinispan.remoting.rpc.RpcManagerImpl",
         Collections.emptyList(),
         new ComponentAccessor<RpcManagerImpl>("org.infinispan.remoting.rpc.RpcManagerImpl",
            1, false, null,
            Arrays.asList("org.infinispan.remoting.transport.Transport", "org.infinispan.configuration.cache.Configuration", "org.infinispan.distribution.DistributionManager", "org.infinispan.commons.time.TimeService", "org.infinispan.xsite.metrics.XSiteMetricsCollector")) {
         protected void wire(RpcManagerImpl instance, WireContext context, boolean start) {
            instance.t = context.get("org.infinispan.remoting.transport.Transport", org.infinispan.remoting.transport.Transport.class, start);
            instance.configuration = context.get("org.infinispan.configuration.cache.Configuration", org.infinispan.configuration.cache.Configuration.class, start);
            instance.cf = context.getLazy("org.infinispan.commands.CommandsFactory", org.infinispan.commands.CommandsFactory.class, start);
            instance.distributionManager = context.get("org.infinispan.distribution.DistributionManager", org.infinispan.distribution.DistributionManager.class, start);
            instance.timeService = context.get("org.infinispan.commons.time.TimeService", org.infinispan.commons.time.TimeService.class, start);
            instance.xSiteMetricsCollector = context.get("org.infinispan.xsite.metrics.XSiteMetricsCollector", org.infinispan.xsite.metrics.XSiteMetricsCollector.class, start);
         }

         protected void start(RpcManagerImpl instance) throws Exception {
            instance.start();
         }

         protected void stop(RpcManagerImpl instance) throws Exception {
            instance.stop();
         }

      });

      builder.registerMBeanMetadata("org.infinispan.remoting.rpc.RpcManagerImpl",
         MBeanMetadata.of("RpcManager", "Manages all remote calls to remote cache instances in the cluster.", null,
            new AttributeMetadata("committedViewAsString", "Retrieves the committed view.", false, true, "java.lang.String", false, null, null),
            new AttributeMetadata("pendingViewAsString", "Retrieves the pending view.", false, true, "java.lang.String", false, null, null),
            new AttributeMetadata("replicationCount", "Number of successful replications", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getReplicationCount, null),
            new AttributeMetadata("replicationFailures", "Number of failed replications", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getReplicationFailures, null),
            new AttributeMetadata("statisticsEnabled", "Enables or disables the gathering of statistics by this component", true, true, "boolean", true, null, null),
            new AttributeMetadata("successRatio", "Successful replications as a ratio of total replications", false, true, "java.lang.String", false, null, null),
            new AttributeMetadata("successRatioFloatingPoint", "Successful replications as a ratio of total replications in numeric double format", false, true, "double", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getSuccessRatioFloatingPoint, null),
            new AttributeMetadata("averageReplicationTime", "The average time spent in the transport layer, in milliseconds", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getAverageReplicationTime, null),
            new AttributeMetadata("sitesView", "Retrieves the x-site view.", false, true, "java.lang.String", false, null, null),
            new AttributeMetadata("averageXSiteReplicationTime", "Returns the average replication time, in milliseconds, for a cross-site replication request", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getAverageXSiteReplicationTime, null),
            new AttributeMetadata("minimumXSiteReplicationTime", "Returns the minimum replication time, in milliseconds, for a cross-site replication request", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getMinimumXSiteReplicationTime, null),
            new AttributeMetadata("maximumXSiteReplicationTime", "Returns the maximum replication time, in milliseconds, for a cross-site replication request", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getMaximumXSiteReplicationTime, null),
            new AttributeMetadata("numberXSiteRequests", "Returns the number of sync cross-site requests", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getNumberXSiteRequests, null),
            new AttributeMetadata("numberXSiteRequestsReceived", "Returns the number of cross-site requests received from all nodes", false, true, "long", false, (java.util.function.Function<org.infinispan.remoting.rpc.RpcManagerImpl, ?>) org.infinispan.remoting.rpc.RpcManagerImpl::getNumberXSiteRequestsReceived, null),
            new AttributeMetadata("crossSiteReplicationTimes", "Cross Site Replication Times", false, true, "org.eclipse.microprofile.metrics.Timer", false, null, (org.infinispan.remoting.rpc.RpcManagerImpl _x, Object _y) -> _x.setCrossSiteReplicationTimes((org.eclipse.microprofile.metrics.Timer) _y)),
            new OperationMetadata("resetStatistics", "", "Resets statistics gathered by this component", "void"
            ),
            new OperationMetadata("setStatisticsEnabled", "", "", "void",
               new OperationParameterMetadata("enabled", "boolean", "Whether statistics should be enabled or disabled (true/false)")
            ),
            new OperationMetadata("getAverageXSiteReplicationTimeTo", "AverageXSiteReplicationTimeTo", "Returns the average replication time, in milliseconds, for cross-site request sent to the remote site.", "long",
               new OperationParameterMetadata("dstSite", "java.lang.String", "Destination site name")
            ),
            new OperationMetadata("getMinimumXSiteReplicationTimeTo", "MinimumXSiteReplicationTimeTo", "Returns the minimum replication time, in milliseconds, for cross-site request sent to the remote site.", "long",
               new OperationParameterMetadata("dstSite", "java.lang.String", "Destination site name")
            ),
            new OperationMetadata("getMaximumXSiteReplicationTimeTo", "MaximumXSiteReplicationTimeTo", "Returns the maximum replication time, in milliseconds, for cross-site request sent to the remote site.", "long",
               new OperationParameterMetadata("dstSite", "java.lang.String", "Destination site name")
            ),
            new OperationMetadata("getNumberXSiteRequestsSentTo", "NumberXSiteRequestsSentTo", "Returns the number of cross-site requests sent to the remote site.", "long",
               new OperationParameterMetadata("dstSite", "java.lang.String", "Destination site name")
            ),
            new OperationMetadata("getNumberXSiteRequestsReceivedFrom", "NumberXSiteRequestsReceivedFrom", "Returns the number of cross-site requests received from the remote site.", "long",
               new OperationParameterMetadata("srcSite", "java.lang.String", "Originator site name")
            )
      ));

//end
   }
}
