/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.GlobalComponentRegistry;

public class CacheShutdownCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 94;
    private String cacheName;

    public CacheShutdownCommand() {
        super((byte)94);
    }

    public CacheShutdownCommand(String cacheName) {
        super((byte)94);
        this.cacheName = cacheName;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        return gcr.getLocalTopologyManager().handleCacheShutdown(this.cacheName);
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.cacheName, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString((ObjectInput)input);
    }

    public String toString() {
        return "ShutdownCacheCommand{cacheName='" + this.cacheName + '\'' + '}';
    }
}

