package org.infinispan.util.logging;

import java.util.Locale;
import java.lang.Enum;
import java.io.Serializable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.util.ByteString;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import java.lang.String;
import org.infinispan.commons.marshall.MarshallingException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import java.util.List;
import java.util.UUID;
import java.lang.IllegalArgumentException;
import org.infinispan.util.concurrent.TimeoutException;
import java.lang.UnsupportedOperationException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.persistence.spi.NonBlockingStore.Characteristic;
import java.lang.reflect.Method;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAResource;
import org.infinispan.transaction.WriteSkewException;
import javax.transaction.TransactionManager;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Long;
import java.lang.Throwable;
import java.util.Collection;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.util.Map;
import java.io.File;
import java.lang.IllegalStateException;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.topology.CacheTopology.Phase;
import java.util.Set;
import org.infinispan.transaction.impl.LocalTransaction;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.jboss.logging.Logger;
import java.util.Properties;
import java.lang.InterruptedException;
import java.lang.RuntimeException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.jboss.logging.BasicLogger;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.interceptors.impl.ContainerFullException;
import java.nio.file.Path;
import org.infinispan.partitionhandling.AvailabilityException;
import javax.annotation.processing.Generated;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.IllegalLifecycleStateException;
import java.lang.SecurityException;
import java.io.IOException;
import javax.transaction.Synchronization;
import org.jgroups.View;
import java.lang.Exception;
import org.infinispan.remoting.responses.Response;
import org.infinispan.topology.CacheTopology;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.remoting.RemoteException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-10-24T06:53:32-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void problemApplyingStateForKey(final Object key, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, problemApplyingStateForKey$str(), key);
    }
    protected String problemApplyingStateForKey$str() {
        return "ISPN000016: Problem encountered when applying state for key %s!";
    }
    @Override
    public final void expectedJustOneResponse(final Map<Address, Response> lr) {
        super.log.logf(FQCN, WARN, null, expectedJustOneResponse$str(), lr);
    }
    protected String expectedJustOneResponse$str() {
        return "ISPN000021: Expected just one response; got %s";
    }
    @Override
    public final void notStartingEvictionThread() {
        super.log.logf(FQCN, INFO, null, notStartingEvictionThread$str());
    }
    protected String notStartingEvictionThread$str() {
        return "ISPN000025: wakeUpInterval is <= 0, not starting expired purge thread";
    }
    @Override
    public final void exceptionPurgingDataContainer(final Throwable e) {
        super.log.logf(FQCN, WARN, e, exceptionPurgingDataContainer$str());
    }
    protected String exceptionPurgingDataContainer$str() {
        return "ISPN000026: Caught exception purging data container!";
    }
    @Override
    public final void unableToPassivateEntry(final Object key, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToPassivateEntry$str(), key);
    }
    protected String unableToPassivateEntry$str() {
        return "ISPN000028: Unable to passivate entry under %s";
    }
    protected String jmxMBeanAlreadyRegistered$str() {
        return "ISPN000034: The '%s' JMX domain is already in use.";
    }
    @Override
    public final JmxDomainConflictException jmxMBeanAlreadyRegistered(final String jmxDomain, final Throwable cause) {
        final JmxDomainConflictException result = new JmxDomainConflictException(String.format(getLoggingLocale(), jmxMBeanAlreadyRegistered$str(), jmxDomain));
        result.initCause(cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void couldNotFindAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, couldNotFindAttribute$str(), name);
    }
    protected String couldNotFindAttribute$str() {
        return "ISPN000036: Did not find attribute %s";
    }
    @Override
    public final void failedToUpdateAttribute(final String name, final Object value) {
        super.log.logf(FQCN, WARN, null, failedToUpdateAttribute$str(), name, value);
    }
    protected String failedToUpdateAttribute$str() {
        return "ISPN000037: Failed to update attribute name %s with value %s";
    }
    @Override
    public final void queriedAttributeNotFound(final String attributeName) {
        super.log.logf(FQCN, WARN, null, queriedAttributeNotFound$str(), attributeName);
    }
    protected String queriedAttributeNotFound$str() {
        return "ISPN000042: Did not find queried attribute with name %s";
    }
    @Override
    public final void errorWritingValueForAttribute(final String attributeName, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorWritingValueForAttribute$str(), attributeName);
    }
    protected String errorWritingValueForAttribute$str() {
        return "ISPN000043: Exception while writing value for attribute %s";
    }
    @Override
    public final void couldNotInvokeSetOnAttribute(final String attributeName, final Object value) {
        super.log.logf(FQCN, WARN, null, couldNotInvokeSetOnAttribute$str(), attributeName, value);
    }
    protected String couldNotInvokeSetOnAttribute$str() {
        return "ISPN000044: Could not invoke set on attribute %s with value %s";
    }
    @Override
    public final void unknownResponsesFromRemoteCache(final Collection<Response> responses) {
        super.log.logf(FQCN, ERROR, null, unknownResponsesFromRemoteCache$str(), responses);
    }
    protected String unknownResponsesFromRemoteCache$str() {
        return "ISPN000046: Unknown responses from remote cache: %s";
    }
    @Override
    public final void errorDoingRemoteCall(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorDoingRemoteCall$str());
    }
    protected String errorDoingRemoteCall$str() {
        return "ISPN000047: Error while doing remote call";
    }
    @Override
    public final void interruptedWaitingAsyncStorePush(final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedWaitingAsyncStorePush$str());
    }
    protected String interruptedWaitingAsyncStorePush$str() {
        return "ISPN000048: Interrupted or timeout while waiting for AsyncCacheWriter worker threads to push all state to the decorated store";
    }
    @Override
    public final void interruptedAcquiringLock(final long ms, final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedAcquiringLock$str(), ms);
    }
    protected String interruptedAcquiringLock$str() {
        return "ISPN000052: Interrupted on acquireLock for %d milliseconds!";
    }
    @Override
    public final void unableToProcessAsyncModifications(final int retries) {
        super.log.logf(FQCN, WARN, null, unableToProcessAsyncModifications$str(), retries);
    }
    protected String unableToProcessAsyncModifications$str() {
        return "ISPN000053: Unable to process some async modifications after %d retries!";
    }
    @Override
    public final void unexpectedErrorInAsyncStoreCoordinator(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorInAsyncStoreCoordinator$str());
    }
    protected String unexpectedErrorInAsyncStoreCoordinator$str() {
        return "ISPN000055: Unexpected error in AsyncStoreCoordinator thread. AsyncCacheWriter is dead!";
    }
    @Override
    public final void exceptionHandlingCommand(final ReplicableCommand cmd, final Throwable t) {
        super.log.logf(FQCN, WARN, t, exceptionHandlingCommand$str(), cmd);
    }
    protected String exceptionHandlingCommand$str() {
        return "ISPN000071: Caught exception when handling command %s";
    }
    @Override
    public final void unexpectedErrorReplicating(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorReplicating$str());
    }
    protected String unexpectedErrorReplicating$str() {
        return "ISPN000073: Unexpected error while replicating";
    }
    @Override
    public final void startingJGroupsChannel(final String cluster) {
        super.log.logf(FQCN, INFO, null, startingJGroupsChannel1$str(), cluster);
    }
    protected String startingJGroupsChannel1$str() {
        return "ISPN000078: Starting JGroups channel `%s`";
    }
    @Override
    public final void startingJGroupsChannel(final String cluster, final String stack) {
        super.log.logf(FQCN, INFO, null, startingJGroupsChannel2$str(), cluster, stack);
    }
    protected String startingJGroupsChannel2$str() {
        return "ISPN000078: Starting JGroups channel `%s` with stack `%s`";
    }
    @Override
    public final void localAndPhysicalAddress(final String cluster, final Address address, final List<Address> physicalAddresses) {
        super.log.logf(FQCN, INFO, null, localAndPhysicalAddress$str(), cluster, address, physicalAddresses);
    }
    protected String localAndPhysicalAddress$str() {
        return "ISPN000079: Channel `%s` local address is `%s`, physical addresses are `%s`";
    }
    @Override
    public final void disconnectJGroups(final String cluster) {
        super.log.logf(FQCN, INFO, null, disconnectJGroups$str(), cluster);
    }
    protected String disconnectJGroups$str() {
        return "ISPN000080: Disconnecting JGroups channel `%s`";
    }
    @Override
    public final void problemClosingChannel(final Exception e, final String cluster) {
        super.log.logf(FQCN, ERROR, e, problemClosingChannel$str(), cluster);
    }
    protected String problemClosingChannel$str() {
        return "ISPN000081: Problem closing channel `%s`; setting it to null";
    }
    @Override
    public final void wrongTypeForJGroupsChannelLookup(final String channelLookupClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, wrongTypeForJGroupsChannelLookup$str(), channelLookupClassName);
    }
    protected String wrongTypeForJGroupsChannelLookup$str() {
        return "ISPN000083: Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.";
    }
    @Override
    public final void errorInstantiatingJGroupsChannelLookup(final String channelLookupClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorInstantiatingJGroupsChannelLookup$str(), channelLookupClassName);
    }
    protected String errorInstantiatingJGroupsChannelLookup$str() {
        return "ISPN000084: Errors instantiating [%s]! Not using a channel lookup.";
    }
    protected String errorCreatingChannelFromConfigFile$str() {
        return "ISPN000085: Error while trying to create a channel using the specified configuration file: %s";
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigFile(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromConfigFile$str(), cfg), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingChannelFromXML$str() {
        return "ISPN000086: Error while trying to create a channel using the specified configuration XML: %s";
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromXML(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromXML$str(), cfg), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingChannelFromConfigString$str() {
        return "ISPN000087: Error while trying to create a channel using the specified configuration string: %s";
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigString(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromConfigString$str(), cfg), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToUseJGroupsPropertiesProvided(final TypedProperties props) {
        super.log.logf(FQCN, INFO, null, unableToUseJGroupsPropertiesProvided$str(), props);
    }
    protected String unableToUseJGroupsPropertiesProvided$str() {
        return "ISPN000088: Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!";
    }
    @Override
    public final void interruptedWaitingForCoordinator(final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedWaitingForCoordinator$str());
    }
    protected String interruptedWaitingForCoordinator$str() {
        return "ISPN000089: getCoordinator(): Interrupted while waiting for members to be set";
    }
    @Override
    public final void receivedMergedView(final String cluster, final View newView) {
        super.log.logf(FQCN, INFO, null, receivedMergedView$str(), cluster, newView);
    }
    protected String receivedMergedView$str() {
        return "ISPN000093: Received new, MERGED cluster view for channel %s: %s";
    }
    @Override
    public final void receivedClusterView(final String cluster, final View newView) {
        super.log.logf(FQCN, INFO, null, receivedClusterView$str(), cluster, newView);
    }
    protected String receivedClusterView$str() {
        return "ISPN000094: Received new cluster view for channel %s: %s";
    }
    @Override
    public final void errorProcessing1pcPrepareCommand(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessing1pcPrepareCommand$str());
    }
    protected String errorProcessing1pcPrepareCommand$str() {
        return "ISPN000097: Error while processing a prepare in a single-phase transaction";
    }
    @Override
    public final void errorRollingBack(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorRollingBack$str());
    }
    protected String errorRollingBack$str() {
        return "ISPN000098: Exception during rollback";
    }
    @Override
    public final void unfinishedTransactionsRemain(final int localTransactions, final int remoteTransactions) {
        super.log.logf(FQCN, WARN, null, unfinishedTransactionsRemain$str(), localTransactions, remoteTransactions);
    }
    protected String unfinishedTransactionsRemain$str() {
        return "ISPN000100: Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.";
    }
    @Override
    public final void failedSynchronizationRegistration(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedSynchronizationRegistration$str());
    }
    protected String failedSynchronizationRegistration$str() {
        return "ISPN000101: Failed synchronization registration";
    }
    @Override
    public final void unableToRollbackGlobalTx(final GlobalTransaction gtx, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToRollbackGlobalTx$str(), gtx);
    }
    protected String unableToRollbackGlobalTx$str() {
        return "ISPN000102: Unable to roll back global transaction %s";
    }
    @Override
    public final void fallingBackToEmbeddedTm() {
        super.log.logf(FQCN, INFO, null, fallingBackToEmbeddedTm$str());
    }
    protected String fallingBackToEmbeddedTm$str() {
        return "ISPN000104: Using EmbeddedTransactionManager";
    }
    @Override
    public final void failedToCreateInitialCtx(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedToCreateInitialCtx$str());
    }
    protected String failedToCreateInitialCtx$str() {
        return "ISPN000105: Failed creating initial JNDI context";
    }
    @Override
    public final void retrievingTm(final TransactionManager tm) {
        super.log.logf(FQCN, INFO, null, retrievingTm$str(), tm);
    }
    protected String retrievingTm$str() {
        return "ISPN000107: Retrieving transaction manager %s";
    }
    @Override
    public final void errorEnlistingResource(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorEnlistingResource$str());
    }
    protected String errorEnlistingResource$str() {
        return "ISPN000108: Error enlisting resource";
    }
    @Override
    public final void beforeCompletionFailed(final Synchronization s, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, beforeCompletionFailed$str(), s);
    }
    protected String beforeCompletionFailed$str() {
        return "ISPN000109: beforeCompletion() failed for %s";
    }
    @Override
    public final void unexpectedErrorFromResourceManager(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorFromResourceManager$str());
    }
    protected String unexpectedErrorFromResourceManager$str() {
        return "ISPN000110: Unexpected error from resource manager!";
    }
    @Override
    public final void afterCompletionFailed(final Synchronization s, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, afterCompletionFailed$str(), s);
    }
    protected String afterCompletionFailed$str() {
        return "ISPN000111: afterCompletion() failed for %s";
    }
    @Override
    public final void errorCommittingTx(final Throwable e) {
        super.log.logf(FQCN, WARN, e, errorCommittingTx$str());
    }
    protected String errorCommittingTx$str() {
        return "ISPN000112: exception while committing";
    }
    @Override
    public final void recoveryIgnored() {
        super.log.logf(FQCN, WARN, null, recoveryIgnored$str());
    }
    protected String recoveryIgnored$str() {
        return "ISPN000115: Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646";
    }
    @Override
    public final void missingListPreparedTransactions(final Object key, final Object value) {
        super.log.logf(FQCN, WARN, null, missingListPreparedTransactions$str(), key, value);
    }
    protected String missingListPreparedTransactions$str() {
        return "ISPN000116: Missing the list of prepared transactions from node %s. Received response is %s";
    }
    @Override
    public final void preparedTxAlreadyExists(final RecoveryAwareTransaction previous, final RecoveryAwareRemoteTransaction remoteTransaction) {
        super.log.logf(FQCN, ERROR, null, preparedTxAlreadyExists$str(), previous, remoteTransaction);
    }
    protected String preparedTxAlreadyExists$str() {
        return "ISPN000117: There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?";
    }
    @Override
    public final void unableToSetValue(final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToSetValue$str());
    }
    protected String unableToSetValue$str() {
        return "ISPN000121: Unable to set value!";
    }
    @Override
    public final void failedToCallStopAfterFailure(final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedToCallStopAfterFailure$str());
    }
    protected String failedToCallStopAfterFailure$str() {
        return "ISPN000126: Attempted to stop() from FAILED state, but caught exception";
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, DEBUG, null, version$str(), version);
    }
    protected String version$str() {
        return "ISPN000128: Infinispan version: %s";
    }
    @Override
    public final void noAnnotateMethodsFoundInListener(final Class<?> listenerClass) {
        super.log.logf(FQCN, WARN, null, noAnnotateMethodsFoundInListener$str(), listenerClass);
    }
    protected String noAnnotateMethodsFoundInListener$str() {
        return "ISPN000133: Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.";
    }
    @Override
    public final void unableToInvokeListenerMethodAndRemoveListener(final Method m, final Object target, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToInvokeListenerMethodAndRemoveListener$str(), m, target);
    }
    protected String unableToInvokeListenerMethodAndRemoveListener$str() {
        return "ISPN000134: Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!";
    }
    @Override
    public final void unableToLockToInvalidate(final Object key, final Address address) {
        super.log.logf(FQCN, WARN, null, unableToLockToInvalidate$str(), key, address);
    }
    protected String unableToLockToInvalidate$str() {
        return "ISPN000135: Could not lock key %s in order to invalidate from L1 at node %s, skipping....";
    }
    @Override
    public final void executionError(final String commandType, final String cacheName, final String affectedKeys, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, executionError$str(), commandType, cacheName, affectedKeys);
    }
    protected String executionError$str() {
        return "ISPN000136: Error executing command %s on %s, writing keys %s";
    }
    @Override
    public final void failedInvalidatingRemoteCache(final Throwable e) {
        super.log.logf(FQCN, INFO, e, failedInvalidatingRemoteCache$str());
    }
    protected String failedInvalidatingRemoteCache$str() {
        return "ISPN000137: Failed invalidating remote cache";
    }
    @Override
    public final void couldNotRollbackPrepared1PcTransaction(final LocalTransaction localTransaction, final Throwable e1) {
        super.log.logf(FQCN, WARN, e1, couldNotRollbackPrepared1PcTransaction$str(), localTransaction);
    }
    protected String couldNotRollbackPrepared1PcTransaction$str() {
        return "ISPN000141: Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s";
    }
    @Override
    public final void failedLoadingValueFromCacheStore(final Object key, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedLoadingValueFromCacheStore$str(), key);
    }
    protected String failedLoadingValueFromCacheStore$str() {
        return "ISPN000144: Failed loading value for key %s from cache store";
    }
    @Override
    public final void failedToInvalidateKeys(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedToInvalidateKeys$str());
    }
    protected String failedToInvalidateKeys$str() {
        return "ISPN000147: Error invalidating keys from L1 after rehash";
    }
    @Override
    public final void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup() {
        super.log.logf(FQCN, WARN, null, staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str());
    }
    protected String staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str() {
        return "ISPN000149: Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup";
    }
    @Override
    public final void passivationWithoutEviction() {
        super.log.logf(FQCN, INFO, null, passivationWithoutEviction$str());
    }
    protected String passivationWithoutEviction$str() {
        return "ISPN000152: Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.";
    }
    @Override
    public final void couldNotCompleteInjectedTransaction(final Throwable t) {
        super.log.logf(FQCN, WARN, t, couldNotCompleteInjectedTransaction$str());
    }
    protected String couldNotCompleteInjectedTransaction$str() {
        return "ISPN000160: Could not complete injected transaction.";
    }
    @Override
    public final void usingBatchModeTransactionManager() {
        super.log.logf(FQCN, INFO, null, usingBatchModeTransactionManager$str());
    }
    protected String usingBatchModeTransactionManager$str() {
        return "ISPN000161: Using a batchMode transaction manager";
    }
    @Override
    public final void couldNotInstantiateTransactionManager(final Exception e) {
        super.log.logf(FQCN, INFO, e, couldNotInstantiateTransactionManager$str());
    }
    protected String couldNotInstantiateTransactionManager$str() {
        return "ISPN000162: Could not instantiate transaction manager";
    }
    @Override
    public final void randomCacheModeSynonymsDeprecated(final String candidate, final String mode, final List<String> synonyms) {
        super.log.logf(FQCN, WARN, null, randomCacheModeSynonymsDeprecated$str(), candidate, mode, synonyms);
    }
    protected String randomCacheModeSynonymsDeprecated$str() {
        return "ISPN000177: %s has been deprecated as a synonym for %s. Use one of %s instead";
    }
    @Override
    public final void errorProcessing2pcCommitCommand(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessing2pcCommitCommand$str());
    }
    protected String errorProcessing2pcCommitCommand$str() {
        return "ISPN000188: Error while processing a commit in a two-phase transaction";
    }
    @Override
    public final void componentFailedToStop(final Throwable e) {
        super.log.logf(FQCN, WARN, e, componentFailedToStop$str());
    }
    protected String componentFailedToStop$str() {
        return "ISPN000189: While stopping a cache or cache manager, one of its components failed to stop";
    }
    @Override
    public final void failedLoadingKeysFromCacheStore(final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedLoadingKeysFromCacheStore$str());
    }
    protected String failedLoadingKeysFromCacheStore$str() {
        return "ISPN000194: Failed loading keys from cache store";
    }
    @Override
    public final void rebalanceError(final String cacheName, final Address node, final int topologyId, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, rebalanceError$str(), cacheName, node, topologyId);
    }
    protected String rebalanceError$str() {
        return "ISPN000195: Error during rebalance for cache %s on node %s, topology id = %d";
    }
    @Override
    public final void failedToRecoverClusterState(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToRecoverClusterState$str());
    }
    protected String failedToRecoverClusterState$str() {
        return "ISPN000196: Failed to recover cluster state after the current node became the coordinator (or after merge), will retry";
    }
    @Override
    public final void errorUpdatingMembersList(final int viewId, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, errorUpdatingMembersList$str(), viewId);
    }
    protected String errorUpdatingMembersList$str() {
        return "ISPN000197: Error updating cluster member list for view %d, waiting for next view";
    }
    @Override
    public final void cacheBackupsDataToSameSite(final String siteName) {
        super.log.logf(FQCN, TRACE, null, cacheBackupsDataToSameSite$str(), siteName);
    }
    protected String cacheBackupsDataToSameSite$str() {
        return "ISPN000201: This cache is configured to backup to its own site (%s).";
    }
    @Override
    public final void warnXsiteBackupFailed(final String cacheName, final String siteName, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, warnXsiteBackupFailed$str(), cacheName, siteName);
    }
    protected String warnXsiteBackupFailed$str() {
        return "ISPN000202: Encountered issues while backing up data for cache %s to site %s";
    }
    @Override
    public final void cannotRespondToRollback(final GlobalTransaction globalTransaction, final String cacheName) {
        super.log.logf(FQCN, WARN, null, cannotRespondToRollback$str(), globalTransaction, cacheName);
    }
    protected String cannotRespondToRollback$str() {
        return "ISPN000203: The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    }
    @Override
    public final void cannotRespondToCommit(final GlobalTransaction globalTransaction, final String cacheName) {
        super.log.logf(FQCN, WARN, null, cannotRespondToCommit$str(), globalTransaction, cacheName);
    }
    protected String cannotRespondToCommit$str() {
        return "ISPN000204: The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    }
    @Override
    public final void tryingToBringOnlineNonexistentSite(final String siteName) {
        super.log.logf(FQCN, WARN, null, tryingToBringOnlineNonexistentSite$str(), siteName);
    }
    protected String tryingToBringOnlineNonexistentSite$str() {
        return "ISPN000205: Trying to bring back an non-existent site (%s)!";
    }
    @Override
    public final void couldNotInterruptThread(final UUID id) {
        super.log.logf(FQCN, WARN, null, couldNotInterruptThread$str(), id);
    }
    protected String couldNotInterruptThread$str() {
        return "ISPN000207: Could not interrupt as no thread found for command uuid %s";
    }
    @Override
    public final void noLiveOwnersFoundForSegments(final Collection<Integer> segments, final String cacheName, final Collection<Address> faultySources) {
        super.log.logf(FQCN, ERROR, null, noLiveOwnersFoundForSegments$str(), segments, cacheName, faultySources);
    }
    protected String noLiveOwnersFoundForSegments$str() {
        return "ISPN000208: No live owners found for segments %s of cache %s. Excluded owners: %s";
    }
    @Override
    public final void failedToRetrieveTransactionsForSegments(final String cacheName, final Address source, final Collection<Integer> segments, final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedToRetrieveTransactionsForSegments$str(), cacheName, source, segments);
    }
    protected String failedToRetrieveTransactionsForSegments$str() {
        return "ISPN000209: Failed to retrieve transactions of cache %s from node %s, segments %s";
    }
    @Override
    public final void failedToRequestSegments(final String cacheName, final Address source, final Collection<Integer> segments, final Throwable e) {
        super.log.logf(FQCN, WARN, e, failedToRequestSegments$str(), cacheName, source, segments);
    }
    protected String failedToRequestSegments$str() {
        return "ISPN000210: Failed to request state of cache %s from node %s, segments %s";
    }
    @Override
    public final void unableToRemoveEntryAfterActivation(final Object key, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToRemoveEntryAfterActivation$str(), key);
    }
    protected String unableToRemoveEntryAfterActivation$str() {
        return "ISPN000214: Unable to remove entry under %s from cache store after activation";
    }
    protected String unknownMigrator$str() {
        return "ISPN000215: Unknown migrator %s";
    }
    @Override
    public final Exception unknownMigrator(final String migratorName) {
        final Exception result = new Exception(String.format(getLoggingLocale(), unknownMigrator$str(), migratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void entriesMigrated(final long count, final String name, final String prettyTime) {
        super.log.logf(FQCN, INFO, null, entriesMigrated$str(), count, name, prettyTime);
    }
    protected String entriesMigrated$str() {
        return "ISPN000216: %d entries migrated to cache %s in %s";
    }
    protected String remoteException$str() {
        return "ISPN000217: Received exception from %s, see cause for remote stack trace";
    }
    @Override
    public final RemoteException remoteException(final Address sender, final Throwable t) {
        final RemoteException result = new RemoteException(String.format(getLoggingLocale(), remoteException$str(), sender), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void timeoutWaitingUntilTransactionPrepared(final String globalTx) {
        super.log.logf(FQCN, INFO, null, timeoutWaitingUntilTransactionPrepared$str(), globalTx);
    }
    protected String timeoutWaitingUntilTransactionPrepared$str() {
        return "ISPN000218: Timeout while waiting for the transaction validation. The command will not be processed. Transaction is %s";
    }
    protected String customInterceptorMissingClass$str() {
        return "ISPN000222: Custom interceptor missing class";
    }
    @Override
    public final CacheConfigurationException customInterceptorMissingClass() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), customInterceptorMissingClass$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void suggestCustomInterceptorInheritance(final String customInterceptorClassName) {
        super.log.logf(FQCN, WARN, null, suggestCustomInterceptorInheritance$str(), customInterceptorClassName);
    }
    protected String suggestCustomInterceptorInheritance$str() {
        return "ISPN000223: Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended";
    }
    protected String multipleCustomInterceptorPositions$str() {
        return "ISPN000224: Custom interceptor '%s' specifies more than one position";
    }
    @Override
    public final CacheConfigurationException multipleCustomInterceptorPositions(final String customInterceptorClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleCustomInterceptorPositions$str(), customInterceptorClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCustomInterceptorPosition$str() {
        return "ISPN000225: Custom interceptor '%s' doesn't specify a position";
    }
    @Override
    public final CacheConfigurationException missingCustomInterceptorPosition(final String customInterceptorClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCustomInterceptorPosition$str(), customInterceptorClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToRecoverCacheState(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToRecoverCacheState$str(), cacheName);
    }
    protected String failedToRecoverCacheState$str() {
        return "ISPN000228: Failed to recover cache %s state after the current node became the coordinator";
    }
    protected String unexpectedInitialVersion$str() {
        return "ISPN000229: Unexpected initial version type (only NumericVersion instances supported): %s";
    }
    @Override
    public final IllegalArgumentException unexpectedInitialVersion(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedInitialVersion$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void rebalanceStartError(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, rebalanceStartError$str(), cacheName);
    }
    protected String rebalanceStartError$str() {
        return "ISPN000230: Failed to start rebalance for cache %s";
    }
    @Override
    public final void parserRootElementAlreadyRegistered(final String qName, final String oldParser, final String newParser) {
        super.log.logf(FQCN, WARN, null, parserRootElementAlreadyRegistered$str(), qName, oldParser, newParser);
    }
    protected String parserRootElementAlreadyRegistered$str() {
        return "ISPN000234: Root element for %s already registered in ParserRegistry by %s. Cannot install %s.";
    }
    protected String parserDoesNotDeclareNamespaces$str() {
        return "ISPN000235: Configuration parser %s does not declare any Namespace annotations";
    }
    @Override
    public final CacheConfigurationException parserDoesNotDeclareNamespaces(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), parserDoesNotDeclareNamespaces$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String directoryCannotBeCreated$str() {
        return "ISPN000238: Directory %s does not exist and cannot be created!";
    }
    @Override
    public final CacheConfigurationException directoryCannotBeCreated(final String path) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), directoryCannotBeCreated$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingForeignExternalizer$str() {
        return "ISPN000242: Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly";
    }
    @Override
    public final CacheException missingForeignExternalizer(final int foreignId) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), missingForeignExternalizer$str(), foreignId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownExternalizerReaderIndex$str() {
        return "ISPN000243: Type of data read is unknown. Id=%d is not amongst known reader indexes.";
    }
    @Override
    public final CacheException unknownExternalizerReaderIndex(final int readerIndex) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unknownExternalizerReaderIndex$str(), readerIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String advanceExternalizerTypeClassesUndefined$str() {
        return "ISPN000244: AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set";
    }
    @Override
    public final CacheConfigurationException advanceExternalizerTypeClassesUndefined(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), advanceExternalizerTypeClassesUndefined$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateExternalizerIdFound4$str() {
        return "ISPN000245: Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d";
    }
    @Override
    public final CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final Class<?> typeClass, final String otherExternalizer, final int readerIndex) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateExternalizerIdFound4$str(), externalizerId, typeClass, otherExternalizer, readerIndex));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String internalExternalizerIdLimitExceeded$str() {
        return "ISPN000246: Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d";
    }
    @Override
    public final CacheConfigurationException internalExternalizerIdLimitExceeded(final AdvancedExternalizer<?> ext, final int externalizerId, final int maxId) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), internalExternalizerIdLimitExceeded$str(), ext, externalizerId, maxId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String foreignExternalizerUsingNegativeId$str() {
        return "ISPN000247: Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.";
    }
    @Override
    public final CacheConfigurationException foreignExternalizerUsingNegativeId(final AdvancedExternalizer<?> ext, final int externalizerId) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), foreignExternalizerUsingNegativeId$str(), ext, externalizerId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String loaderConfigurationDoesNotSpecifyLoaderClass$str() {
        return "ISPN000249: The cache loader configuration %s does not specify the loader class using @ConfigurationFor";
    }
    @Override
    public final CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), loaderConfigurationDoesNotSpecifyLoaderClass$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorExecutingParallelStoreTask(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorExecutingParallelStoreTask$str());
    }
    protected String errorExecutingParallelStoreTask$str() {
        return "ISPN000252: Error executing parallel store task";
    }
    @Override
    public final void errorProcessingPrepare(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessingPrepare$str());
    }
    protected String errorProcessingPrepare$str() {
        return "ISPN000255: Error while processing prepare";
    }
    @Override
    public final void errorAsyncStoreNotStopped() {
        super.log.logf(FQCN, ERROR, null, errorAsyncStoreNotStopped$str());
    }
    protected String errorAsyncStoreNotStopped$str() {
        return "ISPN000259: Async store executor did not stop properly";
    }
    @Override
    public final void failedOutBoundTransferExecution(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedOutBoundTransferExecution$str());
    }
    protected String failedOutBoundTransferExecution$str() {
        return "ISPN000261: Failed to execute outbound transfer";
    }
    @Override
    public final void failedToEnlistTransactionXaAdapter(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedToEnlistTransactionXaAdapter$str());
    }
    protected String failedToEnlistTransactionXaAdapter$str() {
        return "ISPN000262: Failed to enlist TransactionXaAdapter to transaction";
    }
    @Override
    public final void warnL1NotHavingReaperThread() {
        super.log.logf(FQCN, WARN, null, warnL1NotHavingReaperThread$str());
    }
    protected String warnL1NotHavingReaperThread$str() {
        return "ISPN000264: Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!";
    }
    @Override
    public final void unableToCreateInterceptor(final Class<?> type, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCreateInterceptor$str(), type);
    }
    protected String unableToCreateInterceptor$str() {
        return "ISPN000267: Problems creating interceptor %s";
    }
    @Override
    public final void unableToRollbackInvalidationsDuringPrepare(final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToRollbackInvalidationsDuringPrepare$str());
    }
    protected String unableToRollbackInvalidationsDuringPrepare$str() {
        return "ISPN000268: Unable to broadcast invalidations as a part of the prepare phase. Rolling back.";
    }
    @Override
    public final void warnGridFSMetadataCacheRequiresSync() {
        super.log.logf(FQCN, WARN, null, warnGridFSMetadataCacheRequiresSync$str());
    }
    protected String warnGridFSMetadataCacheRequiresSync$str() {
        return "ISPN000269: Cache used for Grid metadata should be synchronous.";
    }
    @Override
    public final void warnCouldNotCommitLocalTx(final Object transactionDescription, final Throwable e) {
        super.log.logf(FQCN, WARN, e, warnCouldNotCommitLocalTx$str(), transactionDescription);
    }
    protected String warnCouldNotCommitLocalTx$str() {
        return "ISPN000270: Could not commit local tx %s";
    }
    @Override
    public final void warnCouldNotRollbackLocalTx(final Object transactionDescription, final Throwable e) {
        super.log.logf(FQCN, WARN, e, warnCouldNotRollbackLocalTx$str(), transactionDescription);
    }
    protected String warnCouldNotRollbackLocalTx$str() {
        return "ISPN000271: Could not rollback local tx %s";
    }
    @Override
    public final void warnExceptionRemovingRecovery(final Throwable e) {
        super.log.logf(FQCN, WARN, e, warnExceptionRemovingRecovery$str());
    }
    protected String warnExceptionRemovingRecovery$str() {
        return "ISPN000272: Exception removing recovery information";
    }
    protected String invalidConfigurationIndexingWithInvalidation$str() {
        return "ISPN000273: Indexing can not be enabled on caches in Invalidation mode";
    }
    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithInvalidation() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidConfigurationIndexingWithInvalidation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void persistenceWithoutCacheLoaderInterceptor() {
        super.log.logf(FQCN, ERROR, null, persistenceWithoutCacheLoaderInterceptor$str());
    }
    protected String persistenceWithoutCacheLoaderInterceptor$str() {
        return "ISPN000274: Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!";
    }
    @Override
    public final void persistenceWithoutCacheWriteInterceptor() {
        super.log.logf(FQCN, ERROR, null, persistenceWithoutCacheWriteInterceptor$str());
    }
    protected String persistenceWithoutCacheWriteInterceptor$str() {
        return "ISPN000275: Persistence enabled without any CacheWriteInterceptor in InterceptorChain!";
    }
    @Override
    public final void keyMigrationFailed(final String key, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, keyMigrationFailed$str(), key);
    }
    protected String keyMigrationFailed$str() {
        return "ISPN000277: Could not migrate key %s";
    }
    protected String invalidConfigurationIndexingWithoutModule$str() {
        return "ISPN000278: Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.";
    }
    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithoutModule() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidConfigurationIndexingWithoutModule$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorReadingFileStore$str() {
        return "ISPN000279: Failed to read stored entries from file. Error in file %s at offset %d";
    }
    @Override
    public final PersistenceException errorReadingFileStore(final String path, final long offset) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), errorReadingFileStore$str(), path, offset));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exceptionInvokingListener$str() {
        return "ISPN000280: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    }
    @Override
    public final CacheListenerException exceptionInvokingListener(final String name, final Method m, final Object target, final Throwable cause) {
        final CacheListenerException result = new CacheListenerException(String.format(getLoggingLocale(), exceptionInvokingListener$str(), name, m, target), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String thirdPartySuspected$str() {
        return "ISPN000281: %s reported that a third node was suspected, see cause for info on the node that was suspected";
    }
    @Override
    public final SuspectException thirdPartySuspected(final Address sender, final SuspectException e) {
        final SuspectException result = new SuspectException(String.format(getLoggingLocale(), thirdPartySuspected$str(), sender), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invocationBatchingNeedsTransactionalCache$str() {
        return "ISPN000282: Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL";
    }
    @Override
    public final CacheConfigurationException invocationBatchingNeedsTransactionalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingNeedsTransactionalCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invocationBatchingCannotBeRecoverable$str() {
        return "ISPN000283: A cache configured with invocation batching can't have recovery enabled";
    }
    @Override
    public final CacheConfigurationException invocationBatchingCannotBeRecoverable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingCannotBeRecoverable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void clusterListenerInstallationFailure(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, clusterListenerInstallationFailure$str());
    }
    protected String clusterListenerInstallationFailure$str() {
        return "ISPN000284: Problem encountered while installing cluster listener";
    }
    @Override
    public final void unsuccessfulResponseForClusterListeners(final Address address, final Response response) {
        super.log.logf(FQCN, WARN, null, unsuccessfulResponseForClusterListeners$str(), address, response);
    }
    protected String unsuccessfulResponseForClusterListeners$str() {
        return "ISPN000285: Issue when retrieving cluster listeners from %s response was %s";
    }
    @Override
    public final void exceptionDuringClusterListenerRetrieval(final Address address, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, exceptionDuringClusterListenerRetrieval$str(), address);
    }
    protected String exceptionDuringClusterListenerRetrieval$str() {
        return "ISPN000286: Issue when retrieving cluster listeners from %s";
    }
    protected String unauthorizedAccess$str() {
        return "ISPN000287: Unauthorized access: subject '%s' lacks '%s' permission";
    }
    @Override
    public final SecurityException unauthorizedAccess(final String subject, final String permission) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unauthorizedAccess$str(), subject, permission));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPrincipalRoleMapper$str() {
        return "ISPN000288: A principal-to-role mapper has not been specified";
    }
    @Override
    public final CacheConfigurationException invalidPrincipalRoleMapper() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidPrincipalRoleMapper$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToSendXSiteState(final String site, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToSendXSiteState$str(), site);
    }
    protected String unableToSendXSiteState$str() {
        return "ISPN000289: Cannot send cross-site state chunk to '%s'.";
    }
    @Override
    public final void unableToApplyXSiteState(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToApplyXSiteState$str());
    }
    protected String unableToApplyXSiteState$str() {
        return "ISPN000291: Cannot apply cross-site state chunk.";
    }
    @Override
    public final void unrecognizedAttribute(final String property) {
        super.log.logf(FQCN, WARN, null, unrecognizedAttribute$str(), property);
    }
    protected String unrecognizedAttribute$str() {
        return "ISPN000292: Unrecognized attribute '%s'. Please check your configuration. Ignoring!";
    }
    @Override
    public final void ignoreXmlAttribute(final Object attribute, final int line, final int column) {
        super.log.logf(FQCN, INFO, null, ignoreXmlAttribute$str(), attribute, line, column);
    }
    protected String ignoreXmlAttribute$str() {
        return "ISPN000293: Ignoring XML attribute %s at [%d,%d], please remove from configuration file";
    }
    @Override
    public final void ignoreXmlElement(final Object element, final int line, final int column) {
        super.log.logf(FQCN, INFO, null, ignoreXmlElement$str(), element, line, column);
    }
    protected String ignoreXmlElement$str() {
        return "ISPN000294: Ignoring XML element %s at [%d,%d], please remove from configuration file";
    }
    protected String undefinedThreadPoolName$str() {
        return "ISPN000295: No thread pool with name '%s' found";
    }
    @Override
    public final CacheConfigurationException undefinedThreadPoolName(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), undefinedThreadPoolName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPermission$str() {
        return "ISPN000296: Attempt to add a %s permission to a SecurityPermissionCollection";
    }
    @Override
    public final IllegalArgumentException invalidPermission(final Permission permission) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermission$str(), permission));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readOnlyPermissionCollection$str() {
        return "ISPN000297: Attempt to add a permission to a read-only SecurityPermissionCollection";
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void authorizationEnabledWithoutSecurityManager() {
        super.log.logf(FQCN, DEBUG, null, authorizationEnabledWithoutSecurityManager$str());
    }
    protected String authorizationEnabledWithoutSecurityManager$str() {
        return "ISPN000298: Using internal security checker";
    }
    protected String unableToAcquireLock$str() {
        return "ISPN000299: Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s";
    }
    @Override
    public final TimeoutException unableToAcquireLock(final String timeout, final Object key, final Object requestor, final Object owner) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), unableToAcquireLock$str(), timeout, key, requestor, owner));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exceptionProcessingEntryRetrievalValues$str() {
        return "ISPN000300: There was an exception while processing retrieval of entry values";
    }
    @Override
    public final CacheException exceptionProcessingEntryRetrievalValues(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), exceptionProcessingEntryRetrievalValues$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unsuccessfulResponseRetrievingTransactionsForSegments(final Address address, final Response response) {
        super.log.logf(FQCN, WARN, null, unsuccessfulResponseRetrievingTransactionsForSegments$str(), address, response);
    }
    protected String unsuccessfulResponseRetrievingTransactionsForSegments$str() {
        return "ISPN000302: Issue when retrieving transactions from %s, response was %s";
    }
    @Override
    public final void ambiguousConfigurationFiles(final String files) {
        super.log.logf(FQCN, WARN, null, ambiguousConfigurationFiles$str(), files);
    }
    protected String ambiguousConfigurationFiles$str() {
        return "ISPN000304: More than one configuration file with specified name on classpath. The first one will be used:\n %s";
    }
    protected String partitionDegraded$str() {
        return "ISPN000305: Cluster is operating in degraded mode because of node failures.";
    }
    @Override
    public final AvailabilityException partitionDegraded() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), partitionDegraded$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String degradedModeKeyUnavailable$str() {
        return "ISPN000306: Key '%s' is not available. Not all owners are in this partition";
    }
    @Override
    public final AvailabilityException degradedModeKeyUnavailable(final Object key) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeKeyUnavailable$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clearDisallowedWhilePartitioned$str() {
        return "ISPN000307: Cannot clear when the cluster is partitioned";
    }
    @Override
    public final AvailabilityException clearDisallowedWhilePartitioned() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), clearDisallowedWhilePartitioned$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void rebalancingEnabled() {
        super.log.logf(FQCN, INFO, null, rebalancingEnabled$str());
    }
    protected String rebalancingEnabled$str() {
        return "ISPN000308: Rebalancing enabled";
    }
    @Override
    public final void rebalancingSuspended() {
        super.log.logf(FQCN, INFO, null, rebalancingSuspended$str());
    }
    protected String rebalancingSuspended$str() {
        return "ISPN000309: Rebalancing suspended";
    }
    @Override
    public final void startingRebalancePhase(final String cacheName, final CacheTopology cacheTopology) {
        super.log.logf(FQCN, DEBUG, null, startingRebalancePhase$str(), cacheName, cacheTopology);
    }
    protected String startingRebalancePhase$str() {
        return "ISPN000310: Starting new rebalance phase for cache %s, topology %s";
    }
    @Override
    public final void stopOrderIgnored() {
        super.log.logf(FQCN, WARN, null, stopOrderIgnored$str());
    }
    protected String stopOrderIgnored$str() {
        return "ISPN000321: Cyclic dependency detected between caches, stop order ignored";
    }
    @Override
    public final void failedToRestartXSiteStateTransfer(final String siteName, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToRestartXSiteStateTransfer$str(), siteName);
    }
    protected String failedToRestartXSiteStateTransfer$str() {
        return "ISPN000322: Cannot restart cross-site state transfer to site %s";
    }
    protected String cacheIsTerminated$str() {
        return "ISPN000323: %s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.";
    }
    @Override
    public final IllegalLifecycleStateException cacheIsTerminated(final String cacheName, final String state) {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheIsTerminated$str(), cacheName, state));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheIsStopping$str() {
        return "ISPN000324: %s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.";
    }
    @Override
    public final IllegalLifecycleStateException cacheIsStopping(final String cacheName) {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheIsStopping$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String creatingTmpCacheTimedOut$str() {
        return "ISPN000325: Creating tmp cache %s timed out waiting for rebalancing to complete on node %s ";
    }
    @Override
    public final RuntimeException creatingTmpCacheTimedOut(final String cacheName, final Address address) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), creatingTmpCacheTimedOut$str(), cacheName, address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void remoteTransactionTimeout(final GlobalTransaction gtx, final long ageMilliSeconds) {
        super.log.logf(FQCN, WARN, null, remoteTransactionTimeout$str(), gtx, ageMilliSeconds);
    }
    protected String remoteTransactionTimeout$str() {
        return "ISPN000326: Remote transaction %s timed out. Rolling back after %d ms";
    }
    protected String unsupportedConfiguration$str() {
        return "ISPN000327: Cannot find a parser for element '%s' in namespace '%s'. Check that your configuration is up-to date for Infinispan '%s' and if you have the proper dependency in the classpath";
    }
    @Override
    public final CacheConfigurationException unsupportedConfiguration(final String element, final String namespaceUri, final String version) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unsupportedConfiguration$str(), element, namespaceUri, version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void rebalancePhaseConfirmedOnNode(final Phase phase, final String cacheName, final Address node, final int topologyId) {
        super.log.logf(FQCN, DEBUG, null, rebalancePhaseConfirmedOnNode$str(), phase, cacheName, node, topologyId);
    }
    protected String rebalancePhaseConfirmedOnNode$str() {
        return "ISPN000328: Rebalance phase %s confirmed for cache %s on node %s, topology id = %d";
    }
    @Override
    public final void errorReadingRebalancingStatus(final Address coordinator, final Throwable t) {
        super.log.logf(FQCN, WARN, t, errorReadingRebalancingStatus$str(), coordinator);
    }
    protected String errorReadingRebalancingStatus$str() {
        return "ISPN000329: Unable to read rebalancing status from coordinator %s";
    }
    @Override
    public final void unableToInvokeListenerMethod(final Method m, final Object target, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToInvokeListenerMethod$str(), m, target);
    }
    protected String unableToInvokeListenerMethod$str() {
        return "ISPN000331: Unable to invoke method %s on Object instance %s ";
    }
    protected String twoPhaseCommitAsyncBackup$str() {
        return "ISPN000335: Two-phase commit can only be used with synchronous backup strategy.";
    }
    @Override
    public final CacheConfigurationException twoPhaseCommitAsyncBackup() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), twoPhaseCommitAsyncBackup$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void finishedRebalance(final String cacheName, final CacheTopology topology) {
        super.log.logf(FQCN, DEBUG, null, finishedRebalance$str(), cacheName, topology);
    }
    protected String finishedRebalance$str() {
        return "ISPN000336: Finished rebalance for cache %s, topology %s";
    }
    protected String backupMissingSite$str() {
        return "ISPN000337: Backup configuration must include a 'site'.";
    }
    @Override
    public final CacheConfigurationException backupMissingSite() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupMissingSite$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingBackupFailurePolicyClass$str() {
        return "ISPN000338: You must specify a 'failure-policy-class' to use a custom backup failure policy for backup '%s'.";
    }
    @Override
    public final CacheConfigurationException missingBackupFailurePolicyClass(final String remoteSite) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingBackupFailurePolicyClass$str(), remoteSite));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupForNullCache$str() {
        return "ISPN000339: Remote cache name is missing or null in backup configuration.";
    }
    @Override
    public final CacheConfigurationException backupForNullCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupForNullCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupForMissingParameters$str() {
        return "ISPN000340: Remote cache name and remote site is missing or null in backup configuration.";
    }
    @Override
    public final CacheConfigurationException backupForMissingParameters() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupForMissingParameters$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTransportConfiguration$str() {
        return "ISPN000343: Must have a transport set in the global configuration in order to define a clustered cache";
    }
    @Override
    public final CacheConfigurationException missingTransportConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTransportConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidReaperWakeUpInterval$str() {
        return "ISPN000344: reaperWakeUpInterval must be >= 0, we got %d";
    }
    @Override
    public final CacheConfigurationException invalidReaperWakeUpInterval(final long timeout) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidReaperWakeUpInterval$str(), timeout));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCompletedTxTimeout$str() {
        return "ISPN000345: completedTxTimeout must be >= 0, we got %d";
    }
    @Override
    public final CacheConfigurationException invalidCompletedTxTimeout(final long timeout) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCompletedTxTimeout$str(), timeout));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String l1OnlyForDistributedCache$str() {
        return "ISPN000350: Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s";
    }
    @Override
    public final CacheConfigurationException l1OnlyForDistributedCache(final String cacheMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1OnlyForDistributedCache$str(), cacheMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String l1InvalidLifespan$str() {
        return "ISPN000351: Using a L1 lifespan of 0 or a negative value is meaningless";
    }
    @Override
    public final CacheConfigurationException l1InvalidLifespan() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1InvalidLifespan$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String l1NotValidWithExpirationEviction$str() {
        return "ISPN000352: Enabling the L1 cache is not supported when using EXCEPTION based eviction.";
    }
    @Override
    public final CacheConfigurationException l1NotValidWithExpirationEviction() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1NotValidWithExpirationEviction$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorClassAndInstanceDefined$str() {
        return "ISPN000354: Cannot define both interceptor class (%s) and interceptor instance (%s)";
    }
    @Override
    public final CacheConfigurationException interceptorClassAndInstanceDefined(final String customInterceptorClassName, final String customInterceptor) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), interceptorClassAndInstanceDefined$str(), customInterceptorClassName, customInterceptor));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateClass$str() {
        return "ISPN000355: Unable to instantiate loader/writer instance for StoreConfiguration %s";
    }
    @Override
    public final CacheConfigurationException unableToInstantiateClass(final Class<?> storeConfigurationClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), storeConfigurationClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xaResourceEndFailed(final XAResource resource, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xaResourceEndFailed$str(), resource);
    }
    protected String xaResourceEndFailed$str() {
        return "ISPN000357: end() failed for %s";
    }
    protected String existingConfigForInternalCache$str() {
        return "ISPN000358: A cache configuration named %s already exists. This cannot be configured externally by the user.";
    }
    @Override
    public final CacheConfigurationException existingConfigForInternalCache(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingConfigForInternalCache$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String degradedModeKeysUnavailable$str() {
        return "ISPN000359: Keys '%s' are not available. Not all owners are in this partition";
    }
    @Override
    public final AvailabilityException degradedModeKeysUnavailable(final Collection<?> keys) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeKeysUnavailable$str(), keys));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void evictionExecutorDeprecated() {
        super.log.logf(FQCN, WARN, null, evictionExecutorDeprecated$str());
    }
    protected String evictionExecutorDeprecated$str() {
        return "ISPN000360: The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.";
    }
    protected String remoteTransactionAlreadyRolledBack$str() {
        return "ISPN000361: Cannot commit remote transaction %s as it was already rolled back";
    }
    @Override
    public final CacheException remoteTransactionAlreadyRolledBack(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionAlreadyRolledBack$str(), gtx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteTransactionStatusMissing$str() {
        return "ISPN000362: Could not find status for remote transaction %s, please increase transaction.completedTxTimeout";
    }
    @Override
    public final TimeoutException remoteTransactionStatusMissing(final GlobalTransaction gtx) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), remoteTransactionStatusMissing$str(), gtx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void noFilterIndexingServiceProviderFound(final String filterClassName) {
        super.log.logf(FQCN, WARN, null, noFilterIndexingServiceProviderFound$str(), filterClassName);
    }
    protected String noFilterIndexingServiceProviderFound$str() {
        return "ISPN000363: No filter indexing service provider found for indexed filter of type %s";
    }
    protected String clusterListenerRegisteredWithOnlyPreEvents$str() {
        return "ISPN000364: Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!";
    }
    @Override
    public final CacheException clusterListenerRegisteredWithOnlyPreEvents(final Class<?> listenerClass) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), clusterListenerRegisteredWithOnlyPreEvents$str(), listenerClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsConfigurationNotFound$str() {
        return "ISPN000365: Could not find the specified JGroups configuration file '%s'";
    }
    @Override
    public final CacheConfigurationException jgroupsConfigurationNotFound(final String cfg) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsConfigurationNotFound$str(), cfg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToAddNullCustomStore$str() {
        return "ISPN000366: Unable to add a 'null' Custom Cache Store";
    }
    @Override
    public final IllegalArgumentException unableToAddNullCustomStore() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToAddNullCustomStore$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configurationInUse$str() {
        return "ISPN000371: Cannot remove cache configuration '%s' because it is in use";
    }
    @Override
    public final IllegalStateException configurationInUse(final String configurationName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationInUse$str(), configurationName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String statisticsEnabledNotAvailable$str() {
        return "ISPN000372: Statistics are enabled while attribute 'available' is set to false.";
    }
    @Override
    public final CacheConfigurationException statisticsEnabledNotAvailable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), statisticsEnabledNotAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String templateConfigurationStartAttempt$str() {
        return "ISPN000373: Attempted to start a cache using configuration template '%s'";
    }
    @Override
    public final CacheConfigurationException templateConfigurationStartAttempt(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), templateConfigurationStartAttempt$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undeclaredConfiguration$str() {
        return "ISPN000374: No such template '%s' when declaring '%s'";
    }
    @Override
    public final CacheConfigurationException undeclaredConfiguration(final String template, final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), undeclaredConfiguration$str(), template, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfiguration$str() {
        return "ISPN000375: Cannot use configuration '%s' as a template";
    }
    @Override
    public final CacheConfigurationException noConfiguration(final String extend) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noConfiguration$str(), extend));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorStackNotSupported$str() {
        return "ISPN000376: Interceptor stack is not supported in simple cache";
    }
    @Override
    public final UnsupportedOperationException interceptorStackNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), interceptorStackNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String lockOperationsNotSupported$str() {
        return "ISPN000377: Explicit lock operations are not supported in simple cache";
    }
    @Override
    public final UnsupportedOperationException lockOperationsNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), lockOperationsNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invocationBatchingNotEnabled$str() {
        return "ISPN000378: Invocation batching not enabled in current configuration! Please enable it.";
    }
    @Override
    public final CacheConfigurationException invocationBatchingNotEnabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingNotEnabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notSupportedInSimpleCache$str() {
        return "ISPN000381: This configuration is not supported for simple cache";
    }
    @Override
    public final CacheConfigurationException notSupportedInSimpleCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), notSupportedInSimpleCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void missingGlobalStatePersistentLocation() {
        super.log.logf(FQCN, WARN, null, missingGlobalStatePersistentLocation$str());
    }
    protected String missingGlobalStatePersistentLocation$str() {
        return "ISPN000382: Global state persistence was enabled without specifying a location";
    }
    protected String unableToBroadcastInvalidation$str() {
        return "ISPN000384: Unable to broadcast invalidation messages";
    }
    @Override
    public final RuntimeException unableToBroadcastInvalidation(final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToBroadcastInvalidation$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedReadingPersistentState$str() {
        return "ISPN000386: Failed to read persisted state from file %s. Aborting.";
    }
    @Override
    public final CacheConfigurationException failedReadingPersistentState(final IOException e, final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), failedReadingPersistentState$str(), stateFile), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedWritingGlobalState$str() {
        return "ISPN000387: Failed to write state to file %s.";
    }
    @Override
    public final CacheConfigurationException failedWritingGlobalState(final IOException e, final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), failedWritingGlobalState$str(), stateFile), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonWritableStateFile$str() {
        return "ISPN000388: The state file %s is not writable. Aborting.";
    }
    @Override
    public final CacheConfigurationException nonWritableStateFile(final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonWritableStateFile$str(), stateFile));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void globalStateLoad(final String version, final String timestamp) {
        super.log.logf(FQCN, INFO, null, globalStateLoad$str(), version, timestamp);
    }
    protected String globalStateLoad$str() {
        return "ISPN000389: Loaded global state, version=%s timestamp=%s";
    }
    @Override
    public final void globalStateWrite(final String version, final String timestamp) {
        super.log.logf(FQCN, INFO, null, globalStateWrite$str(), version, timestamp);
    }
    protected String globalStateWrite$str() {
        return "ISPN000390: Persisted state, version=%s timestamp=%s";
    }
    protected String recoveryNotSupportedWithNonTxCache$str() {
        return "ISPN000391: Recovery not supported with non transactional cache";
    }
    @Override
    public final CacheConfigurationException recoveryNotSupportedWithNonTxCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), recoveryNotSupportedWithNonTxCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String recoveryNotSupportedWithSynchronization$str() {
        return "ISPN000392: Recovery not supported with Synchronization";
    }
    @Override
    public final CacheConfigurationException recoveryNotSupportedWithSynchronization() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), recoveryNotSupportedWithSynchronization$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void transactionNotificationsDisabled() {
        super.log.logf(FQCN, INFO, null, transactionNotificationsDisabled$str());
    }
    protected String transactionNotificationsDisabled$str() {
        return "ISPN000395: Transaction notifications are disabled.  This prevents cluster listeners from working properly!";
    }
    @Override
    public final void ignoringUnsolicitedState(final Address node, final int segment, final String cacheName) {
        super.log.logf(FQCN, DEBUG, null, ignoringUnsolicitedState$str(), node, segment, cacheName);
    }
    protected String ignoringUnsolicitedState$str() {
        return "ISPN000396: Received unsolicited state from node %s for segment %d of cache %s";
    }
    protected String persistentConsistentHashMismatch$str() {
        return "ISPN000398: CH Factory '%s' cannot restore a persisted CH of class '%s'";
    }
    @Override
    public final IllegalStateException persistentConsistentHashMismatch(final String hashFactory, final String consistentHashClass) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), persistentConsistentHashMismatch$str(), hashFactory, consistentHashClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timeoutWaitingForInitialNodes$str() {
        return "ISPN000399: Timeout while waiting for %d members in cluster. Last view had %s";
    }
    @Override
    public final TimeoutException timeoutWaitingForInitialNodes(final int initialClusterSize, final List<?> members) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForInitialNodes$str(), initialClusterSize, members));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteNodeSuspected$str() {
        return "ISPN000400: Node %s was suspected";
    }
    @Override
    public final SuspectException remoteNodeSuspected(final Address address) {
        final SuspectException result = new SuspectException(String.format(getLoggingLocale(), remoteNodeSuspected$str(), address));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteNodeTimedOut$str() {
        return "ISPN000401: Node %s timed out, time : %s %s";
    }
    @Override
    public final TimeoutException remoteNodeTimedOut(final Address address, final long time, final TimeUnit unit) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), remoteNodeTimedOut$str(), address, time, unit));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String coordinatorTimeoutWaitingForView$str() {
        return "ISPN000402: Timeout waiting for view %d. Current view is %d, current status is %s";
    }
    @Override
    public final TimeoutException coordinatorTimeoutWaitingForView(final int expectedViewId, final int currentViewId, final Object clusterManagerStatus) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), coordinatorTimeoutWaitingForView$str(), expectedViewId, currentViewId, clusterManagerStatus));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIndexableClassesDefined$str() {
        return "ISPN000403: No indexable classes were defined for this indexed cache. The configuration must contain classes or protobuf message types annotated with '@Indexed'";
    }
    @Override
    public final CacheConfigurationException noIndexableClassesDefined() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noIndexableClassesDefined$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedInvokingCacheManagerListener(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedInvokingCacheManagerListener$str());
    }
    protected String failedInvokingCacheManagerListener$str() {
        return "ISPN000405: Caught exception while invoking a cache manager listener!";
    }
    @Override
    public final void ignoredReplicationQueueAttribute(final String attributeName, final int line) {
        super.log.logf(FQCN, WARN, null, ignoredReplicationQueueAttribute$str(), attributeName, line);
    }
    protected String ignoredReplicationQueueAttribute$str() {
        return "ISPN000406: The replication queue is no longer supported since version 9.0. Attribute %s on line %d will be ignored.";
    }
    protected String extraneousMembersJoinRestoredCache$str() {
        return "ISPN000407: Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state";
    }
    @Override
    public final CacheJoinException extraneousMembersJoinRestoredCache(final List<Address> extraneousMembers, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), extraneousMembersJoinRestoredCache$str(), extraneousMembers, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeWithPersistentStateJoiningClusterWithoutState$str() {
        return "ISPN000408: Node %s with persistent state attempting to join cache %s on cluster without state";
    }
    @Override
    public final CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithPersistentStateJoiningClusterWithoutState$str(), joiner, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeWithoutPersistentStateJoiningCacheWithState$str() {
        return "ISPN000409: Node %s without persistent state attempting to join cache %s on cluster with state";
    }
    @Override
    public final CacheJoinException nodeWithoutPersistentStateJoiningCacheWithState(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithoutPersistentStateJoiningCacheWithState$str(), joiner, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeWithIncompatibleStateJoiningCache$str() {
        return "ISPN000410: Node %s attempting to join cache %s with incompatible state";
    }
    @Override
    public final CacheJoinException nodeWithIncompatibleStateJoiningCache(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithIncompatibleStateJoiningCache$str(), joiner, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownTransactionConfiguration$str() {
        return "ISPN000412: Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s";
    }
    @Override
    public final CacheConfigurationException unknownTransactionConfiguration(final TransactionMode mode, final boolean xaEnabled, final boolean recoveryEnabled, final boolean batchingEnabled) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownTransactionConfiguration$str(), mode, xaEnabled, recoveryEnabled, batchingEnabled));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToInstantiateSerializer$str() {
        return "ISPN000413: Unable to instantiate serializer for %s";
    }
    @Override
    public final CacheConfigurationException unableToInstantiateSerializer(final Class<?> storeConfigurationClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToInstantiateSerializer$str(), storeConfigurationClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String globalSecurityAuthShouldBeEnabled$str() {
        return "ISPN000414: Global security authorization should be enabled if cache authorization enabled.";
    }
    @Override
    public final CacheConfigurationException globalSecurityAuthShouldBeEnabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalSecurityAuthShouldBeEnabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoredAttribute(final String componentName, final String version, final String attributeName, final int line) {
        super.log.logf(FQCN, WARN, null, ignoredAttribute$str(), componentName, version, attributeName, line);
    }
    protected String ignoredAttribute$str() {
        return "ISPN000415: The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.";
    }
    protected String transactionalStoreInNonTransactionalCache$str() {
        return "ISPN000417: It is not possible for a store to be transactional in a non-transactional cache. ";
    }
    @Override
    public final CacheConfigurationException transactionalStoreInNonTransactionalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreInNonTransactionalCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionalStoreInPassivatedCache$str() {
        return "ISPN000418: It is not possible for a store to be transactional when passivation is enabled. ";
    }
    @Override
    public final CacheConfigurationException transactionalStoreInPassivatedCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreInPassivatedCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void evictionDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, evictionDisabled$str(), cacheName);
    }
    protected String evictionDisabled$str() {
        return "ISPN000419: Eviction of an entry invoked without an explicit eviction strategy for cache %s";
    }
    protected String attributeNotAllowedInInvalidationMode$str() {
        return "ISPN000420: Cannot enable '%s' in invalidation caches!";
    }
    @Override
    public final CacheConfigurationException attributeNotAllowedInInvalidationMode(final String attributeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), attributeNotAllowedInInvalidationMode$str(), attributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void viewHandlingError(final int viewId, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, viewHandlingError$str(), viewId);
    }
    protected String viewHandlingError$str() {
        return "ISPN000421: Error while handling view %s";
    }
    protected String failedWaitingForTopology$str() {
        return "ISPN000422: Failed waiting for topology %d";
    }
    @Override
    public final TimeoutException failedWaitingForTopology(final int requestTopologyId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), failedWaitingForTopology$str(), requestTopologyId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateExternalizerIdFound2$str() {
        return "ISPN000423: Duplicate id found! AdvancedExternalizer id=%d is shared by another externalizer (%s)";
    }
    @Override
    public final CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final String otherExternalizer) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateExternalizerIdFound2$str(), externalizerId, otherExternalizer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEvictionSize$str() {
        return "ISPN000424: Memory eviction is enabled, please specify a maximum size or count greater than zero";
    }
    @Override
    public final CacheConfigurationException invalidEvictionSize() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidEvictionSize$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timeoutWaitingForAcks$str() {
        return "ISPN000427: Timeout after %s waiting for acks (%s). Id=%s";
    }
    @Override
    public final TimeoutException timeoutWaitingForAcks(final String timeout, final String address, final long id) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForAcks$str(), timeout, address, id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void configDeprecatedUseOther(final Enum<?> element, final Enum<?> other) {
        super.log.logf(FQCN, WARN, null, configDeprecatedUseOther$str(), element, other);
    }
    protected String configDeprecatedUseOther$str() {
        return "ISPN000428: '%s' has been deprecated. Please use '%s' instead";
    }
    protected String writeSkewOnRead$str() {
        return "ISPN000429: On key %s previous read version (%s) is different from currently read version (%s)";
    }
    @Override
    public final WriteSkewException writeSkewOnRead(final Object key, final Object key2, final EntryVersion lastVersion, final EntryVersion remoteVersion) {
        final WriteSkewException result = new WriteSkewException(String.format(getLoggingLocale(), writeSkewOnRead$str(), key2, lastVersion, remoteVersion), key);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonSharedStoreConfiguredAsShared$str() {
        return "ISPN000430: %s cannot be shared";
    }
    @Override
    public final CacheConfigurationException nonSharedStoreConfiguredAsShared(final String storeType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonSharedStoreConfiguredAsShared$str(), storeType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingDefaultCacheDeclaration$str() {
        return "ISPN000432: Missing configuration for default cache '%s' declared on container";
    }
    @Override
    public final CacheConfigurationException missingDefaultCacheDeclaration(final String defaultCache) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingDefaultCacheDeclaration$str(), defaultCache));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultCache$str() {
        return "ISPN000433: A default cache has been requested, but no cache has been set as default for this container";
    }
    @Override
    public final CacheConfigurationException noDefaultCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noDefaultCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultCacheConfigurationWithoutName$str() {
        return "ISPN000435: Cache manager initialized with a default cache configuration but without a name for it. Set it in the GlobalConfiguration.";
    }
    @Override
    public final CacheConfigurationException defaultCacheConfigurationWithoutName() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), defaultCacheConfigurationWithoutName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchCacheConfiguration$str() {
        return "ISPN000436: Cache '%s' has been requested, but no matching cache configuration exists";
    }
    @Override
    public final CacheConfigurationException noSuchCacheConfiguration(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSuchCacheConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnConfigurationForAnnotationMissing(final String name) {
        super.log.logf(FQCN, WARN, null, warnConfigurationForAnnotationMissing$str(), name);
    }
    protected String warnConfigurationForAnnotationMissing$str() {
        return "ISPN000437: Unable to validate %s with the implementing store as the @ConfigurationFor annotation is missing";
    }
    protected String duplicateCacheName$str() {
        return "ISPN000438: Cache with name %s is defined more than once!";
    }
    @Override
    public final CacheConfigurationException duplicateCacheName(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateCacheName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void receivedXSiteClusterView(final Collection<String> view) {
        super.log.logf(FQCN, INFO, null, receivedXSiteClusterView$str(), view);
    }
    protected String receivedXSiteClusterView$str() {
        return "ISPN000439: Received new cross-site view: %s";
    }
    @Override
    public final void errorSendingResponse(final long requestId, final org.jgroups.Address origin, final ReplicableCommand command) {
        super.log.logf(FQCN, ERROR, null, errorSendingResponse$str(), requestId, origin, command);
    }
    protected String errorSendingResponse$str() {
        return "ISPN000440: Error sending response for request %d@%s, command %s";
    }
    protected String unsupportedAsyncCacheMode1$str() {
        return "ISPN000441: Unsupported async cache mode '%s' for transactional caches";
    }
    @Override
    public final CacheConfigurationException unsupportedAsyncCacheMode(final CacheMode cacheMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unsupportedAsyncCacheMode1$str(), cacheMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clusteredTransactionalStoreMustBeShared$str() {
        return "ISPN000443: Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.";
    }
    @Override
    public final CacheConfigurationException clusteredTransactionalStoreMustBeShared(final String simpleName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), clusteredTransactionalStoreMustBeShared$str(), simpleName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionalStoreCannotBeAsync$str() {
        return "ISPN000444: Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.";
    }
    @Override
    public final CacheConfigurationException transactionalStoreCannotBeAsync(final String simpleName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreCannotBeAsync$str(), simpleName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleSitesWithSameName$str() {
        return "ISPN000446: Multiple sites have the same name '%s'. This configuration is not valid.";
    }
    @Override
    public final CacheConfigurationException multipleSitesWithSameName(final String site) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleSitesWithSameName$str(), site));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String awaitInitialTransferOnlyForDistOrRepl$str() {
        return "ISPN000448: 'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.";
    }
    @Override
    public final CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), awaitInitialTransferOnlyForDistOrRepl$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidXSiteStateTransferTimeout$str() {
        return "ISPN000449: Timeout value for cross-site replication state transfer must be equal to or greater than one.";
    }
    @Override
    public final CacheConfigurationException invalidXSiteStateTransferTimeout() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidXSiteStateTransferTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidXSiteStateTransferWaitTime$str() {
        return "ISPN000450: Wait time between retries for cross-site replication state transfer must be equal to or greater than one.";
    }
    @Override
    public final CacheConfigurationException invalidXSiteStateTransferWaitTime() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidXSiteStateTransferWaitTime$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timeoutWaitingForView$str() {
        return "ISPN000451: Timed out waiting for view %d, current view is %d";
    }
    @Override
    public final TimeoutException timeoutWaitingForView(final int expectedViewId, final int currentViewId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForView$str(), expectedViewId, currentViewId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void topologyUpdateError(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, topologyUpdateError$str(), cacheName);
    }
    protected String topologyUpdateError$str() {
        return "ISPN000452: Failed to update topology for cache %s";
    }
    protected String configAlreadyDefined$str() {
        return "ISPN000453: Attempt to define configuration for cache %s which already exists";
    }
    @Override
    public final CacheConfigurationException configAlreadyDefined(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configAlreadyDefined$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void transactionCleanupError(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, transactionCleanupError$str());
    }
    protected String transactionCleanupError$str() {
        return "ISPN000455: Failure during leaver transactions cleanup";
    }
    protected String invalidEncodingClass$str() {
        return "ISPN000461: Class %s should be a subclass of %s";
    }
    @Override
    public final CacheException invalidEncodingClass(final Class<?> configured, final Class<?> required) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), invalidEncodingClass$str(), configured, required));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConflictsAlreadyInProgress$str() {
        return "ISPN000462: ConflictManager.getConflicts() already in progress";
    }
    @Override
    public final IllegalStateException getConflictsAlreadyInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getConflictsAlreadyInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getConflictsStateTransferInProgress$str() {
        return "ISPN000463: Unable to retrieve conflicts as StateTransfer is currently in progress for cache '%s'";
    }
    @Override
    public final IllegalStateException getConflictsStateTransferInProgress(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getConflictsStateTransferInProgress$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void partitionHandlingConfigurationEnabledDeprecated() {
        super.log.logf(FQCN, WARN, null, partitionHandlingConfigurationEnabledDeprecated$str());
    }
    protected String partitionHandlingConfigurationEnabledDeprecated$str() {
        return "ISPN000464: The partition handling 'enabled' attribute has been deprecated. Please update your configuration to use 'when-split' instead";
    }
    @Override
    public final void exceptionDuringConflictResolution(final Object key, final Throwable t) {
        super.log.logf(FQCN, WARN, null, exceptionDuringConflictResolution$str(), key, t);
    }
    protected String exceptionDuringConflictResolution$str() {
        return "ISPN000466: Exception encountered when trying to resolve conflict on Keys '%s': %s";
    }
    protected String scatteredCacheNeedsSingleOwner$str() {
        return "ISPN000467: Scattered cache supports only single owner.";
    }
    @Override
    public final CacheConfigurationException scatteredCacheNeedsSingleOwner() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), scatteredCacheNeedsSingleOwner$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidationBatchSizeAppliesOnNonScattered$str() {
        return "ISPN000468: Invalidation batch size configuration options applies only to scattered caches.";
    }
    @Override
    public final CacheConfigurationException invalidationBatchSizeAppliesOnNonScattered() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidationBatchSizeAppliesOnNonScattered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String scatteredCacheIsNonTransactional$str() {
        return "ISPN000469: Scattered cache does not support transactional mode.";
    }
    @Override
    public final CacheConfigurationException scatteredCacheIsNonTransactional() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), scatteredCacheIsNonTransactional$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedConfirmingRevokedSegments(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedConfirmingRevokedSegments$str());
    }
    protected String failedConfirmingRevokedSegments$str() {
        return "ISPN000470: Failed confirming revoked segments. State transfer cannot continue.";
    }
    @Override
    public final void failedProcessingValuesDuringRebalance(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedProcessingValuesDuringRebalance$str());
    }
    protected String failedProcessingValuesDuringRebalance$str() {
        return "ISPN000471: Failed processing values received from remote node during rebalance.";
    }
    protected String cacheManagerIsStopping$str() {
        return "ISPN000472: Cache manager is stopping";
    }
    @Override
    public final IllegalLifecycleStateException cacheManagerIsStopping() {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheManagerIsStopping$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void invalidMessageType(final int messageType, final org.jgroups.Address origin) {
        super.log.logf(FQCN, ERROR, null, invalidMessageType$str(), messageType, origin);
    }
    protected String invalidMessageType$str() {
        return "ISPN000473: Invalid message type %s received from %s";
    }
    @Override
    public final void errorProcessingRequest(final long requestId, final org.jgroups.Address origin, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorProcessingRequest$str(), requestId, origin);
    }
    protected String errorProcessingRequest$str() {
        return "ISPN000474: Error processing request %d@%s";
    }
    @Override
    public final void errorProcessingResponse(final long requestId, final org.jgroups.Address sender, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorProcessingResponse$str(), requestId, sender);
    }
    protected String errorProcessingResponse$str() {
        return "ISPN000475: Error processing response for request %d from %s";
    }
    protected String requestTimedOut$str() {
        return "ISPN000476: Timed out waiting for responses for request %d from %s after %s";
    }
    @Override
    public final TimeoutException requestTimedOut(final long requestId, final String targetsWithoutResponses, final String elapsed) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), requestTimedOut$str(), requestId, targetsWithoutResponses, elapsed));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xsiteAdminOperationError(final String operationName, final String siteName, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xsiteAdminOperationError$str(), operationName, siteName);
    }
    protected String xsiteAdminOperationError$str() {
        return "ISPN000477: Cannot perform operation %s for site %s";
    }
    protected String unableToFindRemoteSiteTransaction$str() {
        return "ISPN000478: Couldn't find a local transaction corresponding to remote site transaction %s";
    }
    @Override
    public final CacheException unableToFindRemoteSiteTransaction(final GlobalTransaction globalTransaction) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToFindRemoteSiteTransaction$str(), globalTransaction));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToFindLocalTransactionFromRemoteSiteTransaction$str() {
        return "ISPN000479: LocalTransaction not found but present in the tx table for remote site transaction %s";
    }
    @Override
    public final IllegalStateException unableToFindLocalTransactionFromRemoteSiteTransaction(final GlobalTransaction globalTransaction) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToFindLocalTransactionFromRemoteSiteTransaction$str(), globalTransaction));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringInvalidateVersionsFromOldTopology(final int invalidationTopology, final int currentTopologyId) {
        super.log.logf(FQCN, WARN, null, ignoringInvalidateVersionsFromOldTopology$str(), invalidationTopology, currentTopologyId);
    }
    protected String ignoringInvalidateVersionsFromOldTopology$str() {
        return "ISPN000480: Ignoring versions invalidation from topology %d, current topology is %d";
    }
    protected String remoteTransactionOriginatorNotInView$str() {
        return "ISPN000481: Cannot create remote transaction %s, the originator is not in the cluster view";
    }
    @Override
    public final CacheException remoteTransactionOriginatorNotInView(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionOriginatorNotInView$str(), gtx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String remoteTransactionAlreadyCompleted$str() {
        return "ISPN000482: Cannot create remote transaction %s, already completed";
    }
    @Override
    public final CacheException remoteTransactionAlreadyCompleted(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionAlreadyCompleted$str(), gtx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wildcardsNotAllowedInCacheNames$str() {
        return "ISPN000484: Wildcards not allowed in cache names: '%s'";
    }
    @Override
    public final CacheConfigurationException wildcardsNotAllowedInCacheNames(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), wildcardsNotAllowedInCacheNames$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configurationNameMatchesMultipleWildcards$str() {
        return "ISPN000485: Configuration '%s' matches multiple wildcard templates";
    }
    @Override
    public final CacheConfigurationException configurationNameMatchesMultipleWildcards(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configurationNameMatchesMultipleWildcards$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateIdWrapper$str() {
        return "ISPN000486: Cannot register Wrapper: duplicate Id %d";
    }
    @Override
    public final EncodingException duplicateIdWrapper(final byte id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), duplicateIdWrapper$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrapperClassNotFound$str() {
        return "ISPN000487: Wrapper with class '%s' not found";
    }
    @Override
    public final EncodingException wrapperClassNotFound(final Class<?> wrapperClass) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), wrapperClassNotFound$str(), wrapperClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrapperIdNotFound$str() {
        return "ISPN000488: Wrapper with Id %d not found";
    }
    @Override
    public final EncodingException wrapperIdNotFound(final byte id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), wrapperIdNotFound$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateIdEncoder$str() {
        return "ISPN000489: Cannot register Encoder: duplicate Id %d";
    }
    @Override
    public final EncodingException duplicateIdEncoder(final short id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), duplicateIdEncoder$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encoderClassNotFound$str() {
        return "ISPN000490: Encoder with class '%s' not found";
    }
    @Override
    public final EncodingException encoderClassNotFound(final Class<?> wrapperClass) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), encoderClassNotFound$str(), wrapperClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encoderIdNotFound$str() {
        return "ISPN000491: Encoder with Id %d not found";
    }
    @Override
    public final EncodingException encoderIdNotFound(final short id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), encoderIdNotFound$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindTranscoder$str() {
        return "ISPN000492: Cannot find transcoder between '%s' to '%s'";
    }
    @Override
    public final EncodingException cannotFindTranscoder(final MediaType mediaType, final MediaType another) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotFindTranscoder$str(), mediaType, another));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorTranscoding$str() {
        return "ISPN000495: %s encountered error transcoding content";
    }
    @Override
    public final EncodingException errorTranscoding(final String transcoderName, final Throwable cause) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorTranscoding$str(), transcoderName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedContent$str() {
        return "ISPN000497: %s encountered unsupported content '%s' during transcoding";
    }
    @Override
    public final EncodingException unsupportedContent(final String transcoderName, final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unsupportedContent$str(), transcoderName, content));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configurationSerializationFailed$str() {
        return "ISPN000499: Could not serialize the configuration of cache '%s' (%s)";
    }
    @Override
    public final CacheConfigurationException configurationSerializationFailed(final String cacheName, final Configuration configuration, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configurationSerializationFailed$str(), cacheName, configuration), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleClusterConfiguration$str() {
        return "ISPN000500: Cannot create clustered configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s";
    }
    @Override
    public final CacheConfigurationException incompatibleClusterConfiguration(final String cacheName, final Configuration configuration, final Configuration existing) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), incompatibleClusterConfiguration$str(), cacheName, configuration, existing));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String globalStateDisabled$str() {
        return "ISPN000501: Cannot persist cache configuration as global state is disabled";
    }
    @Override
    public final CacheConfigurationException globalStateDisabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalStateDisabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorPersistingGlobalConfiguration$str() {
        return "ISPN000502: Error while persisting global configuration state";
    }
    @Override
    public final CacheConfigurationException errorPersistingGlobalConfiguration(final Throwable cause) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorPersistingGlobalConfiguration$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String offHeapMemoryEvictionNotSupportedWithObject$str() {
        return "ISPN000504: Size (bytes) based eviction needs either off-heap or a binary compatible storage configured in the cache encoding";
    }
    @Override
    public final CacheConfigurationException offHeapMemoryEvictionNotSupportedWithObject() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), offHeapMemoryEvictionNotSupportedWithObject$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String biasedReadsAppliesOnlyToScattered$str() {
        return "ISPN000506: Biased reads are supported only in scattered cache. Maybe you were looking for L1?";
    }
    @Override
    public final CacheConfigurationException biasedReadsAppliesOnlyToScattered() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), biasedReadsAppliesOnlyToScattered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheExists$str() {
        return "ISPN000507: Cache %s already exists";
    }
    @Override
    public final CacheConfigurationException cacheExists(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cacheExists$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotRenamePersistentFile$str() {
        return "ISPN000508: Cannot rename file %s to %s";
    }
    @Override
    public final CacheConfigurationException cannotRenamePersistentFile(final String absolutePath, final File persistentFile, final Throwable cause) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToAddNullEntryMergePolicyFactory$str() {
        return "ISPN000509: Unable to add a 'null' EntryMergePolicyFactory";
    }
    @Override
    public final IllegalArgumentException unableToAddNullEntryMergePolicyFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToAddNullEntryMergePolicyFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String customStorageStrategyNotSet$str() {
        return "ISPN000510: ConfigurationStrategy set to CUSTOM, but none specified";
    }
    @Override
    public final CacheConfigurationException customStorageStrategyNotSet() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), customStorageStrategyNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String managerConfigurationStorageUnavailable$str() {
        return "ISPN000511: ConfigurationStrategy cannot be set to MANAGED in embedded mode";
    }
    @Override
    public final CacheConfigurationException managerConfigurationStorageUnavailable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), managerConfigurationStorageUnavailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String globalStateCannotAcquireLockFile$str() {
        return "ISPN000512: Cannot acquire lock '%s' for persistent global state";
    }
    @Override
    public final CacheConfigurationException globalStateCannotAcquireLockFile(final Throwable cause, final File lockFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalStateCannotAcquireLockFile$str(), lockFile), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exceptionBasedEvictionOnlySupportedInTransactionalCaches$str() {
        return "ISPN000513: Exception based eviction requires a transactional cache that doesn't allow for 1 phase commit or synchronizations";
    }
    @Override
    public final CacheConfigurationException exceptionBasedEvictionOnlySupportedInTransactionalCaches() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), exceptionBasedEvictionOnlySupportedInTransactionalCaches$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String containerFull$str() {
        return "ISPN000514: Container eviction limit %d reached, write operation(s) is blocked";
    }
    @Override
    public final ContainerFullException containerFull(final long size) {
        final ContainerFullException result = new ContainerFullException(String.format(getLoggingLocale(), containerFull$str(), size));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String immutableConfiguration$str() {
        return "ISPN000515: The configuration is immutable";
    }
    @Override
    public final UnsupportedOperationException immutableConfiguration() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), immutableConfiguration$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPersistentState$str() {
        return "ISPN000516: The state file for '%s' is invalid. Startup halted to prevent further corruption of persistent state";
    }
    @Override
    public final CacheConfigurationException invalidPersistentState(final String globalScope) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidPersistentState$str(), globalScope));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringCacheTopology(final Collection<Address> sender, final CacheTopology topology) {
        super.log.logf(FQCN, WARN, null, ignoringCacheTopology$str(), sender, topology);
    }
    protected String ignoringCacheTopology$str() {
        return "ISPN000517: Ignoring cache topology from %s during merge: %s";
    }
    @Override
    public final void updatingTopology(final String cacheName, final CacheTopology currentTopology, final AvailabilityMode availabilityMode) {
        super.log.logf(FQCN, DEBUG, null, updatingTopology$str(), cacheName, currentTopology, availabilityMode);
    }
    protected String updatingTopology$str() {
        return "ISPN000518: Updating topology for cache %s, topology %s, availability mode %s";
    }
    @Override
    public final void updatingStableTopology(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, updatingStableTopology$str(), cacheName, currentTopology);
    }
    protected String updatingStableTopology$str() {
        return "ISPN000519: Updating stable topology for cache %s, topology %s";
    }
    @Override
    public final void updatingAvailabilityMode(final String cacheName, final AvailabilityMode oldMode, final AvailabilityMode newMode, final CacheTopology topology) {
        super.log.logf(FQCN, DEBUG, null, updatingAvailabilityMode$str(), cacheName, oldMode, newMode, topology);
    }
    protected String updatingAvailabilityMode$str() {
        return "ISPN000520: Updating availability mode for cache %s from %s to %s, topology %s";
    }
    @Override
    public final void cacheRecoveredAfterMerge(final String cacheName, final CacheTopology currentTopology, final AvailabilityMode availabilityMode) {
        super.log.logf(FQCN, DEBUG, null, cacheRecoveredAfterMerge$str(), cacheName, currentTopology, availabilityMode);
    }
    protected String cacheRecoveredAfterMerge$str() {
        return "ISPN000521: Cache %s recovered after merge with topology = %s, availability mode %s";
    }
    @Override
    public final void startingConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, startingConflictResolution$str(), cacheName, currentTopology);
    }
    protected String startingConflictResolution$str() {
        return "ISPN000522: Conflict resolution starting for cache %s with topology %s";
    }
    @Override
    public final void finishedConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, finishedConflictResolution$str(), cacheName, currentTopology);
    }
    protected String finishedConflictResolution$str() {
        return "ISPN000523: Conflict resolution finished for cache %s with topology %s";
    }
    @Override
    public final void failedConflictResolution(final String cacheName, final CacheTopology currentTopology, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedConflictResolution$str(), cacheName, currentTopology);
    }
    protected String failedConflictResolution$str() {
        return "ISPN000524: Conflict resolution failed for cache %s with topology %s";
    }
    @Override
    public final void cancelledConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, cancelledConflictResolution$str(), cacheName, currentTopology);
    }
    protected String cancelledConflictResolution$str() {
        return "ISPN000525: Conflict resolution cancelled for cache %s with topology %s";
    }
    protected String storeStartupAttemptsExceeded$str() {
        return "ISPN000527: Maximum startup attempts exceeded for store %s";
    }
    @Override
    public final PersistenceException storeStartupAttemptsExceeded(final String storeName, final Throwable t) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), storeStartupAttemptsExceeded$str(), storeName), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String degradedModeLockUnavailable$str() {
        return "ISPN000528: Cannot acquire lock %s as this partition is DEGRADED";
    }
    @Override
    public final AvailabilityException degradedModeLockUnavailable(final Object key) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeLockUnavailable$str(), key));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorDeserializing$str() {
        return "ISPN000529: Class '%s' blocked by deserialization allow list. Include the class name in the server allow list to authorize.";
    }
    @Override
    public final CacheException errorDeserializing(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorDeserializing$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unsupportedAsyncCacheMode(final CacheMode unsupportedCacheMode, final CacheMode forcedCacheMode) {
        super.log.logf(FQCN, WARN, null, unsupportedAsyncCacheMode2$str(), unsupportedCacheMode, forcedCacheMode);
    }
    protected String unsupportedAsyncCacheMode2$str() {
        return "ISPN000530: Unsupported async cache mode '%s' for transactional caches, forcing %s";
    }
    protected String storeNotSegmented$str() {
        return "ISPN000531: Store or loader %s must implement SegmentedLoadWriteStore or its config must extend AbstractSegmentedStoreConfiguration if configured as segmented";
    }
    @Override
    public final CacheConfigurationException storeNotSegmented(final Class<?> implementedClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeNotSegmented$str(), implementedClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivationStoreCannotBeShared$str() {
        return "ISPN000532: Invalid cache loader configuration for '%s'.  If a cache loader is configured with passivation, the cache loader cannot be shared in a cluster!";
    }
    @Override
    public final CacheConfigurationException passivationStoreCannotBeShared(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), passivationStoreCannotBeShared$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConvertContent$str() {
        return "ISPN000533: Content '%s (MediaType: '%s') cannot be converted to '%s'";
    }
    @Override
    public final EncodingException cannotConvertContent(final Object content, final MediaType contentType, final MediaType destination) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotConvertContent$str(), content, contentType, destination));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupingOnlyCompatibleWithObjectStorage1$str() {
        return "ISPN000534: Grouping requires OBJECT storage type but was: %s";
    }
    @Override
    public final CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(final StorageType storageType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), groupingOnlyCompatibleWithObjectStorage1$str(), storageType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String groupingOnlyCompatibleWithObjectStorage2$str() {
        return "ISPN000535: Grouping requires application/x-java-object storage type but was: {key=%s, value=%s}";
    }
    @Override
    public final CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(final String keyMediaType, final String valueMediaType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), groupingOnlyCompatibleWithObjectStorage2$str(), keyMediaType, valueMediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String factoryCannotConstructComponent$str() {
        return "ISPN000537: Factory doesn't know how to construct component %s";
    }
    @Override
    public final CacheConfigurationException factoryCannotConstructComponent(final String componentName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), factoryCannotConstructComponent$str(), componentName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void moduleStopError(final String module, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, moduleStopError$str(), module);
    }
    protected String moduleStopError$str() {
        return "ISPN000538: Error stopping module %s";
    }
    protected String duplicateJGroupsStack$str() {
        return "ISPN000539: Duplicate JGroups stack '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateJGroupsStack(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateJGroupsStack$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingJGroupsStack$str() {
        return "ISPN000540: No such JGroups stack '%s'";
    }
    @Override
    public final CacheConfigurationException missingJGroupsStack(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingJGroupsStack$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingChannelFromConfigurator$str() {
        return "ISPN000541: Error while trying to create a channel using the specified configuration '%s'";
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigurator(final String configurator, final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromConfigurator$str(), configurator), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidScope$str() {
        return "ISPN000542: Invalid parser scope. Expected '%s' but was '%s'";
    }
    @Override
    public final CacheConfigurationException invalidScope(final String expected, final String found) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidScope$str(), expected, found));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsNoStackPosition$str() {
        return "ISPN000543: Cannot use stack.position when stack.combine is '%s'";
    }
    @Override
    public final CacheConfigurationException jgroupsNoStackPosition(final String combineMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsNoStackPosition$str(), combineMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsNoSuchProtocol$str() {
        return "ISPN000544: The protocol '%s' does not exist in the base stack for operation '%s'";
    }
    @Override
    public final CacheConfigurationException jgroupsNoSuchProtocol(final String protocolName, final String combineMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsNoSuchProtocol$str(), protocolName, combineMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsInsertRequiresPosition$str() {
        return "ISPN000545: Inserting protocol '%s' in a JGroups stack requires the 'stack.position' attribute";
    }
    @Override
    public final CacheConfigurationException jgroupsInsertRequiresPosition(final String protocolName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsInsertRequiresPosition$str(), protocolName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateRemoteSite$str() {
        return "ISPN000546: Duplicate remote site '%s' in stack '%s'";
    }
    @Override
    public final CacheConfigurationException duplicateRemoteSite(final String remoteSite, final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateRemoteSite$str(), remoteSite, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsRemoteSitesWithoutRelay$str() {
        return "ISPN000547: JGroups stack '%s' declares remote sites but does not include the RELAY2 protocol.";
    }
    @Override
    public final CacheConfigurationException jgroupsRemoteSitesWithoutRelay(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsRemoteSitesWithoutRelay$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String jgroupsRelayWithoutRemoteSites$str() {
        return "ISPN000548: JGroups stack '%s' has a RELAY2 protocol without remote sites.";
    }
    @Override
    public final CacheConfigurationException jgroupsRelayWithoutRemoteSites(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsRelayWithoutRemoteSites$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sharedStoreWithLocalCache$str() {
        return "ISPN000549: A store cannot be shared when utilised with a local cache.";
    }
    @Override
    public final CacheConfigurationException sharedStoreWithLocalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sharedStoreWithLocalCache$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidationPartitionHandlingNotSuported$str() {
        return "ISPN000550: Invalidation mode only supports when-split=ALLOW_READ_WRITES";
    }
    @Override
    public final CacheConfigurationException invalidationPartitionHandlingNotSuported() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidationPartitionHandlingNotSuported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void customInterceptorsDeprecated() {
        super.log.logf(FQCN, WARN, null, customInterceptorsDeprecated$str());
    }
    protected String customInterceptorsDeprecated$str() {
        return "ISPN000551: The custom interceptors configuration has been deprecated and will be ignored in the future";
    }
    @Override
    public final void marshallersNotSupported() {
        super.log.logf(FQCN, WARN, null, marshallersNotSupported$str());
    }
    protected String marshallersNotSupported$str() {
        return "ISPN000553: Ignoring 'marshaller' attribute. Common marshallers are already available at runtime, and to deploy a custom marshaller, consult the 'Encoding' section in the user guide";
    }
    @Override
    public final void jbossMarshallingDetected() {
        super.log.logf(FQCN, WARN, null, jbossMarshallingDetected$str());
    }
    protected String jbossMarshallingDetected$str() {
        return "ISPN000554: jboss-marshalling is deprecated and planned for removal";
    }
    @Override
    public final void unableToSetAccessible(final Method m, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToSetAccessible$str(), m);
    }
    protected String unableToSetAccessible$str() {
        return "ISPN000555: Unable to set method %s accessible";
    }
    @Override
    public final void startingUserMarshaller(final String marshallerClass) {
        super.log.logf(FQCN, INFO, null, startingUserMarshaller$str(), marshallerClass);
    }
    protected String startingUserMarshaller$str() {
        return "ISPN000556: Starting user marshaller '%s'";
    }
    protected String unableToAddJGroupsStack$str() {
        return "ISPN000557: Unable to configure JGroups Stack '%s'";
    }
    @Override
    public final CacheConfigurationException unableToAddJGroupsStack(final String name, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToAddJGroupsStack$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String forbiddenStoreLocation$str() {
        return "ISPN000558: The store location '%s' is not a child of the global persistent location '%s'";
    }
    @Override
    public final CacheConfigurationException forbiddenStoreLocation(final Path location, final Path global) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), forbiddenStoreLocation$str(), location, global));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotMarshall(final Class<?> aClass, final Throwable t) {
        super.log.logf(FQCN, WARN, t, cannotMarshall$str(), aClass);
    }
    protected String cannotMarshall$str() {
        return "ISPN000559: Cannot marshall '%s'";
    }
    @Override
    public final void advancedExternalizerDeprecated() {
        super.log.logf(FQCN, WARN, null, advancedExternalizerDeprecated$str());
    }
    protected String advancedExternalizerDeprecated$str() {
        return "ISPN000560: The AdvancedExternalizer configuration has been deprecated and will be removed in the future";
    }
    protected String invalidChunkSize$str() {
        return "ISPN000561: Chunk size must be positive, got %d";
    }
    @Override
    public final CacheConfigurationException invalidChunkSize(final int chunkSize) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidChunkSize$str(), chunkSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sharedStoreShouldNotBePurged$str() {
        return "ISPN000562: Invalid cache loader configuration for '%s'.  If a cache loader is configured with purgeOnStartup, the cache loader cannot be shared in a cluster!";
    }
    @Override
    public final CacheConfigurationException sharedStoreShouldNotBePurged(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sharedStoreShouldNotBePurged$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeDoesNotSupportBeingSegmented$str() {
        return "ISPN000563: Invalid cache loader configuration for '%s'.  This implementation does not support being segmented!";
    }
    @Override
    public final CacheConfigurationException storeDoesNotSupportBeingSegmented(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeDoesNotSupportBeingSegmented$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void segmentedStoreUsesManyFileDescriptors(final String storeName) {
        super.log.logf(FQCN, WARN, null, segmentedStoreUsesManyFileDescriptors$str(), storeName);
    }
    protected String segmentedStoreUsesManyFileDescriptors$str() {
        return "ISPN000564: Configured store '%s' is segmented and may use a large number of file descriptors";
    }
    protected String indexModeNotSupported$str() {
        return "ISPN000565: Index.%s is no longer supported. Please update your configuration!";
    }
    @Override
    public final CacheConfigurationException indexModeNotSupported(final String indexMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), indexModeNotSupported$str(), indexMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String threadPoolFactoryIsBlocking$str() {
        return "ISPN000566: Thread Pool Factory %s is blocking, but pool %s requires non blocking threads";
    }
    @Override
    public final CacheConfigurationException threadPoolFactoryIsBlocking(final String name, final String poolName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), threadPoolFactoryIsBlocking$str(), name, poolName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnUnableToPersistInternalCaches() {
        if (super.log.isEnabled(WARN) && warnUnableToPersistInternalCaches_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, warnUnableToPersistInternalCaches$str());
        }
    }
    protected String warnUnableToPersistInternalCaches$str() {
        return "ISPN000569: Unable to persist Infinispan internal caches as no global state enabled";
    }
    private static final AtomicBoolean warnUnableToPersistInternalCaches_$Once = new AtomicBoolean(false);
    protected String unexpectedResponse$str() {
        return "ISPN000570: Unexpected response from %s: %s";
    }
    @Override
    public final IllegalArgumentException unexpectedResponse(final Address target, final Response response) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedResponse$str(), target, response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String crossSiteUnavailable$str() {
        return "ISPN000571: RELAY2 not found in the protocol stack. Cannot perform cross-site operations.";
    }
    @Override
    public final CacheConfigurationException crossSiteUnavailable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), crossSiteUnavailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexModeDeprecated() {
        super.log.logf(FQCN, WARN, null, indexModeDeprecated$str());
    }
    protected String indexModeDeprecated$str() {
        return "ISPN000572: index mode attribute is deprecated and should no longer be specified because its value is automatically detected. Most previously supported values are no longer supported. Please check the upgrade guide.";
    }
    protected String incompatiblePersistedConfiguration$str() {
        return "ISPN000573: Cannot recreate persisted configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s";
    }
    @Override
    public final CacheConfigurationException incompatiblePersistedConfiguration(final String cacheName, final Configuration configuration, final Configuration existing) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), incompatiblePersistedConfiguration$str(), cacheName, configuration, existing));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void incompleteGlobalState() {
        super.log.logf(FQCN, WARN, null, incompleteGlobalState$str());
    }
    protected String incompleteGlobalState$str() {
        return "ISPN000574: Global state cannot persisted because it is incomplete (usually caused by errors at startup).";
    }
    protected String singleOwnerNotSetToAllowReadWrites$str() {
        return "ISPN000575: PartitionStrategy must be ALLOW_READ_WRITES when numOwners is 1";
    }
    @Override
    public final CacheConfigurationException singleOwnerNotSetToAllowReadWrites() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), singleOwnerNotSetToAllowReadWrites$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xsiteInLocalCache0$str() {
        return "ISPN000576: Cross-site replication not available for local cache.";
    }
    @Override
    public final CacheConfigurationException xsiteInLocalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xsiteInLocalCache0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingTypeForUnwrappedPayload$str() {
        return "ISPN000577: Converting from unwrapped protostream payload requires the 'type' parameter to be supplied in the destination MediaType";
    }
    @Override
    public final MarshallingException missingTypeForUnwrappedPayload() {
        final MarshallingException result = new MarshallingException(String.format(getLoggingLocale(), missingTypeForUnwrappedPayload$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void startMigratingPersistenceData(final String cacheName) {
        super.log.logf(FQCN, INFO, null, startMigratingPersistenceData$str(), cacheName);
    }
    protected String startMigratingPersistenceData$str() {
        return "ISPN000578: Migrating '%s' persisted data to new format...";
    }
    @Override
    public final void persistedDataSuccessfulMigrated(final String cacheName) {
        super.log.logf(FQCN, INFO, null, persistedDataSuccessfulMigrated$str(), cacheName);
    }
    protected String persistedDataSuccessfulMigrated$str() {
        return "ISPN000579: '%s' persisted data successfully migrated.";
    }
    protected String persistedDataMigrationFailed$str() {
        return "ISPN000580: Failed to migrate '%s' persisted data.";
    }
    @Override
    public final PersistenceException persistedDataMigrationFailed(final String cacheName, final Throwable cause) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), persistedDataMigrationFailed$str(), cacheName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String indexEnabledAndIndexModeAreExclusive$str() {
        return "ISPN000581: The indexing 'enabled' and the legacy 'index' configs attributes are mutually exclusive";
    }
    @Override
    public final CacheConfigurationException indexEnabledAndIndexModeAreExclusive() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), indexEnabledAndIndexModeAreExclusive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String foundMultipleDirectoryProviders$str() {
        return "ISPN000582: A single indexing directory provider is allowed per cache configuration. Setting multiple individual providers for the indexes belonging to a cache is not allowed.";
    }
    @Override
    public final CacheConfigurationException foundMultipleDirectoryProviders() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), foundMultipleDirectoryProviders$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotProvideBothSizeAndCount$str() {
        return "ISPN000583: Cannot configure both maxCount and maxSize in memory configuration";
    }
    @Override
    public final CacheConfigurationException cannotProvideBothSizeAndCount() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotProvideBothSizeAndCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUseDeprecatedAndReplacement$str() {
        return "ISPN000584: The memory attribute(s) %s have been deprecated and cannot be used in conjunction with the new configuration";
    }
    @Override
    public final CacheConfigurationException cannotUseDeprecatedAndReplacement(final String legacyName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotUseDeprecatedAndReplacement$str(), legacyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void ignoringSpecificMediaTypes() {
        super.log.logf(FQCN, WARN, null, ignoringSpecificMediaTypes$str());
    }
    protected String ignoringSpecificMediaTypes$str() {
        return "ISPN000585: Single media-type was specified for keys and values, ignoring individual configurations";
    }
    @Override
    public final void warnUsingDeprecatedMemoryConfigs(final String element) {
        super.log.logf(FQCN, WARN, null, warnUsingDeprecatedMemoryConfigs$str(), element);
    }
    protected String warnUsingDeprecatedMemoryConfigs$str() {
        return "ISPN000586: The memory configuration element '%s' has been deprecated. Please update your configuration";
    }
    protected String cannotChangeMaxSize$str() {
        return "ISPN000587: Cannot change max-size since max-count is already defined";
    }
    @Override
    public final CacheConfigurationException cannotChangeMaxSize() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotChangeMaxSize$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotChangeMaxCount$str() {
        return "ISPN000588: Cannot change max-count since max-size is already defined";
    }
    @Override
    public final CacheConfigurationException cannotChangeMaxCount() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotChangeMaxCount$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String preloadAndPurgeOnStartupConflict$str() {
        return "ISPN000589: A store cannot be configured with both preload and purgeOnStartup";
    }
    @Override
    public final CacheConfigurationException preloadAndPurgeOnStartupConflict() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), preloadAndPurgeOnStartupConflict$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeBothReadAndWriteOnly$str() {
        return "ISPN000590: Store cannot be configured with both read and write only!";
    }
    @Override
    public final CacheConfigurationException storeBothReadAndWriteOnly() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeBothReadAndWriteOnly$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeReadOnlyExceptions$str() {
        return "ISPN000591: Store cannot be configured with purgeOnStartup or shared if it is read only!";
    }
    @Override
    public final CacheConfigurationException storeReadOnlyExceptions() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeReadOnlyExceptions$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeWriteOnlyExceptions$str() {
        return "ISPN000592: Store cannot be configured with fetchPersistenceState or preload if it is write only!";
    }
    @Override
    public final CacheConfigurationException storeWriteOnlyExceptions() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeWriteOnlyExceptions$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeConfiguredHasBothReadAndWriteOnly$str() {
        return "ISPN000593: Store %s cannot be configured to be %s as the implementation specifies it is already %s!";
    }
    @Override
    public final CacheConfigurationException storeConfiguredHasBothReadAndWriteOnly(final String storeClassName, final Characteristic configured, final Characteristic implSpecifies) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeConfiguredHasBothReadAndWriteOnly$str(), storeClassName, configured, implSpecifies));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onlyOnePreloadStoreAllowed$str() {
        return "ISPN000594: At most one store can be set to 'preload'!";
    }
    @Override
    public final CacheConfigurationException onlyOnePreloadStoreAllowed() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), onlyOnePreloadStoreAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnUsingDeprecatedClusterLoader() {
        super.log.logf(FQCN, WARN, null, warnUsingDeprecatedClusterLoader$str());
    }
    protected String warnUsingDeprecatedClusterLoader$str() {
        return "ISPN000595: ClusterLoader has been deprecated and will be removed in a future version with no direct replacement";
    }
    @Override
    public final void autoConfigDeprecated() {
        super.log.logf(FQCN, WARN, null, autoConfigDeprecated$str());
    }
    protected String autoConfigDeprecated$str() {
        return "ISPN000596: Indexing auto-config attribute is deprecated. Please check the upgrade guide.";
    }
    protected String storeConfiguredTransactionalButCharacteristicNotPresent$str() {
        return "ISPN000597: Store %s cannot be configured to be transactional as it does not contain the TRANSACTIONAL characteristic";
    }
    @Override
    public final CacheConfigurationException storeConfiguredTransactionalButCharacteristicNotPresent(final String storeClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeConfiguredTransactionalButCharacteristicNotPresent$str(), storeClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeLocationRequired0$str() {
        return "ISPN000598: Store must specify a location when global state is disabled";
    }
    @Override
    public final CacheConfigurationException storeLocationRequired() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeLocationRequired0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeLocationRequired2$str() {
        return "ISPN000598: Store '%s' must specify the '%s' attribute when global state is disabled";
    }
    @Override
    public final CacheConfigurationException storeLocationRequired(final String storeType, final String attributeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeLocationRequired2$str(), storeType, attributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unknownEncoding(final String cacheName) {
        super.log.logf(FQCN, WARN, null, unknownEncoding$str(), cacheName);
    }
    protected String unknownEncoding$str() {
        return "ISPN000599: Configuration for cache '%s' does not define the encoding for keys or values. If you use operations that require data conversion or queries, you should configure the cache with a specific MediaType for keys or values.";
    }
    protected String storeConfiguredSharedButCharacteristicNotPresent$str() {
        return "ISPN000600: Store %s cannot be configured to be shared as it does not contain the SHARED characteristic";
    }
    @Override
    public final CacheConfigurationException storeConfiguredSharedButCharacteristicNotPresent(final String storeClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeConfiguredSharedButCharacteristicNotPresent$str(), storeClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String storeConfiguredSegmentedButCharacteristicNotPresent$str() {
        return "ISPN000601: Store %s cannot be configured to be segmented as it does not contain the SEGMENTABLE characteristic";
    }
    @Override
    public final CacheConfigurationException storeConfiguredSegmentedButCharacteristicNotPresent(final String storeClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeConfiguredSegmentedButCharacteristicNotPresent$str(), storeClassName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void jsonObjectConversionDeprecated() {
        super.log.logf(FQCN, WARN, null, jsonObjectConversionDeprecated$str());
    }
    protected String jsonObjectConversionDeprecated$str() {
        return "ISPN000602: Conversions between JSON and Java Objects are deprecated and will be removed in a future version. To read/write values as JSON, it is recommended to define a protobuf schema and store data in the cache using 'application/x-protostream' as MediaType";
    }
    protected String xsiteCacheNotFound$str() {
        return "ISPN000603: Cannot handle cross-site request from site '%s'. Cache '%s' not found.";
    }
    @Override
    public final CacheConfigurationException xsiteCacheNotFound(final String remoteSite, final ByteString cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xsiteCacheNotFound$str(), remoteSite, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xsiteCacheNotStarted$str() {
        return "ISPN000604: Cannot handle cross-site request from site '%s'. Cache '%s' is stopped.";
    }
    @Override
    public final CacheConfigurationException xsiteCacheNotStarted(final String origin, final ByteString cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xsiteCacheNotStarted$str(), origin, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xsiteInLocalCache2$str() {
        return "ISPN000605: Cannot handle cross-site request from site '%s'. Cache '%s' is not clustered.";
    }
    @Override
    public final CacheConfigurationException xsiteInLocalCache(final String origin, final ByteString cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xsiteInLocalCache2$str(), origin, cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xsiteInvalidConfigurationRemoteSite(final String siteName, final CacheConfigurationException exception) {
        super.log.logf(FQCN, ERROR, exception, xsiteInvalidConfigurationRemoteSite$str(), siteName);
    }
    protected String xsiteInvalidConfigurationRemoteSite$str() {
        return "ISPN000606: Remote site '%s' has an invalid cache configuration. Taking the backup location offline.";
    }
    protected String missingXSiteEntryMergePolicy$str() {
        return "ISPN000607: The XSiteEntryMergePolicy is missing. The cache configuration must include a merge policy.";
    }
    @Override
    public final CacheConfigurationException missingXSiteEntryMergePolicy() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingXSiteEntryMergePolicy$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unexpectedErrorFromIrac(final Throwable t) {
        super.log.logf(FQCN, FATAL, t, unexpectedErrorFromIrac$str());
    }
    protected String unexpectedErrorFromIrac$str() {
        return "ISPN000608: [IRAC] Unexpected error occurred.";
    }
    @Override
    public final void cannotObtainFailedCache(final String name, final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, cannotObtainFailedCache$str(), name);
    }
    protected String cannotObtainFailedCache$str() {
        return "ISPN000609: Cannot obtain cache '%s' as it is in FAILED state. Please check the configuration";
    }
    protected String indexableClassesDefined$str() {
        return "ISPN000610: Cache configuration must not declare indexed entities if it is not indexed";
    }
    @Override
    public final CacheConfigurationException indexableClassesDefined() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), indexableClassesDefined$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexStorage$str() {
        return "ISPN000611: Invalid index storage";
    }
    @Override
    public final CacheConfigurationException invalidIndexStorage() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidIndexStorage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexingPropertiesDeprecated(final Properties properties) {
        if (super.log.isEnabled(WARN) && indexingPropertiesDeprecated_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, indexingPropertiesDeprecated$str(), properties);
        }
    }
    protected String indexingPropertiesDeprecated$str() {
        return "ISPN000612: Indexing configuration using properties has been deprecated and will be removed in a future version, please consult the docs for the replacements. The following properties have been found: '%s'";
    }
    private static final AtomicBoolean indexingPropertiesDeprecated_$Once = new AtomicBoolean(false);
    @Override
    public final void deprecatedIndexProperties() {
        if (super.log.isEnabled(WARN) && deprecatedIndexProperties_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, deprecatedIndexProperties$str());
        }
    }
    protected String deprecatedIndexProperties$str() {
        return "ISPN000613: Indexing configuration using properties has been deprecated and will be removed in a future version, please use the <index-writer> and <index-reader> elements to configure indexing behavior.";
    }
    private static final AtomicBoolean deprecatedIndexProperties_$Once = new AtomicBoolean(false);
    protected String foundDifferentIndexConfigPerType$str() {
        return "ISPN000614: It is not allowed to have different indexing configuration for each indexed type in a cache.";
    }
    @Override
    public final CacheConfigurationException foundDifferentIndexConfigPerType() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), foundDifferentIndexConfigPerType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String marshallerMissingFromUserAndGlobalContext$str() {
        return "ISPN000615: Unable to unmarshall '%s' as a marshaller is not present in the user or global SerializationContext";
    }
    @Override
    public final MarshallingException marshallerMissingFromUserAndGlobalContext(final String type) {
        final MarshallingException result = new MarshallingException(String.format(getLoggingLocale(), marshallerMissingFromUserAndGlobalContext$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String persistedDataMigrationUnsupportedVersion$str() {
        return "ISPN000616: Unsupported persisted data version: %s";
    }
    @Override
    public final PersistenceException persistedDataMigrationUnsupportedVersion(final String magic) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), persistedDataMigrationUnsupportedVersion$str(), magic));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String siteNotFound$str() {
        return "ISPN000617: Site '%s' not found.";
    }
    @Override
    public final IllegalArgumentException siteNotFound(final String siteName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), siteNotFound$str(), siteName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void xsiteCancelSendFailed(final Throwable throwable, final String remoteSite) {
        super.log.logf(FQCN, WARN, throwable, xsiteCancelSendFailed$str(), remoteSite);
    }
    protected String xsiteCancelSendFailed$str() {
        return "ISPN000618: Cleanup failed for cross-site state transfer. Invoke the cancel-push-state(%s) command if any nodes indicate pending operations to push state.";
    }
    @Override
    public final void xsiteCancelReceiveFailed(final Throwable throwable, final String localSite, final String remoteSite) {
        super.log.logf(FQCN, WARN, throwable, xsiteCancelReceiveFailed$str(), localSite, remoteSite);
    }
    protected String xsiteCancelReceiveFailed$str() {
        return "ISPN000619: Cleanup failed for cross-site state transfer. Invoke the cancel-receive(%s) command in site %s if any nodes indicate pending operations to receive state.";
    }
    protected String xsiteStateTransferAlreadyInProgress$str() {
        return "ISPN000620: Cross-site state transfer to '%s' already started";
    }
    @Override
    public final CacheException xsiteStateTransferAlreadyInProgress(final String site) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), xsiteStateTransferAlreadyInProgress$str(), site));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elementRemovedUseOther$str() {
        return "ISPN000621: Element '%s' has been removed. Please use element '%s' instead";
    }
    @Override
    public final CacheConfigurationException elementRemovedUseOther(final String elementName, final String newElementName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), elementRemovedUseOther$str(), elementName, newElementName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String elementRemoved$str() {
        return "ISPN000622: Element '%s' has been removed with no replacement";
    }
    @Override
    public final CacheConfigurationException elementRemoved(final String elementName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), elementRemoved$str(), elementName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attributeRemovedUseOther$str() {
        return "ISPN000623: Attribute '%s' has been removed. Please use attribute '%s' instead";
    }
    @Override
    public final CacheConfigurationException attributeRemovedUseOther(final String attributeName, final String newAttributeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), attributeRemovedUseOther$str(), attributeName, newAttributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attributeRemoved$str() {
        return "ISPN000624: Attribute '%s' has been removed with no replacement";
    }
    @Override
    public final CacheConfigurationException attributeRemoved(final String attributeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), attributeRemoved$str(), attributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void indexLocationWorkingDir() {
        super.log.logf(FQCN, WARN, null, indexLocationWorkingDir$str());
    }
    protected String indexLocationWorkingDir$str() {
        return "ISPN000625: Index path not provided and global state disabled, will use the current working directory for storage.";
    }
    @Override
    public final void indexRelativeWorkingDir(final String path) {
        super.log.logf(FQCN, WARN, null, indexRelativeWorkingDir$str(), path);
    }
    protected String indexRelativeWorkingDir$str() {
        return "ISPN000626: Index path '%s' is not absolute and global state is disabled, will use a dir relative to the current working directory.";
    }
    protected String storeRequiresBeingSegmented$str() {
        return "ISPN000627: Invalid cache loader configuration for '%s'.  This implementation only supports being segmented!";
    }
    @Override
    public final CacheConfigurationException storeRequiresBeingSegmented(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeRequiresBeingSegmented$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchGlobalRoles$str() {
        return "ISPN000628: Invalid cache roles '%s'";
    }
    @Override
    public final CacheConfigurationException noSuchGlobalRoles(final Set<String> cacheRoles) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSuchGlobalRoles$str(), cacheRoles));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedPartitionHandlingTxCompletion(final GlobalTransaction globalTransaction, final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedPartitionHandlingTxCompletion$str(), globalTransaction);
    }
    protected String failedPartitionHandlingTxCompletion$str() {
        return "ISPN000629: Exception completing partial completed transaction %s. Retrying later.";
    }
    protected String invalidXSiteStateTransferMode$str() {
        return "ISPN000633: Cross-site state transfer mode cannot be null.";
    }
    @Override
    public final CacheConfigurationException invalidXSiteStateTransferMode() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidXSiteStateTransferMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String autoXSiteStateTransferModeNotAvailableInSync$str() {
        return "ISPN000634: Cross-site automatic state transfer is not compatible with SYNC backup strategy.";
    }
    @Override
    public final CacheConfigurationException autoXSiteStateTransferModeNotAvailableInSync() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), autoXSiteStateTransferModeNotAvailableInSync$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToStartXSiteAutStateTransfer(final String cacheName, final String targetSite, final Throwable t) {
        super.log.logf(FQCN, WARN, t, unableToStartXSiteAutStateTransfer$str(), cacheName, targetSite);
    }
    protected String unableToStartXSiteAutStateTransfer$str() {
        return "ISPN000635: [%s] Failed to receive a response from any nodes. Automatic cross-site state transfer to site '%s' is not started.";
    }
    protected String invalidStateTransferTimeout$str() {
        return "ISPN000636: State transfer timeout (%d) must be greater than or equal to the remote timeout (%d)";
    }
    @Override
    public final CacheConfigurationException invalidStateTransferTimeout(final Long stateTransferTimeout, final Long remoteTimeout) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidStateTransferTimeout$str(), stateTransferTimeout, remoteTimeout));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String topologyTimeout$str() {
        return "ISPN000637: Timeout waiting for topology %d, current topology is %d";
    }
    @Override
    public final TimeoutException topologyTimeout(final int expectedTopologyId, final int currentTopologyId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), topologyTimeout$str(), expectedTopologyId, currentTopologyId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String transactionDataTimeout$str() {
        return "ISPN000638: Timeout waiting for topology %d transaction data";
    }
    @Override
    public final TimeoutException transactionDataTimeout(final int expectedTopologyId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), transactionDataTimeout$str(), expectedTopologyId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnUsingDeprecatedSingleFileStore() {
        super.log.logf(FQCN, WARN, null, warnUsingDeprecatedSingleFileStore$str());
    }
    protected String warnUsingDeprecatedSingleFileStore$str() {
        return "ISPN000640: SingleFileStore has been deprecated and will be removed in a future version, replaced by SoftIndexFileStore";
    }
    protected String transactionAlreadyRolledBack$str() {
        return "ISPN000641: The transaction %s is already rolled back";
    }
    @Override
    public final InvalidTransactionException transactionAlreadyRolledBack(final GlobalTransaction gtx) {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), transactionAlreadyRolledBack$str(), gtx));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void startRecoveringCorruptPersistenceData(final String cacheName) {
        super.log.logf(FQCN, INFO, null, startRecoveringCorruptPersistenceData$str(), cacheName);
    }
    protected String startRecoveringCorruptPersistenceData$str() {
        return "ISPN000642: Attempting to recover possibly corrupted data file %s";
    }
    @Override
    public final void corruptDataSuccessfulMigrated(final String cacheName, final int entries) {
        super.log.logf(FQCN, INFO, null, corruptDataSuccessfulMigrated$str(), cacheName, entries);
    }
    protected String corruptDataSuccessfulMigrated$str() {
        return "ISPN000643: '%s' persisted data successfully recovered %d entries.";
    }
    protected String corruptDataMigrationFailed$str() {
        return "ISPN000644: Failed to recover '%s' persisted data.";
    }
    @Override
    public final PersistenceException corruptDataMigrationFailed(final String cacheName, final Throwable cause) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), corruptDataMigrationFailed$str(), cacheName), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTouchMode$str() {
        return "ISPN000645: Asynchronous cache modes, such as %s, cannot use SYNC touch mode for maximum idle expiration.";
    }
    @Override
    public final CacheConfigurationException invalidTouchMode(final CacheMode cacheMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTouchMode$str(), cacheMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalCapacityFactor$str() {
        return "ISPN000646: capacityFactor must be positive";
    }
    @Override
    public final IllegalArgumentException illegalCapacityFactor() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCapacityFactor$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotUpdateInternalCache$str() {
        return "ISPN000647: The configuration for internal cache '%s' cannot be modified";
    }
    @Override
    public final IllegalArgumentException cannotUpdateInternalCache(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotUpdateInternalCache$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAddStore$str() {
        return "ISPN000648: Cache '%s' is non empty, cannot add store.";
    }
    @Override
    public final PersistenceException cannotAddStore(final String cacheName) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotAddStore$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String segmentedSingleFileStoreDoesNotSupportMaxEntries$str() {
        return "ISPN000649: SingleFileStore does not support max-entries when segmented";
    }
    @Override
    public final CacheConfigurationException segmentedSingleFileStoreDoesNotSupportMaxEntries() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), segmentedSingleFileStoreDoesNotSupportMaxEntries$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSingleFileStoreData$str() {
        return "ISPN000650: Read invalid data in SingleFileStore file %s, please remove the file and retry";
    }
    @Override
    public final PersistenceException invalidSingleFileStoreData(final String path) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), invalidSingleFileStoreData$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String maxIdleNotAllowedWithoutPassivation$str() {
        return "ISPN000651: Max idle is not allowed while using a store without passivation";
    }
    @Override
    public final CacheConfigurationException maxIdleNotAllowedWithoutPassivation() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), maxIdleNotAllowedWithoutPassivation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void maxIdleNotTestedWithPassivation() {
        super.log.logf(FQCN, WARN, null, maxIdleNotTestedWithPassivation$str());
    }
    protected String maxIdleNotTestedWithPassivation$str() {
        return "ISPN000652: Max idle is not supported when using a store";
    }
    @Override
    public final void attributeDeprecatedUseOther(final Enum<?> attr, final Enum<?> element, final Enum<?> other) {
        super.log.logf(FQCN, WARN, null, attributeDeprecatedUseOther$str(), attr, element, other);
    }
    protected String attributeDeprecatedUseOther$str() {
        return "ISPN000653: The '%s' attribute on the '%s' element has been deprecated. Please use the '%s' attribute instead";
    }
    protected String problemPreloadingKey$str() {
        return "ISPN000654: Problem encountered when preloading key %s!";
    }
    @Override
    public final PersistenceException problemPreloadingKey(final Object key, final Throwable t) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), problemPreloadingKey$str(), key), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJson$str() {
        return "ISPN000655: Unable to convert text content to JSON: '%s'";
    }
    @Override
    public final EncodingException invalidJson(final String s) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidJson$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPolicyWithAsyncStrategy$str() {
        return "ISPN000656: The backup '%s' configuration 'failure-policy=%s' is not valid with an ASYNC backup strategy.";
    }
    @Override
    public final CacheConfigurationException invalidPolicyWithAsyncStrategy(final String remoteSite, final BackupFailurePolicy policy) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidPolicyWithAsyncStrategy$str(), remoteSite, policy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failurePolicyClassNotCompatibleWith$str() {
        return "ISPN000657: The backup '%s' configuration 'failure-policy-class' is not compatible with 'failure-policy=%s'. Use 'failure-policy=\"CUSTOM\"'";
    }
    @Override
    public final CacheConfigurationException failurePolicyClassNotCompatibleWith(final String remoteSite, final BackupFailurePolicy policy) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), failurePolicyClassNotCompatibleWith$str(), remoteSite, policy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String initialStateTransferTimeout$str() {
        return "ISPN000658: Initial state transfer timed out for cache %s on %s";
    }
    @Override
    public final TimeoutException initialStateTransferTimeout(final String cacheName, final Address localAddress) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), initialStateTransferTimeout$str(), cacheName, localAddress));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String componentFailedToStart$str() {
        return "ISPN000659: Component %s failed to start";
    }
    @Override
    public final CacheConfigurationException componentFailedToStart(final String componentName, final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), componentFailedToStart$str(), componentName), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void startFailure(final String registryName, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, startFailure$str(), registryName);
    }
    protected String startFailure$str() {
        return "ISPN000660: %s start failed, stopping any running components";
    }
    @Override
    public final void configDeprecated(final Enum<?> element) {
        super.log.logf(FQCN, WARN, null, configDeprecated$str(), element);
    }
    protected String configDeprecated$str() {
        return "ISPN000661: '%s' has been deprecated with no replacement.";
    }
    @Override
    public final void failedToTransferTombstones(final Address requestor, final IntSet segments, final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedToTransferTombstones$str(), requestor, segments);
    }
    protected String failedToTransferTombstones$str() {
        return "ISPN000662: Failed to transfer cross-site tombstones to %s for segments %s.";
    }
    protected String invalidNameSize$str() {
        return "ISPN000663: Name must be less than 256 bytes, current name '%s' exceeds the size.";
    }
    @Override
    public final CacheConfigurationException invalidNameSize(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidNameSize$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIndexStartUpMode$str() {
        return "ISPN000664: Invalid index startup mode: %s";
    }
    @Override
    public final CacheConfigurationException invalidIndexStartUpMode(final String invalidValue) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidIndexStartUpMode$str(), invalidValue));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void scheduledTaskEncounteredThrowable(final Object identifier, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, scheduledTaskEncounteredThrowable$str(), identifier);
    }
    protected String scheduledTaskEncounteredThrowable$str() {
        return "ISPN000665: There was an error in submitted periodic task with %s, not rescheduling.";
    }
    protected String requireNonNullClusterName$str() {
        return "ISPN000666: Transport clusterName cannot be null.";
    }
    @Override
    public final CacheConfigurationException requireNonNullClusterName() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requireNonNullClusterName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requireNodeName$str() {
        return "ISPN000667: Transport node-name is not set.";
    }
    @Override
    public final CacheConfigurationException requireNodeName() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), requireNodeName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeNameNotInRaftMembers$str() {
        return "ISPN000668: Transport node-name must be present in raft-members: %s";
    }
    @Override
    public final CacheConfigurationException nodeNameNotInRaftMembers(final String members) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nodeNameNotInRaftMembers$str(), members));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String forkProtocolRequired$str() {
        return "ISPN000669: FORK protocol required on JGroups channel.";
    }
    @Override
    public final IllegalArgumentException forkProtocolRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), forkProtocolRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorCreatingForkChannel(final String name, final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, errorCreatingForkChannel$str(), name);
    }
    protected String errorCreatingForkChannel$str() {
        return "ISPN000670: Error creating fork channel for %s";
    }
    @Override
    public final void raftProtocolUnavailable(final String reason) {
        super.log.logf(FQCN, WARN, null, raftProtocolUnavailable$str(), reason);
    }
    protected String raftProtocolUnavailable$str() {
        return "ISPN000671: RAFT protocol is not available. Reason: %s";
    }
    @Override
    public final void raftProtocolAvailable() {
        super.log.logf(FQCN, INFO, null, raftProtocolAvailable$str());
    }
    protected String raftProtocolAvailable$str() {
        return "ISPN000672: RAFT protocol is available.";
    }
    protected String raftGlobalStateDisabled$str() {
        return "ISPN000673: Cannot persist RAFT data as global state is disabled";
    }
    @Override
    public final CacheConfigurationException raftGlobalStateDisabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), raftGlobalStateDisabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String issueEncounteredResettingIndex$str() {
        return "ISPN000674: There was an error when resetting the SIFS index for cache %s";
    }
    @Override
    public final PersistenceException issueEncounteredResettingIndex(final String cacheName, final Throwable t) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), issueEncounteredResettingIndex$str(), cacheName), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedInvokingEventLoggerListener(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedInvokingEventLoggerListener$str());
    }
    protected String failedInvokingEventLoggerListener$str() {
        return "ISPN000675: Caught exception while invoking a event logger listener!";
    }
    @Override
    public final void storeIsAvailableCheckThrewException(final Throwable e, final String storeImpl) {
        super.log.logf(FQCN, WARN, e, storeIsAvailableCheckThrewException$str(), storeImpl);
    }
    protected String storeIsAvailableCheckThrewException$str() {
        return "ISPN000676: Store '%s'#isAvailable check threw Exception";
    }
    @Override
    public final void storeIsAvailableCompletedExceptionally(final Throwable e, final String storeImpl) {
        super.log.logf(FQCN, WARN, e, storeIsAvailableCompletedExceptionally$str(), storeImpl);
    }
    protected String storeIsAvailableCompletedExceptionally$str() {
        return "ISPN000677: Store '%s'#isAvailable completed Exceptionally";
    }
    @Override
    public final void persistenceUnavailable(final String storeImpl) {
        super.log.logf(FQCN, WARN, null, persistenceUnavailable$str(), storeImpl);
    }
    protected String persistenceUnavailable$str() {
        return "ISPN000678: Persistence is unavailable because of store %s";
    }
    @Override
    public final void persistenceAvailable() {
        super.log.logf(FQCN, INFO, null, persistenceAvailable$str());
    }
    protected String persistenceAvailable$str() {
        return "ISPN000679: Persistence is now available";
    }
    protected String expirationNotAllowedWhenStoreDoesNotSupport$str() {
        return "ISPN000680: Expiration (Max idle or Lifespan) is not allowed while using a store '%s' that does not support expiration, unless it is configured as read only";
    }
    @Override
    public final CacheConfigurationException expirationNotAllowedWhenStoreDoesNotSupport(final String storeImpl) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), expirationNotAllowedWhenStoreDoesNotSupport$str(), storeImpl));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
