/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapCache;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.manager.CacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.Marshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.StateTransferManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class CacheDelegate<K, V>
implements AdvancedCache<K, V>,
AtomicMapCache<K, V> {
    protected InvocationContextContainer invocationContextContainer;
    protected CommandsFactory commandsFactory;
    protected InterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected Marshaller marshaller;
    private String name;
    private EvictionManager evictionManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheDelegate.class);
    private CacheManager cacheManager;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private long defaultLifespan;
    private long defaultMaxIdleTime;

    public CacheDelegate(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, InvocationContextContainer invocationContextContainer, CommandsFactory commandsFactory, InterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, Marshaller marshaller, ResponseGenerator responseGenerator, CacheManager cacheManager, StateTransferManager stateTransferManager) {
        this.invocationContextContainer = invocationContextContainer;
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.responseGenerator = responseGenerator;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean remove(Object key, Object value) {
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value);
        return (Boolean)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V replace(K key, V value) {
        return this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        SizeCommand command = this.commandsFactory.buildSizeCommand();
        return (Integer)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public boolean isEmpty() {
        SizeCommand command = this.commandsFactory.buildSizeCommand();
        int size = (Integer)this.invoker.invoke(this.getInvocationContext(), command);
        return size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key);
        Object response = this.invoker.invoke(this.getInvocationContext(), command);
        return response != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Go away");
    }

    @Override
    public V get(Object key) {
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key);
        return (V)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V remove(Object key) {
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return (V)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void clear() {
        ClearCommand command = this.commandsFactory.buildClearCommand();
        this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("TODO implement me");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void putForExternalRead(K key, V value) {
        block13: {
            Transaction ongoingTransaction = null;
            if (this.transactionManager != null && (ongoingTransaction = this.transactionManager.getTransaction()) != null) {
                this.transactionManager.suspend();
            }
            this.putIfAbsent(key, value, Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
            Object var6_4 = null;
            try {
                if (ongoingTransaction != null) {
                    this.transactionManager.resume(ongoingTransaction);
                }
                break block13;
            }
            catch (Exception e2) {
                log.debug((Object)"Had problems trying to resume a transaction after putForExternalread()", e2);
            }
            break block13;
            {
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Caught exception while doing putForExternalRead()", e);
                    }
                    Object var6_5 = null;
                    try {
                        if (ongoingTransaction != null) {
                            this.transactionManager.resume(ongoingTransaction);
                        }
                        break block13;
                    }
                    catch (Exception e2) {
                        log.debug((Object)"Had problems trying to resume a transaction after putForExternalread()", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (ongoingTransaction != null) {
                        this.transactionManager.resume(ongoingTransaction);
                    }
                }
                catch (Exception e2) {
                    log.debug((Object)"Had problems trying to resume a transaction after putForExternalread()", e2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void evict(K key) {
        EvictCommand command = this.commandsFactory.buildEvictCommand(key);
        this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContext() {
        return (InvocationContext)this.invocationContextContainer.get();
    }

    @Override
    public void start() {
        this.componentRegistry.start();
        this.defaultLifespan = this.config.getExpirationLifespan();
        this.defaultMaxIdleTime = this.config.getExpirationMaxIdle();
    }

    @Override
    public void stop() {
        this.componentRegistry.stop();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public void addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public void addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public void putForExternalRead(K key, V value, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        this.putForExternalRead(key, value);
    }

    @Override
    public V put(K key, V value, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V putIfAbsent(K key, V value, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        this.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V remove(Object key, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.remove(key);
    }

    @Override
    public boolean remove(Object key, Object oldValue, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.remove(key, oldValue);
    }

    @Override
    public void clear(Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        this.clear();
    }

    @Override
    public boolean containsKey(Object key, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.containsKey(key);
    }

    @Override
    public V get(Object key, Flag ... flags) {
        this.getInvocationContext().setFlags(flags);
        return this.get(key);
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @Override
    public boolean startBatch() {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        return this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.endBatch(successful);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return "4.0.0.ALPHA1";
    }

    public String toString() {
        return this.dataContainer == null ? super.toString() : this.dataContainer.toString();
    }

    @Override
    public <AMK, AMV> AtomicMap<AMK, AMV> getAtomicMap(K key) throws ClassCastException {
        Object value = this.get(key);
        if (value == null) {
            value = AtomicHashMap.newInstance(this, key);
        }
        return ((AtomicHashMap)value).getProxy(this, key, this.batchContainer, this.invocationContextContainer);
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.invocationContextContainer;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (V)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        command.setPutIfAbsent(true);
        return (V)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (V)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (Boolean)this.invoker.invoke(this.getInvocationContext(), command);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public void compact() {
        for (InternalCacheEntry e : this.dataContainer) {
            if (e.getKey() instanceof MarshalledValue) {
                ((MarshalledValue)e.getKey()).compact(true, true);
            }
            if (!(e.getValue() instanceof MarshalledValue)) continue;
            ((MarshalledValue)e.getValue()).compact(true, true);
        }
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }
}

