/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.AtomicHashMapProxy;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.ClearOperation;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.NullDelta;
import org.infinispan.atomic.PutOperation;
import org.infinispan.atomic.RemoveOperation;
import org.infinispan.batch.BatchContainer;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.util.FastCopyHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class AtomicHashMap<K, V>
implements AtomicMap<K, V>,
DeltaAware,
Cloneable {
    FastCopyHashMap<K, V> delegate = new FastCopyHashMap();
    AtomicHashMapDelta delta = null;
    volatile AtomicHashMapProxy proxy;

    public static AtomicHashMap newInstance(Cache cache, Object cacheKey) {
        AtomicHashMap value = new AtomicHashMap();
        AtomicHashMap oldValue = cache.putIfAbsent(cacheKey, value);
        if (oldValue != null) {
            value = oldValue;
        }
        return value;
    }

    AtomicHashMap() {
    }

    @Override
    public void commit() {
        if (this.delta != null) {
            this.delta = null;
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(K key, V value) {
        PutOperation op = new PutOperation();
        op.key = key;
        op.newValue = value;
        op.oldValue = this.delegate.put(key, value);
        this.delta.addOperation(op);
        return op.oldValue;
    }

    @Override
    public V remove(Object key) {
        RemoveOperation op = new RemoveOperation();
        op.key = key;
        op.oldValue = this.delegate.remove(key);
        this.delta.addOperation(op);
        return op.oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        ClearOperation op = new ClearOperation();
        op.originalEntries = (FastCopyHashMap)this.delegate.clone();
        this.delta.addOperation(op);
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicMap getProxy(Cache cache, Object mapKey, BatchContainer batchContainer, InvocationContextContainer invocationContextContainer) {
        if (this.proxy == null) {
            AtomicHashMap atomicHashMap = this;
            synchronized (atomicHashMap) {
                if (this.proxy == null) {
                    this.proxy = new AtomicHashMapProxy(cache, mapKey, batchContainer, invocationContextContainer);
                }
            }
        }
        return this.proxy;
    }

    @Override
    public Delta delta() {
        Delta toReturn = this.delta == null ? NullDelta.INSTANCE : this.delta;
        this.delta = null;
        return toReturn;
    }

    public AtomicHashMap copyForWrite() {
        try {
            AtomicHashMap clone = (AtomicHashMap)super.clone();
            clone.delegate = (FastCopyHashMap)this.delegate.clone();
            clone.proxy = this.proxy;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "AtomicHashMap{delegate=" + this.delegate + '}';
    }

    public void initForWriting() {
        this.delta = new AtomicHashMapDelta();
    }
}

