/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.invocation.Flag;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicHashMapProxy<K, V>
extends AutoBatchSupport
implements AtomicMap<K, V> {
    private static final Log log = LogFactory.getLog(AtomicHashMapProxy.class);
    private static final boolean trace = log.isTraceEnabled();
    Object deltaMapKey;
    Cache cache;
    InvocationContextContainer icc;

    public AtomicHashMapProxy(Cache cache, Object deltaMapKey, BatchContainer batchContainer, InvocationContextContainer icc) {
        this.cache = cache;
        this.deltaMapKey = deltaMapKey;
        this.batchContainer = batchContainer;
        this.icc = icc;
    }

    private AtomicHashMap<K, V> getDeltaMapForRead() {
        return (AtomicHashMap)this.cache.get(this.deltaMapKey);
    }

    private AtomicHashMap<K, V> getDeltaMapForWrite() {
        AtomicHashMap<K, V> map;
        if (this.ownsLock()) {
            return (AtomicHashMap)this.cache.get(this.deltaMapKey);
        }
        boolean suppressLocks = ((InvocationContext)this.icc.get()).hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks) {
            ((InvocationContext)this.icc.get()).setFlags(Flag.FORCE_WRITE_LOCK);
        }
        if (trace) {
            if (suppressLocks) {
                log.trace("Skip locking flag used.  Skipping locking.");
            } else {
                log.trace("Forcing write lock even for reads");
            }
        }
        AtomicHashMap copy = (map = this.getDeltaMapForRead()) == null ? new AtomicHashMap() : map.copyForWrite();
        copy.initForWriting();
        if (suppressLocks) {
            ((InvocationContext)this.icc.get()).setFlags(Flag.SKIP_LOCKING);
        }
        this.cache.put(this.deltaMapKey, copy);
        return copy;
    }

    private boolean ownsLock() {
        return ((InvocationContext)this.icc.get()).hasLockedKey(this.deltaMapKey);
    }

    @Override
    public Set<K> keySet() {
        return this.getDeltaMapForRead().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getDeltaMapForRead().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getDeltaMapForRead().entrySet();
    }

    @Override
    public int size() {
        return this.getDeltaMapForRead().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDeltaMapForRead().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getDeltaMapForRead().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDeltaMapForRead().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.getDeltaMapForRead().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V v;
        try {
            this.startAtomic();
            v = this.getDeltaMapForWrite().put(key, value);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.endAtomic();
            throw throwable;
        }
        this.endAtomic();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        V v;
        try {
            this.startAtomic();
            v = this.getDeltaMapForWrite().remove(key);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.endAtomic();
            throw throwable;
        }
        this.endAtomic();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.startAtomic();
            this.getDeltaMapForWrite().putAll(m);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.endAtomic();
            throw throwable;
        }
        this.endAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.startAtomic();
            this.getDeltaMapForWrite().clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endAtomic();
            throw throwable;
        }
        this.endAtomic();
    }

    public String toString() {
        return "AtomicHashMapProxy{deltaMapKey=" + this.deltaMapKey + '}';
    }
}

