/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.batch;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.factories.annotations.Inject;

public class BatchContainer {
    TransactionManager transactionManager;
    private ThreadLocal<BatchDetails> batchDetails = new ThreadLocal<BatchDetails>(){

        @Override
        protected BatchDetails initialValue() {
            return new BatchDetails();
        }
    };

    @Inject
    void inject(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean startBatch() throws CacheException {
        return this.startBatch(false);
    }

    public boolean startBatch(boolean autoBatch) throws CacheException {
        BatchDetails bd = this.batchDetails.get();
        try {
            if (this.transactionManager.getTransaction() == null && bd.tx == null) {
                this.transactionManager.begin();
                bd.invocationCount = 1;
                bd.suspendTxAfterInvocation = !autoBatch;
                bd.tx = autoBatch ? this.transactionManager.getTransaction() : this.transactionManager.suspend();
                boolean bl = true;
                return bl;
            }
            ++bd.invocationCount;
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CacheException("Unable to start batch", e);
        }
        finally {
            this.batchDetails.set(bd);
        }
    }

    public void endBatch(boolean success) {
        this.endBatch(false, success);
    }

    public void endBatch(boolean autoBatch, boolean success) {
        BatchDetails bd = this.batchDetails.get();
        if (bd.tx == null) {
            return;
        }
        if (autoBatch) {
            --bd.invocationCount;
        }
        if (!autoBatch || bd.invocationCount == 0) {
            Transaction existingTx = null;
            try {
                existingTx = this.transactionManager.getTransaction();
                if (existingTx == null && !autoBatch || !bd.tx.equals(existingTx)) {
                    this.transactionManager.resume(bd.tx);
                }
                if (success) {
                    bd.tx.commit();
                }
                bd.tx.rollback();
            }
            catch (Exception e) {
                throw new CacheException("Unable to end batch", e);
            }
            finally {
                this.batchDetails.remove();
                try {
                    if (!autoBatch && existingTx != null) {
                        this.transactionManager.resume(existingTx);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Failed resuming existing transaction " + existingTx, e);
                }
            }
        } else {
            this.batchDetails.set(bd);
        }
    }

    public Transaction getBatchTransaction() {
        return this.batchDetails.get().tx;
    }

    public boolean isSuspendTxAfterInvocation() {
        return this.batchDetails.get().suspendTxAfterInvocation;
    }

    private static class BatchDetails {
        int invocationCount;
        boolean suspendTxAfterInvocation;
        Transaction tx;

        private BatchDetails() {
        }
    }
}

