/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loader.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsFactoryImpl
implements CommandsFactory {
    private DataContainer dataContainer;
    private CacheNotifier notifier;
    private Cache cache;
    private CacheLoaderManager cacheLoaderManager;
    SizeCommand cachedSizeCommand;
    private InterceptorChain interceptorChain;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier notifier, Cache cache, InterceptorChain interceptorChain, CacheLoaderManager clManager) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.cacheLoaderManager = clManager;
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis) {
        return new PutKeyValueCommand(key, value, false, this.notifier, lifespanMillis, maxIdleTimeMillis);
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value) {
        return new RemoveCommand(key, value, this.notifier);
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Object ... keys) {
        return new InvalidateCommand(this.notifier, keys);
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, long lifespan, long maxIdleTimeMillis) {
        return new ReplaceCommand(key, oldValue, newValue, lifespan, maxIdleTimeMillis);
    }

    @Override
    public SizeCommand buildSizeCommand() {
        if (this.cachedSizeCommand == null) {
            this.cachedSizeCommand = new SizeCommand(this.dataContainer);
        }
        return this.cachedSizeCommand;
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key) {
        return new GetKeyValueCommand(key, this.notifier);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map map, long lifespan, long maxIdleTimeMillis) {
        return new PutMapCommand(map, this.notifier, lifespan, maxIdleTimeMillis);
    }

    @Override
    public ClearCommand buildClearCommand() {
        return new ClearCommand();
    }

    @Override
    public EvictCommand buildEvictCommand(Object key) {
        EvictCommand command = new EvictCommand(key, this.notifier);
        return command;
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List modifications, Address localAddress, boolean onePhaseCommit) {
        return new PrepareCommand(gtx, modifications, localAddress, onePhaseCommit);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return new CommitCommand(gtx);
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return new RollbackCommand(gtx);
    }

    @Override
    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return new MultipleRpcCommand(toReplicate, this.cache.getName());
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cache.getName(), call);
    }

    @Override
    public StateTransferControlCommand buildStateTransferControlCommand(boolean block) {
        return new StateTransferControlCommand(block);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key) {
        return new ClusteredGetCommand(key, this.cache.getName());
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 3: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 121: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 6: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 13: {
                MultipleRpcCommand rc = (MultipleRpcCommand)c;
                rc.setInterceptorChain(this.interceptorChain);
                if (rc.getCommands() == null) break;
                for (ReplicableCommand nested : rc.getCommands()) {
                    this.initializeReplicableCommand(nested);
                }
                break;
            }
            case 21: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.setInterceptorChain(this.interceptorChain);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand());
                break;
            }
            case 47: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 10: {
                PrepareCommand pc = (PrepareCommand)c;
                if (pc.getModifications() == null) break;
                for (WriteCommand nested : pc.getModifications()) {
                    this.initializeReplicableCommand(nested);
                }
                break;
            }
            case 22: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.dataContainer, this.cacheLoaderManager);
            }
        }
    }
}

