/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class GetKeyValueCommand
extends AbstractDataCommand {
    public static final byte METHOD_ID = 26;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private CacheNotifier notifier;

    public GetKeyValueCommand(Object key, CacheNotifier notifier) {
        this.key = key;
        this.notifier = notifier;
    }

    public GetKeyValueCommand() {
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null || entry.isNull()) {
            if (trace) {
                log.trace("Entry not found");
            }
            return null;
        }
        if (entry.isRemoved()) {
            if (trace) {
                log.trace("Entry has been deleted and is of type " + entry.getClass().getSimpleName());
            }
            return null;
        }
        this.notifier.notifyCacheEntryVisited(this.key, true, ctx);
        Object result = entry.getValue();
        if (trace) {
            log.trace("Found value " + result);
        }
        this.notifier.notifyCacheEntryVisited(this.key, false, ctx);
        return result;
    }

    public byte getCommandId() {
        return 26;
    }
}

