/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

public abstract class BaseRpcCommand
implements CacheRpcCommand {
    protected InterceptorChain interceptorChain;
    protected String cacheName;
    private static final Log log = LogFactory.getLog(BaseRpcCommand.class);
    private static final boolean trace = log.isTraceEnabled();

    protected BaseRpcCommand(String cacheName) {
        this.cacheName = cacheName;
    }

    BaseRpcCommand() {
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setInterceptorChain(InterceptorChain interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    protected final Object processCommand(InvocationContext ctx, ReplicableCommand cacheCommand) throws Throwable {
        if (trace) {
            log.trace("Invoking command " + cacheCommand + ", with originLocal flag set to false.");
        }
        ctx.setOriginLocal(false);
        if (!(cacheCommand instanceof VisitableCommand)) {
            throw new RuntimeException("Do we still need to deal with non-visitable commands? (" + cacheCommand.getClass().getName() + ")");
        }
        Object retVal = this.interceptorChain.invokeRemote((VisitableCommand)cacheCommand);
        Object result = null;
        return result;
    }
}

