/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import org.infinispan.CacheException;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.loader.CacheLoaderManager;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;

public class ClusteredGetCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 22;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private Object key;
    private String cacheName;
    private DataContainer dataContainer;
    private CacheLoaderManager cacheLoaderManager;

    public ClusteredGetCommand() {
    }

    public ClusteredGetCommand(Object key, String cacheName) {
        this.key = key;
        this.cacheName = cacheName;
    }

    public void initialize(DataContainer dataContainer, CacheLoaderManager clManager) {
        this.dataContainer = dataContainer;
        this.cacheLoaderManager = clManager;
    }

    public CacheEntry perform(InvocationContext context) throws Throwable {
        if (this.key != null) {
            InternalCacheEntry cacheEntry = this.dataContainer.get(this.key);
            if (cacheEntry == null) {
                context.setOriginLocal(false);
                if (this.cacheLoaderManager != null && this.cacheLoaderManager.getCacheLoader() != null) {
                    cacheEntry = this.cacheLoaderManager.getCacheLoader().load(this.key);
                }
            }
            return cacheEntry;
        }
        throw new CacheException("Invalid command. Missing key!");
    }

    public byte getCommandId() {
        return 22;
    }

    public Object[] getParameters() {
        return new Object[]{this.key, this.cacheName};
    }

    public void setParameters(int commandId, Object[] args) {
        this.key = args[0];
        this.cacheName = (String)args[1];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return !(this.key == null ? that.key != null : !this.key.equals(that.key));
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        return result;
    }

    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", dataContainer=" + this.dataContainer + '}';
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

