/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Arrays;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class InvalidateCommand
extends RemoveCommand {
    public static final int COMMAND_ID = 47;
    private static final Log log = LogFactory.getLog(InvalidateCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object[] keys;

    public InvalidateCommand() {
    }

    public InvalidateCommand(CacheNotifier notifier, Object ... keys) {
        this.keys = keys;
        this.notifier = notifier;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        if (trace) {
            log.trace("Invalidating keys:" + Arrays.toString(this.keys));
        }
        Object[] arr$ = this.keys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object key;
            this.key = key = arr$[i$];
            super.perform(ctx);
        }
        return null;
    }

    protected void notify(InvocationContext ctx, Object value, boolean isPre) {
        this.notifier.notifyCacheEntryInvalidated(this.key, isPre, ctx);
    }

    public byte getCommandId() {
        return 47;
    }

    public String toString() {
        return "InvalidateCommand{keys=" + Arrays.toString(this.keys) + '}';
    }

    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{0};
        }
        if (this.keys.length == 1) {
            return new Object[]{1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 1];
        retval[0] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 1, this.keys.length);
        return retval;
    }

    public void setParameters(int commandId, Object[] args) {
        int size = (Integer)args[0];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[1];
        } else if (size > 0) {
            System.arraycopy(args, 1, this.keys, 0, size);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    public Object getKey() {
        throw new UnsupportedOperationException("Not supported.  Use getKeys() instead.");
    }

    public Object[] getKeys() {
        return this.keys;
    }
}

