/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PutKeyValueCommand
extends AbstractDataCommand
implements DataWriteCommand {
    public static final byte COMMAND_ID = 3;
    Object value;
    boolean putIfAbsent;
    CacheNotifier notifier;
    boolean successful = true;
    long lifespanMillis = -1L;
    long maxIdleTimeMillis = -1L;

    public PutKeyValueCommand() {
    }

    public PutKeyValueCommand(Object key, Object value, boolean putIfAbsent, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis) {
        super(key);
        this.value = value;
        this.putIfAbsent = putIfAbsent;
        this.notifier = notifier;
        this.lifespanMillis = lifespanMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutKeyValueCommand(ctx, this);
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        Object o;
        MVCCEntry e = this.lookupMvccEntry(ctx, this.key);
        if (e.getValue() != null && this.putIfAbsent) {
            this.successful = false;
            return e.getValue();
        }
        this.notifier.notifyCacheEntryModified(this.key, e.getValue(), true, ctx);
        if (this.value instanceof Delta) {
            Delta dv = (Delta)this.value;
            Object existing = e.getValue();
            DeltaAware toMergeWith = null;
            if (existing instanceof DeltaAware) {
                toMergeWith = (DeltaAware)existing;
            }
            e.setValue(dv.merge(toMergeWith));
            o = existing;
            e.setLifespan(this.lifespanMillis);
            e.setMaxIdle(this.maxIdleTimeMillis);
        } else {
            o = e.setValue(this.value);
            e.setLifespan(this.lifespanMillis);
            e.setMaxIdle(this.maxIdleTimeMillis);
        }
        this.notifier.notifyCacheEntryModified(this.key, e.getValue(), false, ctx);
        return o;
    }

    public byte getCommandId() {
        return 3;
    }

    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.lifespanMillis, this.maxIdleTimeMillis};
    }

    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 3) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.value = parameters[1];
        this.lifespanMillis = (Long)parameters[2];
        this.maxIdleTimeMillis = (Long)parameters[3];
    }

    public boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public void setPutIfAbsent(boolean putIfAbsent) {
        this.putIfAbsent = putIfAbsent;
    }

    public long getLifespanMillis() {
        return this.lifespanMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutKeyValueCommand that = (PutKeyValueCommand)o;
        if (this.lifespanMillis != that.lifespanMillis) {
            return false;
        }
        if (this.maxIdleTimeMillis != that.maxIdleTimeMillis) {
            return false;
        }
        if (this.putIfAbsent != that.putIfAbsent) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.putIfAbsent ? 1 : 0);
        result = 31 * result + (int)(this.lifespanMillis ^ this.lifespanMillis >>> 32);
        result = 31 * result + (int)(this.maxIdleTimeMillis ^ this.maxIdleTimeMillis >>> 32);
        return result;
    }

    public String toString() {
        return "PutKeyValueCommand{key=" + this.key + ", value=" + this.value + ", putIfAbsent=" + this.putIfAbsent + '}';
    }

    public boolean isSuccessful() {
        return this.successful;
    }
}

