/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.Dynamic;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DefaultConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.lock.IsolationLevel;
import org.infinispan.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class Configuration
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 5553791890144997466L;
    private GlobalConfiguration globalConfiguration;
    private boolean useLockStriping = true;
    private boolean useReplQueue = false;
    private int replQueueMaxElements = 1000;
    private long replQueueInterval = 5000L;
    private boolean exposeJmxStatistics = false;
    @Dynamic
    private boolean fetchInMemoryState = true;
    @Dynamic
    private long lockAcquisitionTimeout = 10000L;
    @Dynamic
    private long syncReplTimeout = 15000L;
    private CacheMode cacheMode = CacheMode.LOCAL;
    @Dynamic
    private long stateRetrievalTimeout = 10000L;
    private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private String transactionManagerLookupClass = null;
    private CacheLoaderManagerConfig cacheLoaderManagerConfig = null;
    @Dynamic
    private boolean syncCommitPhase = false;
    @Dynamic
    private boolean syncRollbackPhase = false;
    private boolean useLazyDeserialization = false;
    private List<CustomInterceptorConfig> customInterceptors = Collections.emptyList();
    private boolean writeSkewCheck = false;
    private int concurrencyLevel = 500;
    private boolean invocationBatchingEnabled;
    private boolean useAsyncSerialization = true;
    private long evictionWakeUpInterval = 5000L;
    private EvictionStrategy evictionStrategy = EvictionStrategy.NONE;
    private int evictionMaxEntries = -1;
    private long expirationLifespan = -1L;
    private long expirationMaxIdle = -1L;
    private boolean l1CacheEnabled = true;
    private long l1Lifespan = 600000L;
    private boolean l1OnRehash = true;
    private String consistentHashClass = DefaultConsistentHash.class.getName();
    private int numOwners = 2;
    private long rehashWaitTime = 60000L;

    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    @Inject
    private void injectGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public boolean isUseAsyncSerialization() {
        return this.useAsyncSerialization;
    }

    public boolean isStateTransferEnabled() {
        return this.fetchInMemoryState || this.cacheLoaderManagerConfig != null && this.cacheLoaderManagerConfig.isFetchPersistentState();
    }

    public void setUseLockStriping(boolean useLockStriping) {
        this.testImmutability("useLockStriping");
        this.useLockStriping = useLockStriping;
    }

    public boolean isUseLockStriping() {
        return this.useLockStriping;
    }

    @Start(priority=1)
    private void correctIsolationLevels() {
        switch (this.isolationLevel) {
            case NONE: 
            case READ_UNCOMMITTED: {
                this.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case SERIALIZABLE: {
                this.isolationLevel = IsolationLevel.REPEATABLE_READ;
            }
        }
    }

    public boolean isWriteSkewCheck() {
        return this.writeSkewCheck;
    }

    public void setWriteSkewCheck(boolean writeSkewCheck) {
        this.testImmutability("writeSkewCheck");
        this.writeSkewCheck = writeSkewCheck;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.testImmutability("concurrencyLevel");
        this.concurrencyLevel = concurrencyLevel;
    }

    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.testImmutability("replQueueMaxElements");
        this.replQueueMaxElements = replQueueMaxElements;
    }

    public void setReplQueueInterval(long replQueueInterval) {
        this.testImmutability("replQueueInterval");
        this.replQueueInterval = replQueueInterval;
    }

    public void setReplQueueInterval(long replQueueInterval, TimeUnit timeUnit) {
        this.setReplQueueInterval(timeUnit.toMillis(replQueueInterval));
    }

    public void setExposeJmxStatistics(boolean useMbean) {
        this.testImmutability("exposeJmxStatistics");
        this.exposeJmxStatistics = useMbean;
    }

    public void setInvocationBatchingEnabled(boolean enabled) {
        this.testImmutability("invocationBatchingEnabled");
        this.invocationBatchingEnabled = enabled;
    }

    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.testImmutability("fetchInMemoryState");
        this.fetchInMemoryState = fetchInMemoryState;
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.testImmutability("lockAcquisitionTimeout");
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout, TimeUnit timeUnit) {
        this.setLockAcquisitionTimeout(timeUnit.toMillis(lockAcquisitionTimeout));
    }

    public void setSyncReplTimeout(long syncReplTimeout) {
        this.testImmutability("syncReplTimeout");
        this.syncReplTimeout = syncReplTimeout;
    }

    public void setSyncReplTimeout(long syncReplTimeout, TimeUnit timeUnit) {
        this.setSyncReplTimeout(timeUnit.toMillis(syncReplTimeout));
    }

    public void setCacheMode(CacheMode cacheModeInt) {
        this.testImmutability("cacheMode");
        this.cacheMode = cacheModeInt;
    }

    public void setCacheMode(String cacheMode) {
        this.testImmutability("cacheMode");
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.cacheMode = CacheMode.valueOf(this.uc(cacheMode));
        if (this.cacheMode == null) {
            this.log.warn("Unknown cache mode '" + cacheMode + "', using defaults.");
            this.cacheMode = CacheMode.LOCAL;
        }
    }

    public String getCacheModeString() {
        return this.cacheMode == null ? null : this.cacheMode.toString();
    }

    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    public long getEvictionWakeUpInterval() {
        return this.evictionWakeUpInterval;
    }

    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.testImmutability("evictionWakeUpInterval");
        this.evictionWakeUpInterval = evictionWakeUpInterval;
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.evictionStrategy;
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.testImmutability("evictionStrategy");
        this.evictionStrategy = evictionStrategy;
    }

    public int getEvictionMaxEntries() {
        return this.evictionMaxEntries;
    }

    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.testImmutability("evictionMaxEntries");
        this.evictionMaxEntries = evictionMaxEntries;
    }

    public long getExpirationLifespan() {
        return this.expirationLifespan;
    }

    public void setExpirationLifespan(long expirationLifespan) {
        this.testImmutability("expirationLifespan");
        this.expirationLifespan = expirationLifespan;
    }

    public long getExpirationMaxIdle() {
        return this.expirationMaxIdle;
    }

    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.testImmutability("expirationMaxIdle");
        this.expirationMaxIdle = expirationMaxIdle;
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.testImmutability("transactionManagerLookupClass");
        this.transactionManagerLookupClass = transactionManagerLookupClass;
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.testImmutability("cacheLoaderManagerConfig");
        this.cacheLoaderManagerConfig = cacheLoaderManagerConfig;
    }

    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.testImmutability("syncCommitPhase");
        this.syncCommitPhase = syncCommitPhase;
    }

    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.testImmutability("syncRollbackPhase");
        this.syncRollbackPhase = syncRollbackPhase;
    }

    public void setUseReplQueue(boolean useReplQueue) {
        this.testImmutability("useReplQueue");
        this.useReplQueue = useReplQueue;
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.testImmutability("isolationLevel");
        this.isolationLevel = isolationLevel;
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.testImmutability("stateRetrievalTimeout");
        this.stateRetrievalTimeout = stateRetrievalTimeout;
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout, TimeUnit timeUnit) {
        this.setStateRetrievalTimeout(timeUnit.toMillis(stateRetrievalTimeout));
    }

    public void setIsolationLevel(String isolationLevel) {
        this.testImmutability("isolationLevel");
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.isolationLevel = IsolationLevel.valueOf(this.uc(isolationLevel));
        if (this.isolationLevel == null) {
            this.log.warn("Unknown isolation level '" + isolationLevel + "', using defaults.");
            this.isolationLevel = IsolationLevel.REPEATABLE_READ;
        }
    }

    public void setUseLazyDeserialization(boolean useLazyDeserialization) {
        this.testImmutability("useLazyDeserialization");
        this.useLazyDeserialization = useLazyDeserialization;
    }

    public void setUseAsyncSerialization(boolean useAsyncSerialization) {
        this.testImmutability("useAsyncSerialization");
        this.useAsyncSerialization = useAsyncSerialization;
    }

    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.testImmutability("l1CacheEnabled");
        this.l1CacheEnabled = l1CacheEnabled;
    }

    public void setL1Lifespan(long l1Lifespan) {
        this.testImmutability("l1Lifespan");
        this.l1Lifespan = l1Lifespan;
    }

    public void setL1OnRehash(boolean l1OnRehash) {
        this.testImmutability("l1OnRehash");
        this.l1OnRehash = l1OnRehash;
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.testImmutability("consistentHashClass");
        this.consistentHashClass = consistentHashClass;
    }

    public void setNumOwners(int numOwners) {
        this.testImmutability("numOwners");
        this.numOwners = numOwners;
    }

    public void setRehashWaitTime(long rehashWaitTime) {
        this.testImmutability("rehashWaitTime");
        this.rehashWaitTime = rehashWaitTime;
    }

    public boolean isUseReplQueue() {
        return this.useReplQueue;
    }

    public int getReplQueueMaxElements() {
        return this.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.replQueueInterval;
    }

    public boolean isExposeJmxStatistics() {
        return this.exposeJmxStatistics;
    }

    public boolean isInvocationBatchingEnabled() {
        return this.invocationBatchingEnabled;
    }

    public boolean isFetchInMemoryState() {
        return this.fetchInMemoryState;
    }

    public long getLockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.syncReplTimeout;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public String getTransactionManagerLookupClass() {
        return this.transactionManagerLookupClass;
    }

    public CacheLoaderManagerConfig getCacheLoaderManagerConfig() {
        return this.cacheLoaderManagerConfig;
    }

    public boolean isSyncCommitPhase() {
        return this.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.syncRollbackPhase;
    }

    public long getStateRetrievalTimeout() {
        return this.stateRetrievalTimeout;
    }

    public boolean isUseLazyDeserialization() {
        return this.useLazyDeserialization;
    }

    public boolean isL1CacheEnabled() {
        return this.l1CacheEnabled;
    }

    public long getL1Lifespan() {
        return this.l1Lifespan;
    }

    public boolean isL1OnRehash() {
        return this.l1OnRehash;
    }

    public String getConsistentHashClass() {
        return this.consistentHashClass;
    }

    public int getNumOwners() {
        return this.numOwners;
    }

    public long getRehashWaitTime() {
        return this.rehashWaitTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.concurrencyLevel != that.concurrencyLevel) {
            return false;
        }
        if (this.evictionMaxEntries != that.evictionMaxEntries) {
            return false;
        }
        if (this.evictionWakeUpInterval != that.evictionWakeUpInterval) {
            return false;
        }
        if (this.expirationLifespan != that.expirationLifespan) {
            return false;
        }
        if (this.expirationMaxIdle != that.expirationMaxIdle) {
            return false;
        }
        if (this.exposeJmxStatistics != that.exposeJmxStatistics) {
            return false;
        }
        if (this.fetchInMemoryState != that.fetchInMemoryState) {
            return false;
        }
        if (this.invocationBatchingEnabled != that.invocationBatchingEnabled) {
            return false;
        }
        if (this.l1CacheEnabled != that.l1CacheEnabled) {
            return false;
        }
        if (this.l1Lifespan != that.l1Lifespan) {
            return false;
        }
        if (this.rehashWaitTime != that.rehashWaitTime) {
            return false;
        }
        if (this.l1OnRehash != that.l1OnRehash) {
            return false;
        }
        if (this.lockAcquisitionTimeout != that.lockAcquisitionTimeout) {
            return false;
        }
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.replQueueInterval != that.replQueueInterval) {
            return false;
        }
        if (this.replQueueMaxElements != that.replQueueMaxElements) {
            return false;
        }
        if (this.stateRetrievalTimeout != that.stateRetrievalTimeout) {
            return false;
        }
        if (this.syncCommitPhase != that.syncCommitPhase) {
            return false;
        }
        if (this.syncReplTimeout != that.syncReplTimeout) {
            return false;
        }
        if (this.syncRollbackPhase != that.syncRollbackPhase) {
            return false;
        }
        if (this.useAsyncSerialization != that.useAsyncSerialization) {
            return false;
        }
        if (this.useLazyDeserialization != that.useLazyDeserialization) {
            return false;
        }
        if (this.useLockStriping != that.useLockStriping) {
            return false;
        }
        if (this.useReplQueue != that.useReplQueue) {
            return false;
        }
        if (this.writeSkewCheck != that.writeSkewCheck) {
            return false;
        }
        if (this.cacheLoaderManagerConfig != null ? !this.cacheLoaderManagerConfig.equals(that.cacheLoaderManagerConfig) : that.cacheLoaderManagerConfig != null) {
            return false;
        }
        if (this.cacheMode != that.cacheMode) {
            return false;
        }
        if (this.consistentHashClass != null ? !this.consistentHashClass.equals(that.consistentHashClass) : that.consistentHashClass != null) {
            return false;
        }
        if (this.customInterceptors != null ? !((Object)this.customInterceptors).equals(that.customInterceptors) : that.customInterceptors != null) {
            return false;
        }
        if (this.evictionStrategy != that.evictionStrategy) {
            return false;
        }
        if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) {
            return false;
        }
        if (this.isolationLevel != that.isolationLevel) {
            return false;
        }
        return !(this.transactionManagerLookupClass != null ? !this.transactionManagerLookupClass.equals(that.transactionManagerLookupClass) : that.transactionManagerLookupClass != null);
    }

    public int hashCode() {
        int result = this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0;
        result = 31 * result + (this.useLockStriping ? 1 : 0);
        result = 31 * result + (this.useReplQueue ? 1 : 0);
        result = 31 * result + this.replQueueMaxElements;
        result = 31 * result + (int)(this.replQueueInterval ^ this.replQueueInterval >>> 32);
        result = 31 * result + (this.exposeJmxStatistics ? 1 : 0);
        result = 31 * result + (this.fetchInMemoryState ? 1 : 0);
        result = 31 * result + (int)(this.lockAcquisitionTimeout ^ this.lockAcquisitionTimeout >>> 32);
        result = 31 * result + (int)(this.syncReplTimeout ^ this.syncReplTimeout >>> 32);
        result = 31 * result + (this.cacheMode != null ? this.cacheMode.hashCode() : 0);
        result = 31 * result + (int)(this.stateRetrievalTimeout ^ this.stateRetrievalTimeout >>> 32);
        result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 31 * result + (this.transactionManagerLookupClass != null ? this.transactionManagerLookupClass.hashCode() : 0);
        result = 31 * result + (this.cacheLoaderManagerConfig != null ? this.cacheLoaderManagerConfig.hashCode() : 0);
        result = 31 * result + (this.syncCommitPhase ? 1 : 0);
        result = 31 * result + (this.syncRollbackPhase ? 1 : 0);
        result = 31 * result + (this.useLazyDeserialization ? 1 : 0);
        result = 31 * result + (this.customInterceptors != null ? ((Object)this.customInterceptors).hashCode() : 0);
        result = 31 * result + (this.writeSkewCheck ? 1 : 0);
        result = 31 * result + this.concurrencyLevel;
        result = 31 * result + (this.invocationBatchingEnabled ? 1 : 0);
        result = 31 * result + (this.useAsyncSerialization ? 1 : 0);
        result = 31 * result + (int)(this.evictionWakeUpInterval ^ this.evictionWakeUpInterval >>> 32);
        result = 31 * result + (this.evictionStrategy != null ? this.evictionStrategy.hashCode() : 0);
        result = 31 * result + this.evictionMaxEntries;
        result = 31 * result + (int)(this.expirationLifespan ^ this.expirationLifespan >>> 32);
        result = 31 * result + (int)(this.expirationMaxIdle ^ this.expirationMaxIdle >>> 32);
        result = 31 * result + (this.l1CacheEnabled ? 1 : 0);
        result = 31 * result + (int)(this.l1Lifespan ^ this.l1Lifespan >>> 32);
        result = 31 * result + (int)(this.rehashWaitTime ^ this.rehashWaitTime >>> 32);
        result = 31 * result + (this.l1OnRehash ? 1 : 0);
        result = 31 * result + (this.consistentHashClass != null ? this.consistentHashClass.hashCode() : 0);
        result = 31 * result + this.numOwners;
        return result;
    }

    @Override
    public Configuration clone() {
        try {
            Configuration c = (Configuration)super.clone();
            if (this.cacheLoaderManagerConfig != null) {
                c.setCacheLoaderManagerConfig(this.cacheLoaderManagerConfig.clone());
            }
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUsingCacheLoaders() {
        return this.getCacheLoaderManagerConfig() != null && !this.getCacheLoaderManagerConfig().getCacheLoaderConfigs().isEmpty();
    }

    public List<CustomInterceptorConfig> getCustomInterceptors() {
        return this.customInterceptors == null ? Collections.EMPTY_LIST : this.customInterceptors;
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.testImmutability("customInterceptors");
        this.customInterceptors = customInterceptors;
    }

    public void applyOverrides(Configuration overrides) {
        for (String overriddenField : overrides.overriddenConfigurationElements) {
            ReflectionUtil.setValue(this, overriddenField, ReflectionUtil.getValue(overrides, overriddenField));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC,
        DIST_SYNC,
        DIST_ASYNC;


        public boolean isInvalidation() {
            return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
        }

        public boolean isSynchronous() {
            return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
        }

        public boolean isClustered() {
            return this != LOCAL;
        }

        public boolean isDistributed() {
            return this == DIST_SYNC || this == DIST_ASYNC;
        }

        public CacheMode toSync() {
            switch (this) {
                case REPL_ASYNC: {
                    return REPL_SYNC;
                }
                case INVALIDATION_ASYNC: {
                    return INVALIDATION_SYNC;
                }
                case DIST_ASYNC: {
                    return DIST_SYNC;
                }
            }
            return this;
        }

        public CacheMode toAsync() {
            switch (this) {
                case REPL_SYNC: {
                    return REPL_ASYNC;
                }
                case INVALIDATION_SYNC: {
                    return INVALIDATION_ASYNC;
                }
                case DIST_SYNC: {
                    return DIST_ASYNC;
                }
            }
            return this;
        }
    }
}

