/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFODataContainer
implements DataContainer {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    Set<Object> keySet;
    final LinkedEntry head = new LinkedEntry();
    final LinkedEntry tail = new LinkedEntry();

    public FIFODataContainer() {
        int cap;
        int c;
        int ssize;
        float loadFactor = 0.75f;
        int initialCapacity = 16;
        int concurrencyLevel = 16;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
        this.initLinks();
    }

    protected final void initLinks() {
        this.head.n = this.tail;
        this.head.p = this.tail;
        this.tail.n = this.head;
        this.tail.p = this.head;
    }

    protected final void unlink(LinkedEntry le) {
        le.p.casNext(le, le.n);
        le.n.casPrev(le, le.p);
    }

    protected final void linkAtEnd(LinkedEntry le) {
        le.n = this.tail;
        do {
            le.p = this.tail.p;
        } while (!le.p.casNext(this.tail, le));
        this.tail.p = le;
    }

    final int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public InternalCacheEntry get(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (le.isMarked()) {
                this.unlink(le);
            }
        }
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        s.lock();
        boolean newEntry = false;
        try {
            InternalCacheEntry ice;
            LinkedEntry le = s.get(k, h);
            InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.e;
            if (ice == null) {
                newEntry = true;
                ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                le = new LinkedEntry();
            } else {
                ice.setValue(v);
                ice = ice.setLifespan(lifespan).setMaxIdle(maxIdle);
            }
            le.e = ice;
            s.locklessPut(k, h, le);
            if (newEntry) {
                this.linkAtEnd(le);
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            s.unlock();
            throw throwable;
        }
        s.unlock();
    }

    @Override
    public boolean containsKey(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry ice = null;
        if (le != null) {
            ice = le.e;
            if (le.isMarked()) {
                this.unlink(le);
            }
        }
        if (ice != null && ice.isExpired()) {
            this.remove(k);
            ice = null;
        }
        return ice != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry remove(Object k) {
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        s.lock();
        InternalCacheEntry ice = null;
        try {
            LinkedEntry le = s.locklessRemove(k, h);
            if (le != null) {
                ice = le.e;
                le.mark();
                this.unlink(le);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            s.unlock();
            throw throwable;
        }
        s.unlock();
        if (ice == null || ice.isExpired()) {
            return null;
        }
        return ice;
    }

    @Override
    public int size() {
        Segment[] segs;
        int sz = 0;
        for (Segment s : segs = this.segments) {
            sz += s.count;
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (Segment s : this.segments) {
            s.lock();
        }
        try {
            for (Segment s : this.segments) {
                s.locklessClear();
            }
            this.initLinks();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            for (Segment s : this.segments) {
                s.unlock();
            }
            throw throwable;
        }
        for (Segment s : this.segments) {
            s.unlock();
        }
    }

    @Override
    public Set<Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public void purgeExpired() {
        for (InternalCacheEntry ice : this) {
            if (!ice.isExpired()) continue;
            this.remove(ice.getKey());
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeyIterator
    extends LinkedIterator
    implements Iterator<Object> {
        protected KeyIterator() {
        }

        @Override
        public Object next() {
            while (this.current.isMarked()) {
                LinkedEntry n = this.current.n;
                FIFODataContainer.this.unlink(this.current);
                this.current = n;
                if (n != FIFODataContainer.this.head && n != FIFODataContainer.this.tail) continue;
                throw new IndexOutOfBoundsException("Reached head or tail pointer!");
            }
            return this.current.e.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValueIterator
    extends LinkedIterator
    implements Iterator<InternalCacheEntry> {
        protected ValueIterator() {
        }

        @Override
        public InternalCacheEntry next() {
            while (this.current.isMarked()) {
                LinkedEntry n = this.current.n;
                FIFODataContainer.this.unlink(this.current);
                this.current = n;
                if (n != FIFODataContainer.this.head && n != FIFODataContainer.this.tail) continue;
                throw new IndexOutOfBoundsException("Reached head or tail pointer!");
            }
            return this.current.e;
        }
    }

    protected abstract class LinkedIterator {
        LinkedEntry current;

        protected LinkedIterator() {
            this.current = FIFODataContainer.this.head;
        }

        public boolean hasNext() {
            this.current = this.current.n;
            while (this.current.isMarked()) {
                if (this.current == FIFODataContainer.this.tail || this.current == FIFODataContainer.this.head) {
                    return false;
                }
                this.current = this.current.n;
            }
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeySet
    extends AbstractSet<Object> {
        protected KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return FIFODataContainer.this.size();
        }
    }

    static final class Segment
    extends ReentrantLock {
        volatile transient int count;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        final void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        final HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final LinkedEntry readValueUnderLock(HashEntry e) {
            LinkedEntry linkedEntry;
            this.lock();
            try {
                linkedEntry = e.value;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return linkedEntry;
        }

        final LinkedEntry get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        LinkedEntry v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        final LinkedEntry locklessPut(Object key, int hash, LinkedEntry value) {
            LinkedEntry oldValue;
            HashEntry first;
            int c = this.count;
            if (c++ > this.threshold) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                e.value = value;
            } else {
                oldValue = null;
                tab[index] = new HashEntry(key, hash, first, value);
                this.count = c;
            }
            return oldValue;
        }

        final void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        final LinkedEntry locklessRemove(Object key, int hash) {
            HashEntry first;
            int c = this.count - 1;
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            LinkedEntry oldValue = null;
            if (e != null) {
                oldValue = e.value;
                HashEntry newFirst = e.next;
                HashEntry p = first;
                while (p != e) {
                    newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                    p = p.next;
                }
                tab[index] = newFirst;
                this.count = c;
            }
            return oldValue;
        }

        final void locklessClear() {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                this.count = 0;
            }
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile LinkedEntry value;
        final HashEntry next;

        HashEntry(Object key, int hash, HashEntry next, LinkedEntry value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }

    static final class LinkedEntry {
        volatile InternalCacheEntry e;
        volatile LinkedEntry n;
        volatile LinkedEntry p;
        private static final AtomicReferenceFieldUpdater<LinkedEntry, InternalCacheEntry> E_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LinkedEntry.class, InternalCacheEntry.class, "e");
        private static final AtomicReferenceFieldUpdater<LinkedEntry, LinkedEntry> N_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LinkedEntry.class, LinkedEntry.class, "n");
        private static final AtomicReferenceFieldUpdater<LinkedEntry, LinkedEntry> P_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LinkedEntry.class, LinkedEntry.class, "p");

        LinkedEntry() {
        }

        final boolean casValue(InternalCacheEntry expected, InternalCacheEntry newValue) {
            return E_UPDATER.compareAndSet(this, expected, newValue);
        }

        final boolean casNext(LinkedEntry expected, LinkedEntry newValue) {
            return N_UPDATER.compareAndSet(this, expected, newValue);
        }

        final boolean casPrev(LinkedEntry expected, LinkedEntry newValue) {
            return P_UPDATER.compareAndSet(this, expected, newValue);
        }

        final void mark() {
            this.e = null;
        }

        final boolean isMarked() {
            return this.e == null;
        }
    }
}

