/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SpinLockBasedFIFODataContainer
implements DataContainer {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    final LinkedEntry dummyEntry = new LinkedEntry();
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    Set<Object> keySet;

    public SpinLockBasedFIFODataContainer() {
        int cap;
        int c;
        int ssize;
        float loadFactor = 0.75f;
        int initialCapacity = 16;
        int concurrencyLevel = 16;
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
        this.initLinks();
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry ice;
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.entry;
        if (ice != null) {
            if (ice.isExpired()) {
                this.remove(k);
                ice = null;
            } else {
                ice.touch();
            }
        }
        return ice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        Segment s;
        block6: {
            int h = this.hash(k.hashCode());
            s = this.segmentFor(h);
            s.lock();
            LinkedEntry le = null;
            SpinLock before = null;
            SpinLock after = null;
            boolean newEntry = false;
            try {
                InternalCacheEntry ice;
                le = s.get(k, h);
                InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.entry;
                if (ice == null) {
                    newEntry = true;
                    ice = InternalEntryFactory.create(k, v, lifespan, maxIdle);
                    le = new LinkedEntry();
                    le.lock();
                    after = new Aux();
                    after.lock();
                    le.next = after;
                    ((Aux)after).next = this.dummyEntry;
                } else {
                    ice.setValue(v);
                    ice = ice.setLifespan(lifespan).setMaxIdle(maxIdle);
                }
                le.entry = ice;
                s.locklessPut(k, h, le);
                if (newEntry) {
                    this.dummyEntry.lock();
                    before = this.dummyEntry.prev;
                    before.lock();
                    ((Aux)before).next = le;
                    le.prev = before;
                    this.dummyEntry.prev = after;
                }
                Object var15_12 = null;
                if (!newEntry || le == null) break block6;
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                if (newEntry && le != null) {
                    before.unlock();
                    this.dummyEntry.unlock();
                    after.unlock();
                    le.unlock();
                }
                s.unlock();
                throw throwable;
            }
            before.unlock();
            this.dummyEntry.unlock();
            after.unlock();
            le.unlock();
        }
        s.unlock();
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice;
        int h = this.hash(k.hashCode());
        Segment s = this.segmentFor(h);
        LinkedEntry le = s.get(k, h);
        InternalCacheEntry internalCacheEntry = ice = le == null ? null : le.entry;
        if (ice != null && ice.isExpired()) {
            this.remove(k);
            ice = null;
        }
        return ice != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry ice;
        Segment s;
        block5: {
            int h = this.hash(k.hashCode());
            s = this.segmentFor(h);
            s.lock();
            ice = null;
            LinkedEntry le = null;
            boolean linksLocked = false;
            LinkedEntry nextEntry = null;
            SpinLock before = null;
            SpinLock after = null;
            try {
                le = s.locklessRemove(k, h);
                if (le != null) {
                    ice = le.entry;
                    linksLocked = true;
                    le.lock();
                    before = le.prev;
                    before.lock();
                    after = le.next;
                    after.lock();
                    nextEntry = ((Aux)after).next;
                    ((Aux)before).next = ((Aux)after).next;
                    ((Aux)before).next.prev = before;
                }
                Object var11_10 = null;
                if (!linksLocked) break block5;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (linksLocked) {
                    before.unlock();
                    after.unlock();
                    le.unlock();
                }
                s.unlock();
                throw throwable;
            }
            before.unlock();
            after.unlock();
            le.unlock();
        }
        s.unlock();
        if (ice != null && !ice.isExpired()) {
            return ice;
        }
        return null;
    }

    @Override
    public int size() {
        Segment[] segs;
        int sz = 0;
        for (Segment s : segs = this.segments) {
            sz += s.count;
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (Segment s : this.segments) {
            s.lock();
        }
        try {
            for (Segment s : this.segments) {
                s.locklessClear();
            }
            this.initLinks();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            for (Segment s : this.segments) {
                s.unlock();
            }
            throw throwable;
        }
        for (Segment s : this.segments) {
            s.unlock();
        }
    }

    @Override
    public Set<Object> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public void purgeExpired() {
        for (InternalCacheEntry ice : this) {
            if (!ice.isExpired()) continue;
            this.remove(ice.getKey());
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initLinks() {
        Aux tail = new Aux();
        try {
            tail.lock();
            this.dummyEntry.prev = tail;
            this.dummyEntry.next = tail;
            tail.next = this.dummyEntry;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            tail.unlock();
            this.dummyEntry.unlock();
            throw throwable;
        }
        tail.unlock();
        this.dummyEntry.unlock();
    }

    final int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    protected static final class LinkedEntry
    extends SpinLock {
        volatile Aux prev;
        volatile Aux next;
        volatile InternalCacheEntry entry;

        protected LinkedEntry() {
        }
    }

    protected static final class Aux
    extends SpinLock {
        volatile LinkedEntry next;

        protected Aux() {
        }
    }

    protected static abstract class SpinLock {
        final AtomicBoolean l = new AtomicBoolean(false);

        protected SpinLock() {
        }

        final void lock() {
            while (!this.l.compareAndSet(false, true)) {
            }
        }

        final boolean tryLock() {
            return this.l.compareAndSet(false, true);
        }

        final void unlock() {
            this.l.set(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeyIterator
    extends LinkedIterator
    implements Iterator<Object> {
        protected KeyIterator() {
        }

        @Override
        public Object next() {
            LinkedEntry le = this.nextAux.next;
            if (le == SpinLockBasedFIFODataContainer.this.dummyEntry) {
                return null;
            }
            this.nextAux = le.next;
            return le.entry.getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ValueIterator
    extends LinkedIterator
    implements Iterator<InternalCacheEntry> {
        protected ValueIterator() {
        }

        @Override
        public InternalCacheEntry next() {
            LinkedEntry le = this.nextAux.next;
            if (le == SpinLockBasedFIFODataContainer.this.dummyEntry) {
                return null;
            }
            this.nextAux = le.next;
            return le.entry;
        }
    }

    protected abstract class LinkedIterator {
        Aux nextAux;

        protected LinkedIterator() {
            this.nextAux = SpinLockBasedFIFODataContainer.this.dummyEntry.next;
        }

        public boolean hasNext() {
            return this.nextAux.next != SpinLockBasedFIFODataContainer.this.dummyEntry;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class KeySet
    extends AbstractSet<Object> {
        protected KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SpinLockBasedFIFODataContainer.this.size();
        }
    }

    static final class Segment
    extends ReentrantLock {
        volatile transient int count;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        static final Segment[] newArray(int i) {
            return new Segment[i];
        }

        final void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        final HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final LinkedEntry readValueUnderLock(HashEntry e) {
            LinkedEntry linkedEntry;
            this.lock();
            try {
                linkedEntry = e.value;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
            this.unlock();
            return linkedEntry;
        }

        final LinkedEntry get(Object key, int hash) {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        LinkedEntry v = e.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e);
                    }
                    e = e.next;
                }
            }
            return null;
        }

        final LinkedEntry locklessPut(Object key, int hash, LinkedEntry value) {
            LinkedEntry oldValue;
            HashEntry first;
            int c = this.count;
            if (c++ > this.threshold) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                oldValue = e.value;
                e.value = value;
            } else {
                oldValue = null;
                tab[index] = new HashEntry(key, hash, first, value);
                this.count = c;
            }
            return oldValue;
        }

        final void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (int i = 0; i < oldCapacity; ++i) {
                int k;
                HashEntry e = oldTable[i];
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        final LinkedEntry locklessRemove(Object key, int hash) {
            HashEntry first;
            int c = this.count - 1;
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            LinkedEntry oldValue = null;
            if (e != null) {
                oldValue = e.value;
                HashEntry newFirst = e.next;
                HashEntry p = first;
                while (p != e) {
                    newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                    p = p.next;
                }
                tab[index] = newFirst;
                this.count = c;
            }
            return oldValue;
        }

        final void locklessClear() {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    tab[i] = null;
                }
                this.count = 0;
            }
        }
    }

    static final class HashEntry {
        final Object key;
        final int hash;
        volatile LinkedEntry value;
        final HashEntry next;

        HashEntry(Object key, int hash, HashEntry next, LinkedEntry value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }
}

