/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.AbstractInternalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;

public class MortalCacheEntry
extends AbstractInternalCacheEntry {
    long created;
    long lifespan = -1L;

    MortalCacheEntry() {
        this.created = System.currentTimeMillis();
    }

    MortalCacheEntry(Object key, Object value, long lifespan) {
        super(key, value);
        this.created = System.currentTimeMillis();
        this.lifespan = lifespan;
    }

    MortalCacheEntry(Object key, Object value, long lifespan, long created) {
        super(key, value);
        this.created = created;
        this.lifespan = lifespan;
    }

    public final boolean isExpired() {
        return this.lifespan > -1L && System.currentTimeMillis() > this.created + this.lifespan;
    }

    public final boolean canExpire() {
        return true;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            TransientMortalCacheEntry tmce = new TransientMortalCacheEntry(this.key, this.value);
            tmce.setMaxIdle(maxIdle);
            return tmce;
        }
        return this;
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan < 0L) {
            return new ImmortalCacheEntry(this.key, this.value);
        }
        this.lifespan = lifespan;
        return this;
    }

    public final long getCreated() {
        return this.created;
    }

    public final long getLastUsed() {
        return -1L;
    }

    public final long getLifespan() {
        return this.lifespan;
    }

    public final long getMaxIdle() {
        return -1L;
    }

    public final long getExpiryTime() {
        return this.lifespan > -1L ? this.created + this.lifespan : -1L;
    }

    public final void touch() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MortalCacheEntry that = (MortalCacheEntry)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }
}

