/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;

public class TransientMortalCacheEntry
extends TransientCacheEntry {
    private long created;
    private long lifespan = -1L;

    TransientMortalCacheEntry() {
        this.created = System.currentTimeMillis();
    }

    TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan) {
        super(key, value, maxIdle);
        this.created = System.currentTimeMillis();
        this.lifespan = lifespan;
    }

    TransientMortalCacheEntry(Object key, Object value) {
        super(key, value, -1L);
        this.created = System.currentTimeMillis();
    }

    public TransientMortalCacheEntry(Object key, Object value, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key, value, maxIdle, lastUsed);
        this.created = created;
        this.lifespan = lifespan;
    }

    public InternalCacheEntry setLifespan(long lifespan) {
        if (lifespan < 0L) {
            TransientCacheEntry tce = new TransientCacheEntry();
            tce.key = this.key;
            tce.value = this.value;
            tce.lastUsed = this.lastUsed;
            tce.maxIdle = this.maxIdle;
            return tce;
        }
        this.lifespan = lifespan;
        return this;
    }

    public InternalCacheEntry setMaxIdle(long maxIdle) {
        if (maxIdle < 0L) {
            MortalCacheEntry mce = new MortalCacheEntry();
            mce.key = this.key;
            mce.value = this.value;
            mce.created = this.created;
            mce.lifespan = this.lifespan;
            return mce;
        }
        this.maxIdle = maxIdle;
        return this;
    }

    public long getLifespan() {
        return this.lifespan;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean isExpired() {
        return super.isExpired() || this.lifespan > -1L && System.currentTimeMillis() > this.created + this.lifespan;
    }

    public final long getExpiryTime() {
        return this.lifespan > -1L ? this.created + this.lifespan : -1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheEntry that = (TransientMortalCacheEntry)o;
        if (this.created != that.created) {
            return false;
        }
        return this.lifespan == that.lifespan;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.created ^ this.created >>> 32);
        result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
        return result;
    }
}

