/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.invocation.Flag;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext {
    protected volatile EnumSet<Flag> flags;
    protected byte contextFlags;
    protected BidirectionalLinkedHashMap<Object, CacheEntry> lookedUpEntries = null;

    protected final boolean isContextFlagSet(ContextFlags flag) {
        return (this.contextFlags & flag.mask) != 0;
    }

    protected final void setContextFlag(ContextFlags flag) {
        this.contextFlags = (byte)(this.contextFlags | flag.mask);
    }

    protected final void unsetContextFlag(ContextFlags flag) {
        this.contextFlags = (byte)(this.contextFlags & ~flag.mask);
    }

    protected final void setContextFlag(ContextFlags flag, boolean value) {
        if (value) {
            this.setContextFlag(flag);
        } else {
            this.unsetContextFlag(flag);
        }
    }

    public boolean hasFlag(Flag o) {
        return this.flags != null && this.flags.contains((Object)o);
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public void setFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return;
        }
        if (this.flags == null) {
            this.flags = EnumSet.copyOf(Arrays.asList(flags));
        } else {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    public void setFlags(Collection<Flag> flags) {
        if (flags == null || flags.size() == 0) {
            return;
        }
        if (this.flags == null) {
            this.flags = EnumSet.copyOf(flags);
        } else {
            this.flags.addAll(flags);
        }
    }

    public void resetFlags() {
        this.flags = null;
    }

    public boolean isFlagsUninitialized() {
        return this.flags == null;
    }

    protected abstract int getLockSetSize();

    public boolean hasLockedKey(Object key) {
        CacheEntry e = this.lookupEntry(key);
        return e != null && e.isChanged();
    }

    public CacheEntry lookupEntry(Object key) {
        return this.lookedUpEntries.get(key);
    }

    public void removeLookedUpEntry(Object key) {
        this.lookedUpEntries.remove(key);
    }

    public void putLookedUpEntry(Object key, CacheEntry entry) {
        this.lookedUpEntries.put(key, entry);
    }

    public void clearLookedUpEntries() {
        this.lookedUpEntries.clear();
    }

    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        lookedUpEntries.putAll(lookedUpEntries);
    }

    public void reset() {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.clear();
        }
        this.flags = null;
        this.contextFlags = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractContext)) {
            return false;
        }
        AbstractContext that = (AbstractContext)o;
        if (this.contextFlags != that.contextFlags) {
            return false;
        }
        if (this.lookedUpEntries != null ? !this.lookedUpEntries.equals(that.lookedUpEntries) : that.lookedUpEntries != null) {
            return false;
        }
        return !(this.flags != null ? !this.flags.equals(that.flags) : that.flags != null);
    }

    public int hashCode() {
        int result = this.flags != null ? this.flags.hashCode() : 0;
        result = 31 * result + this.contextFlags;
        result = 31 * result + (this.lookedUpEntries != null ? this.lookedUpEntries.hashCode() : 0);
        return result;
    }

    protected void copyInto(AbstractContext ctx) {
        if (this.flags != null) {
            ctx.flags = EnumSet.copyOf(this.flags);
        }
        ctx.contextFlags = this.contextFlags;
        if (this.lookedUpEntries != null) {
            ctx.lookedUpEntries = this.lookedUpEntries.clone();
        }
    }

    public boolean isContainsModifications() {
        return this.isContextFlagSet(ContextFlags.CONTAINS_MODS);
    }

    public void setContainsModifications(boolean b) {
        this.setContextFlag(ContextFlags.CONTAINS_MODS, b);
    }

    public boolean isContainsLocks() {
        return this.isContextFlagSet(ContextFlags.CONTAINS_LOCKS);
    }

    public void setContainsLocks(boolean b) {
        this.setContextFlag(ContextFlags.CONTAINS_LOCKS, b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ContextFlags {
        FORCE_SYNCHRONOUS(1),
        FORCE_ASYNCHRONOUS(2),
        ORIGIN_LOCAL(4),
        LOCAL_ROLLBACK_ONLY(8),
        CONTAINS_MODS(16),
        CONTAINS_LOCKS(32);

        final byte mask;

        private ContextFlags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

