/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionManagerImpl
implements DistributionManager {
    private final Log log = LogFactory.getLog(DistributionManagerImpl.class);
    private final boolean trace = this.log.isTraceEnabled();
    Configuration configuration;
    ConsistentHash consistentHash;
    RpcManager rpcManager;
    CacheManagerNotifier notifier;
    int replCount;
    ViewChangeListener listener;

    @Inject
    public void init(Configuration configuration, RpcManager rpcManager, CacheManagerNotifier notifier) {
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.notifier = notifier;
    }

    @Start(priority=20)
    public void start() throws Exception {
        this.replCount = this.configuration.getNumOwners();
        this.consistentHash = (ConsistentHash)Util.getInstance(this.configuration.getConsistentHashClass());
        this.consistentHash.setCaches(this.rpcManager.getTransport().getMembers());
        this.listener = new ViewChangeListener();
        this.notifier.addListener(this.listener);
    }

    @Stop(priority=20)
    public void stop() {
        this.notifier.removeListener(this.listener);
    }

    @Override
    public void rehash(Collection<Address> newList) {
        this.consistentHash.setCaches(newList);
    }

    @Override
    public boolean isLocal(Object key) {
        return this.consistentHash.locate(key, this.replCount).contains(this.rpcManager.getLocalAddress());
    }

    @Override
    public List<Address> locate(Object key) {
        List<Address> adds = this.consistentHash.locate(key, this.replCount);
        if (this.trace) {
            this.log.trace((Object)"Located {0} addresses for key {1}.  Repl count is {2}, addresses are {3}", adds.size(), key, this.replCount, adds);
        }
        return adds;
    }

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys) {
        return this.consistentHash.locateAll(keys, this.replCount);
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void handleViewChange(ViewChangedEvent e) {
            DistributionManagerImpl.this.rehash(e.getNewMemberList());
        }
    }
}

