/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.NullMarkerEntry;
import org.infinispan.container.entries.NullMarkerEntryForRemoval;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.EntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.invocation.Flag;
import org.infinispan.lock.IsolationLevel;
import org.infinispan.lock.LockManager;
import org.infinispan.lock.TimeoutException;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class EntryFactoryImpl
implements EntryFactory {
    private boolean useRepeatableRead;
    DataContainer container;
    boolean writeSkewCheck;
    LockManager lockManager;
    Configuration configuration;
    CacheNotifier notifier;
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void injectDependencies(DataContainer dataContainer, LockManager lockManager, Configuration configuration, CacheNotifier notifier) {
        this.container = dataContainer;
        this.configuration = configuration;
        this.lockManager = lockManager;
        this.notifier = notifier;
    }

    @Start
    public void init() {
        this.useRepeatableRead = this.configuration.getIsolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.writeSkewCheck = this.configuration.isWriteSkewCheck();
    }

    private MVCCEntry createWrappedEntry(Object key, Object value, boolean isForInsert, boolean forRemoval, long lifespan) {
        if (value == null && !isForInsert) {
            return this.useRepeatableRead ? (forRemoval ? new NullMarkerEntryForRemoval(key) : NullMarkerEntry.getInstance()) : null;
        }
        return this.useRepeatableRead ? new RepeatableReadEntry(key, value, lifespan) : new ReadCommittedEntry(key, value, lifespan);
    }

    public final CacheEntry wrapEntryForReading(InvocationContext ctx, Object key) throws InterruptedException {
        if (ctx.hasFlag(Flag.FORCE_WRITE_LOCK)) {
            if (trace) {
                log.trace("Forcing lock on reading");
            }
            return this.wrapEntryForWriting(ctx, key, false, false, false, false);
        }
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (cacheEntry == null) {
            MVCCEntry mvccEntry;
            if (trace) {
                log.trace((Object)"Key {0} is not in context, fetching from container.", key);
            }
            cacheEntry = this.container.get(key);
            if (ctx.getTransaction() == null) {
                if (cacheEntry != null) {
                    ctx.putLookedUpEntry(key, cacheEntry);
                }
                return cacheEntry;
            }
            MVCCEntry mVCCEntry = mvccEntry = cacheEntry == null ? this.createWrappedEntry(key, null, false, false, -1L) : this.createWrappedEntry(key, cacheEntry.getValue(), false, false, cacheEntry.getLifespan());
            if (mvccEntry != null) {
                ctx.putLookedUpEntry(key, mvccEntry);
            }
            return mvccEntry;
        }
        if (trace) {
            log.trace("Key is already in context");
        }
        return cacheEntry;
    }

    public final MVCCEntry wrapEntryForWriting(InvocationContext ctx, Object key, boolean createIfAbsent, boolean forceLockIfAbsent, boolean alreadyLocked, boolean forRemoval) throws InterruptedException {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        MVCCEntry mvccEntry = null;
        if (createIfAbsent && cacheEntry != null && cacheEntry.isNull()) {
            cacheEntry = null;
        }
        if (cacheEntry != null) {
            if (trace) {
                log.trace("Exists in context.");
            }
            if (alreadyLocked || this.acquireLock(ctx, key)) {
                if (!(!(cacheEntry instanceof MVCCEntry) || forRemoval && cacheEntry instanceof NullMarkerEntry)) {
                    mvccEntry = (MVCCEntry)cacheEntry;
                } else {
                    mvccEntry = this.createWrappedEntry(key, cacheEntry.getValue(), false, forRemoval, cacheEntry.getLifespan());
                    cacheEntry = mvccEntry;
                    ctx.putLookedUpEntry(key, cacheEntry);
                }
                mvccEntry.copyForUpdate(this.container, this.writeSkewCheck);
            }
            if (cacheEntry.isRemoved() && createIfAbsent) {
                if (trace) {
                    log.trace("Entry is deleted in current scope.  Need to un-delete.");
                }
                if (mvccEntry != cacheEntry) {
                    mvccEntry = (MVCCEntry)cacheEntry;
                }
                mvccEntry.setRemoved(false);
                mvccEntry.setValid(true);
            }
            return mvccEntry;
        }
        cacheEntry = this.container.get(key);
        if (cacheEntry != null) {
            if (trace) {
                log.trace("Retrieved from container.");
            }
            boolean needToCopy = alreadyLocked || this.acquireLock(ctx, key) || ctx.hasFlag(Flag.SKIP_LOCKING);
            mvccEntry = this.createWrappedEntry(key, cacheEntry.getValue(), false, false, cacheEntry.getLifespan());
            ctx.putLookedUpEntry(key, mvccEntry);
            if (needToCopy) {
                mvccEntry.copyForUpdate(this.container, this.writeSkewCheck);
            }
            cacheEntry = mvccEntry;
        } else if (createIfAbsent) {
            if (trace) {
                log.trace("Creating new entry.");
            }
            if (!alreadyLocked) {
                this.acquireLock(ctx, key);
            }
            this.notifier.notifyCacheEntryCreated(key, true, ctx);
            mvccEntry = this.createWrappedEntry(key, null, true, false, -1L);
            mvccEntry.setCreated(true);
            ctx.putLookedUpEntry(key, mvccEntry);
            mvccEntry.copyForUpdate(this.container, this.writeSkewCheck);
            this.notifier.notifyCacheEntryCreated(key, false, ctx);
            cacheEntry = mvccEntry;
        }
        if (mvccEntry == null && forceLockIfAbsent && this.acquireLock(ctx, key)) {
            ctx.putLookedUpEntry(key, null);
        }
        return mvccEntry;
    }

    public final boolean acquireLock(InvocationContext ctx, Object key) throws InterruptedException, TimeoutException {
        boolean shouldSkipLocking = ctx.hasFlag(Flag.SKIP_LOCKING);
        if (!ctx.hasLockedKey(key) && !shouldSkipLocking) {
            if (this.lockManager.lockAndRecord(key, ctx)) {
                return true;
            }
            Object owner = this.lockManager.getOwner(key);
            throw new TimeoutException("Unable to acquire lock on key [" + key + "] after [" + this.getLockAcquisitionTimeout(ctx) + "] milliseconds for requestor [" + this.lockManager.getLockOwner(ctx) + "]! Lock held by [" + owner + "]");
        }
        return false;
    }

    private long getLockAcquisitionTimeout(InvocationContext ctx) {
        return ctx.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.configuration.getLockAcquisitionTimeout();
    }

    public final void releaseLock(Object key) {
        this.lockManager.unlock(key, this.lockManager.getOwner(key));
    }
}

