/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loader.CacheLoaderManager;
import org.infinispan.loader.CacheStore;
import org.infinispan.loader.modifications.Clear;
import org.infinispan.loader.modifications.Modification;
import org.infinispan.loader.modifications.Remove;
import org.infinispan.loader.modifications.Store;
import org.infinispan.logging.LogFactory;
import org.infinispan.transaction.GlobalTransaction;

public class CacheStoreInterceptor
extends JmxStatsCommandInterceptor {
    private CacheLoaderManagerConfig loaderConfig = null;
    private TransactionManager txMgr = null;
    private HashMap<Transaction, Integer> txStores = new HashMap();
    private Map<Transaction, Set<Object>> preparingTxs = new ConcurrentHashMap<Transaction, Set<Object>>();
    private final AtomicLong cacheStores = new AtomicLong(0L);
    CacheStore store;
    private CacheLoaderManager loaderManager;
    private boolean statsEnabled;

    public CacheStoreInterceptor() {
        this.log = LogFactory.getLog(this.getClass());
        this.trace = this.log.isTraceEnabled();
    }

    @Inject
    protected void init(CacheLoaderManager loaderManager, TransactionManager txManager) {
        this.loaderManager = loaderManager;
        this.txMgr = txManager;
    }

    @Start(priority=15)
    protected void start() {
        this.store = this.loaderManager.getCacheStore();
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
        this.loaderConfig = this.configuration.getCacheLoaderManagerConfig();
    }

    public final boolean skip(InvocationContext ctx, VisitableCommand command) {
        if (this.store == null) {
            return true;
        }
        if (!ctx.isOriginLocal() && this.loaderConfig.isShared() || ctx.hasFlag(Flag.SKIP_CACHE_STORE)) {
            if (this.trace) {
                this.log.trace("Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
            }
            return true;
        }
        return false;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.skip(ctx, command) && this.inTransaction()) {
            if (ctx.getTransactionContext().hasAnyModifications()) {
                Transaction tx = ctx.getTransaction();
                this.log.trace((Object)"Calling loader.commit() for transaction {0}", tx);
                try {
                    this.store.commit(tx);
                }
                catch (Throwable t) {
                    this.preparingTxs.remove(tx);
                    throw t;
                }
                if (this.getStatisticsEnabled()) {
                    Integer puts = this.txStores.get(tx);
                    if (puts != null) {
                        this.cacheStores.getAndAdd(puts.intValue());
                    }
                    this.txStores.remove(tx);
                }
                return this.invokeNextInterceptor(ctx, command);
            }
            if (this.trace) {
                this.log.trace("Commit called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.skip(ctx, command) && this.inTransaction()) {
            if (this.trace) {
                this.log.trace("transactional so don't put stuff in the cloader yet.");
            }
            if (ctx.getTransactionContext().hasAnyModifications()) {
                Transaction tx = ctx.getTransaction();
                if (this.preparingTxs.containsKey(tx)) {
                    this.preparingTxs.remove(tx);
                    this.store.rollback(tx);
                }
                if (this.getStatisticsEnabled()) {
                    this.txStores.remove(tx);
                }
            } else if (this.trace) {
                this.log.trace("Rollback called with no modifications; ignoring.");
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.skip(ctx, command) && this.inTransaction()) {
            if (this.trace) {
                this.log.trace("transactional so don't put stuff in the cloader yet.");
            }
            this.prepareCacheLoader(ctx, command.getGlobalTransaction(), ctx.getTransactionContext(), command.isOnePhaseCommit());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.skip(ctx, command) && !this.inTransaction() && command.isSuccessful()) {
            Object key = command.getKey();
            boolean resp = this.store.remove(key);
            this.log.trace((Object)"Removed entry under key {0} and got response {1} from CacheStore", key, resp);
        }
        return retval;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (!this.skip(ctx, command) && !this.inTransaction()) {
            this.store.clear();
            this.log.trace("Cleared cache store");
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx, command) || this.inTransaction() || !command.isSuccessful()) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx, command) || this.inTransaction() || !command.isSuccessful()) {
            return returnValue;
        }
        Object key = command.getKey();
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx, command) || this.inTransaction()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    private boolean inTransaction() throws SystemException {
        return this.txMgr != null && this.txMgr.getTransaction() != null;
    }

    private void prepareCacheLoader(InvocationContext ctx, GlobalTransaction gtx, TransactionContext transactionContext, boolean onePhase) throws Throwable {
        if (transactionContext == null) {
            throw new Exception("transactionContext for transaction " + gtx + " not found in transaction table");
        }
        List<WriteCommand> modifications = transactionContext.getModifications();
        if (modifications.size() == 0) {
            this.log.trace("Transaction has not logged any modifications!");
            return;
        }
        this.log.trace((Object)"Cache loader modification list: {0}", modifications);
        StoreModificationsBuilder modsBuilder = new StoreModificationsBuilder(this.getStatisticsEnabled());
        for (WriteCommand cacheCommand : modifications) {
            cacheCommand.acceptVisitor(ctx, modsBuilder);
        }
        int numMods = modsBuilder.modifications.size();
        this.log.trace((Object)"Converted method calls to cache loader modifications.  List size: {0}", numMods);
        if (numMods > 0) {
            Transaction tx = transactionContext.getTransaction();
            this.store.prepare(modsBuilder.modifications, tx, onePhase);
            this.preparingTxs.put(tx, modsBuilder.affectedKeys);
            if (this.getStatisticsEnabled() && modsBuilder.putCount > 0) {
                this.txStores.put(tx, modsBuilder.putCount);
            }
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.cacheStores.set(0L);
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of cache loader stores")
    public long getCacheLoaderStores() {
        return this.cacheStores.get();
    }

    private InternalCacheEntry getStoredEntry(Object key, InvocationContext ctx) {
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return (InternalCacheEntry)entry;
        }
        return InternalEntryFactory.create(entry.getKey(), entry.getValue(), entry.getLifespan(), entry.getMaxIdle());
    }

    public class StoreModificationsBuilder
    extends AbstractVisitor {
        boolean generateStatistics;
        int putCount;
        Set<Object> affectedKeys = new HashSet<Object>();
        List<Modification> modifications = new ArrayList<Modification>();

        public StoreModificationsBuilder(boolean generateStatistics) {
            this.generateStatistics = generateStatistics;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.generateStatistics) {
                ++this.putCount;
            }
            this.modifications.add(new Store(CacheStoreInterceptor.this.getStoredEntry(command.getKey(), ctx)));
            this.affectedKeys.add(command.getKey());
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map<Object, Object> map = command.getMap();
            if (this.generateStatistics) {
                this.putCount += map.size();
            }
            this.affectedKeys.addAll(map.keySet());
            for (Object key : map.keySet()) {
                this.modifications.add(new Store(CacheStoreInterceptor.this.getStoredEntry(key, ctx)));
            }
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.modifications.add(new Remove(command.getKey()));
            this.affectedKeys.add(command.getKey());
            return null;
        }

        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.modifications.add(new Clear());
            return null;
        }
    }
}

