/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.Transaction;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.GlobalTransaction;

public class CallInterceptor
extends CommandInterceptor {
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handlePrepareCommand.");
        }
        return null;
    }

    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleCommitCommand.");
        }
        return null;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Suppressing invocation of method handleRollbackCommand.");
        }
        return null;
    }

    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.trace) {
            this.log.trace("Executing command: " + command + ".");
        }
        return this.invokeCommand(ctx, command);
    }

    private Object invokeCommand(InvocationContext ctx, ReplicableCommand command) throws Throwable {
        Object retval;
        try {
            retval = command.perform(ctx);
        }
        catch (Throwable t) {
            Transaction tx = ctx.getTransaction();
            if (ctx.isValidTransaction()) {
                tx.setRollbackOnly();
            }
            throw t;
        }
        return retval;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleAlterCacheMethod(ctx, command);
    }

    private Object handleAlterCacheMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object result = this.invokeCommand(ctx, command);
        if (ctx.isValidTransaction()) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("didn't find GlobalTransaction for " + ctx.getTransaction() + "; won't add modification to transaction list");
                }
            } else {
                ctx.getTransactionContext().addModification(command);
            }
        }
        return result;
    }
}

