/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.ResponseMode;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.util.Immutables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionInterceptor
extends BaseRpcInterceptor {
    DistributionManager dm;
    CommandsFactory cf;
    private final Map<GlobalTransaction, List<Address>> txRecipients = new ConcurrentHashMap<GlobalTransaction, List<Address>>();
    static final RecipientGenerator CLEAR_COMMAND_GENERATOR = new RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Object[] getKeys() {
            return null;
        }
    };

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf) {
        this.dm = distributionManager;
        this.cf = cf;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (returnValue == null) {
            ClusteredGetCommand get = this.cf.buildClusteredGetCommand(command.getKey());
            List<Response> responses = this.rpcManager.invokeRemotely(this.dm.locate(command.getKey()), get, ResponseMode.SYNCHRONOUS, this.configuration.getSyncReplTimeout(), false, false);
            if (responses.isEmpty()) {
                return returnValue;
            }
            for (Response response : responses) {
                if (response instanceof Throwable) continue;
                InternalCacheEntry ice = (InternalCacheEntry)((Object)response);
                if (this.configuration.isL1CacheEnabled()) {
                    long lifespan = ice.getLifespan() < 0L ? this.configuration.getL1Lifespan() : Math.min(ice.getLifespan(), this.configuration.getL1Lifespan());
                    PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L);
                    this.invokeNextInterceptor(ctx, put);
                }
                return ice.getValue();
            }
            return null;
        }
        return returnValue;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()));
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            List<Address> recipients;
            if (!this.skipReplicationOfTransactionMethod(ctx) && (recipients = this.txRecipients.get(command.getGlobalTransaction())) != null) {
                this.replicateCall(ctx, recipients, command, this.configuration.isSyncCommitPhase(), true);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.txRecipients.remove(command.getGlobalTransaction());
        }
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext.hasLocalModifications()) {
            PrepareCommand replicablePrepareCommand = command.copy();
            replicablePrepareCommand.removeModifications(transactionContext.getLocalModifications());
            command = replicablePrepareCommand;
        }
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            boolean sync = this.configuration.getCacheMode().isSynchronous();
            if (this.trace) {
                this.log.trace((Object)("[" + this.rpcManager.getTransport().getAddress() + "] Running remote prepare for global tx {1}.  Synchronous? {2}"), this.rpcManager.getTransport().getAddress(), command.getGlobalTransaction(), sync);
            }
            List<Address> recipients = this.determineRecipients(command);
            this.txRecipients.put(command.getGlobalTransaction(), recipients);
            this.replicateCall(ctx, command, sync);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            List<Address> recipients;
            if (!this.skipReplicationOfTransactionMethod(ctx) && !ctx.isLocalRollbackOnly() && (recipients = this.txRecipients.get(command.getGlobalTransaction())) != null) {
                this.replicateCall(ctx, recipients, command, this.configuration.isSyncRollbackPhase(), true);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.txRecipients.remove(command.getGlobalTransaction());
        }
    }

    private List<Address> determineRecipients(PrepareCommand cmd) {
        HashSet<Address> r = new HashSet<Address>();
        boolean toAll = false;
        for (WriteCommand c : cmd.getModifications()) {
            if (c instanceof ClearCommand) {
                toAll = true;
                break;
            }
            if (c instanceof DataCommand) {
                r.addAll(this.dm.locate(((DataCommand)((Object)c)).getKey()));
                continue;
            }
            if (!(c instanceof PutMapCommand)) continue;
            r.addAll(new MultipleKeysRecipientGenerator(((PutMapCommand)c).getMap().keySet()).generateRecipients());
        }
        return toAll ? null : Immutables.immutableListConvert(r);
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command, RecipientGenerator recipientGenerator) throws Throwable {
        boolean local = this.isLocalModeForced(ctx);
        if (local && ctx.getTransaction() == null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            if (ctx.getTransaction() == null && ctx.isOriginLocal()) {
                if (this.trace) {
                    this.log.trace("invoking method " + command.getClass().getSimpleName() + ", members=" + this.rpcManager.getTransport().getMembers() + ", mode=" + (Object)((Object)this.configuration.getCacheMode()) + ", exclude_self=" + true + ", timeout=" + this.configuration.getSyncReplTimeout());
                }
                List<Address> rec = recipientGenerator.generateRecipients();
                if (this.configuration.isL1CacheEnabled() && rec != null) {
                    InvalidateCommand ic = this.cf.buildInvalidateCommand(recipientGenerator.getKeys());
                    this.replicateCall(ctx, ic, this.isSynchronous(ctx), false);
                }
                this.replicateCall(ctx, rec, command, this.isSynchronous(ctx), false);
            } else if (local) {
                ctx.getTransactionContext().addLocalModification(command);
            }
        }
        return returnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        Collection<Object> keys;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            HashSet<Address> addresses = new HashSet<Address>();
            Map<Object, List<Address>> recipients = DistributionInterceptor.this.dm.locateAll(this.keys);
            for (List<Address> a : recipients.values()) {
                addresses.addAll(a);
            }
            return Immutables.immutableListConvert(addresses);
        }

        @Override
        public Object[] getKeys() {
            return this.keys.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        Object key;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
        }

        @Override
        public List<Address> generateRecipients() {
            return DistributionInterceptor.this.dm.locate(this.key);
        }

        @Override
        public Object[] getKeys() {
            return new Object[]{this.key};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RecipientGenerator {
        public List<Address> generateRecipients();

        public Object[] getKeys();
    }
}

