/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.EntryFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lock.IsolationLevel;
import org.infinispan.lock.LockManager;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;

public class LockingInterceptor
extends CommandInterceptor {
    LockManager lockManager;
    DataContainer dataContainer;
    EntryFactory entryFactory;
    boolean useReadCommitted;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer dataContainer, EntryFactory entryFactory) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
    }

    @Start
    private void determineIsolationLevel() {
        this.useReadCommitted = this.configuration.getIsolationLevel() == IsolationLevel.READ_COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.transactionalCleanup(true, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.transactionalCleanup(false, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (command.isOnePhaseCommit()) {
                this.transactionalCleanup(true, ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object r;
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = r = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No locking performed for SizeCommands");
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (Object key : this.dataContainer.keySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, false, false, false, false);
            }
            ctx.setContainsModifications(true);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.visitRemoveCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        try {
            if (command.getKeys() != null) {
                for (Object key : command.getKeys()) {
                    this.entryFactory.wrapEntryForWriting(ctx, key, false, true, false, false);
                }
            }
            Object o = this.invokeNextInterceptor(ctx, command);
            if (!ctx.isContainsModifications()) {
                ctx.setContainsModifications(command.isSuccessful());
            }
            Object object = o;
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), true, false, false, false);
            Object o = this.invokeNextInterceptor(ctx, command);
            if (!ctx.isContainsModifications()) {
                ctx.setContainsModifications(command.isSuccessful());
            }
            Object object = o;
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            for (Object key : command.getMap().keySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, true, false, false, false);
            }
            Object o = this.invokeNextInterceptor(ctx, command);
            if (!ctx.isContainsModifications()) {
                ctx.setContainsModifications(command.isSuccessful());
            }
            Object object = o;
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, true);
            Object o = this.invokeNextInterceptor(ctx, command);
            if (!ctx.isContainsModifications()) {
                ctx.setContainsModifications(command.isSuccessful());
            }
            Object object = o;
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, false);
            Object o = this.invokeNextInterceptor(ctx, command);
            if (!ctx.isContainsModifications()) {
                ctx.setContainsModifications(command.isSuccessful());
            }
            Object object = o;
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    private void doAfterCall(InvocationContext ctx) {
        BidirectionalMap<Object, CacheEntry> lookedUpEntries;
        if (ctx.getTransactionContext() == null) {
            if (ctx.isContainsModifications() || ctx.isContainsLocks()) {
                this.cleanupLocks(ctx, Thread.currentThread(), true);
            } else if (this.trace) {
                this.log.trace("Nothing to do since there are no modifications in scope.");
            }
        } else if (this.useReadCommitted && !(lookedUpEntries = ctx.getLookedUpEntries()).isEmpty()) {
            ArrayList keysToRemove = new ArrayList(lookedUpEntries.size());
            for (Map.Entry e : lookedUpEntries.entrySet()) {
                if (this.lockManager.possiblyLocked((CacheEntry)e.getValue())) continue;
                keysToRemove.add(e.getKey());
            }
            if (!keysToRemove.isEmpty()) {
                if (this.trace) {
                    this.log.trace((Object)"Removing keys {0} since they have not been modified.  Context currently contains {1} keys", keysToRemove, ctx.getLookedUpEntries().size());
                }
                for (Map.Entry key : keysToRemove) {
                    ctx.removeLookedUpEntry(key);
                }
                if (this.trace) {
                    this.log.trace((Object)"After removal, context contains {0} keys", ctx.getLookedUpEntries().size());
                }
            }
        }
    }

    private void cleanupLocks(InvocationContext ctx, Object owner, boolean commit) {
        ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
        Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
        if (this.trace) {
            this.log.trace((Object)"Number of entries in context: {0}", entries.size());
        }
        if (commit) {
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                Object key = e.getKey();
                boolean needToUnlock = this.lockManager.possiblyLocked(entry);
                if (entry != null && entry.isChanged()) {
                    entry.commit(this.dataContainer);
                } else if (this.trace) {
                    this.log.trace((Object)"Entry for key {0} is null, not calling commitUpdate", key);
                }
                if (!needToUnlock) continue;
                if (this.trace) {
                    this.log.trace("Releasing lock on [" + key + "] for owner " + owner);
                }
                this.lockManager.unlock(key, owner);
            }
        } else {
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                Object key = e.getKey();
                boolean needToUnlock = this.lockManager.possiblyLocked(entry);
                if (entry != null && entry.isChanged()) {
                    entry.rollback();
                } else if (this.trace) {
                    this.log.trace((Object)"Entry for key {0} is null, not calling rollbackUpdate", key);
                }
                if (!needToUnlock) continue;
                if (this.trace) {
                    this.log.trace("Releasing lock on [" + key + "] for owner " + owner);
                }
                this.lockManager.unlock(key, owner);
            }
        }
        ctx.setContainsModifications(false);
        ctx.setContainsLocks(false);
    }

    private void transactionalCleanup(boolean commit, InvocationContext ctx) {
        if (ctx.getTransactionContext() != null) {
            if (ctx.isContainsModifications() || ctx.isContainsLocks()) {
                if (this.trace) {
                    this.log.trace((Object)"Performing cleanup.  Contains mods? {0} Contains locks? {1}", ctx.isContainsModifications(), ctx.isContainsLocks());
                }
                this.cleanupLocks(ctx, ctx.getGlobalTransaction(), commit);
            } else if (this.trace) {
                this.log.trace("At transaction boundary (" + (commit ? "commit" : "rollback") + "), and we have no locks in context!");
            }
        } else {
            throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
        }
    }
}

