/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loader.CacheLoaderManager;
import org.infinispan.loader.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class PassivationInterceptor
extends JmxStatsCommandInterceptor {
    private final AtomicLong passivations = new AtomicLong(0L);
    CacheStore cacheStore;
    CacheNotifier notifier;
    CacheLoaderManager cacheLoaderManager;
    DataContainer dataContainer;

    @Inject
    public void setDependencies(CacheNotifier notifier, CacheLoaderManager cacheLoaderManager, DataContainer dataContainer) {
        this.notifier = notifier;
        this.cacheLoaderManager = cacheLoaderManager;
        this.dataContainer = dataContainer;
    }

    @Start(priority=15)
    public void start() {
        CacheStore cacheStore = this.cacheStore = this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheStore();
        if (this.cacheStore == null) {
            throw new ConfigurationException("passivation can only be used with a CacheLoader that implements CacheStore!");
        }
    }

    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object key = command.getKey();
        this.notifier.notifyCacheEntryPassivated(key, true, ctx);
        this.log.trace((Object)"Passivating entry {0}", key);
        InternalCacheEntry entryForStorage = this.dataContainer.get(key);
        this.cacheStore.store(entryForStorage);
        this.notifier.notifyCacheEntryPassivated(key, false, ctx);
        if (this.getStatisticsEnabled() && entryForStorage != null) {
            this.passivations.getAndIncrement();
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @ManagedOperation
    public void resetStatistics() {
        this.passivations.set(0L);
    }

    @ManagedAttribute(description="Number of passivation events")
    public String getPassivations() {
        if (!this.getStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.passivations.get());
    }
}

