/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.transaction.GlobalTransaction;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            this.replicateCall(ctx, command, this.configuration.isSyncCommitPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext.hasLocalModifications()) {
            PrepareCommand replicablePrepareCommand = command.copy();
            replicablePrepareCommand.removeModifications(transactionContext.getLocalModifications());
            command = replicablePrepareCommand;
        }
        if (!this.skipReplicationOfTransactionMethod(ctx)) {
            this.runPreparePhase(command, command.getGlobalTransaction(), ctx);
        }
        return retVal;
    }

    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.skipReplicationOfTransactionMethod(ctx) && !ctx.isLocalRollbackOnly()) {
            this.replicateCall(ctx, command, this.configuration.isSyncRollbackPhase());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    private Object handleCrudMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        boolean local = this.isLocalModeForced(ctx);
        if (local && ctx.getTransaction() == null) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            if (ctx.getTransaction() == null && ctx.isOriginLocal()) {
                if (this.trace) {
                    this.log.trace("invoking method " + command.getClass().getSimpleName() + ", members=" + this.rpcManager.getTransport().getMembers() + ", mode=" + (Object)((Object)this.configuration.getCacheMode()) + ", exclude_self=" + true + ", timeout=" + this.configuration.getSyncReplTimeout());
                }
                this.replicateCall(ctx, command, this.isSynchronous(ctx));
            } else if (local) {
                ctx.getTransactionContext().addLocalModification(command);
            }
        }
        return returnValue;
    }

    protected void runPreparePhase(PrepareCommand prepareMethod, GlobalTransaction gtx, InvocationContext ctx) throws Throwable {
        boolean async;
        boolean bl = async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
        if (this.trace) {
            this.log.trace("(" + this.rpcManager.getTransport().getAddress() + "): running remote prepare for global tx " + gtx + " with async mode=" + async);
        }
        this.replicateCall(ctx, prepareMethod, !async);
    }
}

