/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.context.ContextFactory;
import org.infinispan.interceptors.BaseTransactionalContextInterceptor;
import org.infinispan.invocation.Flag;
import org.infinispan.invocation.InvocationContextContainer;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lock.LockManager;
import org.infinispan.manager.CacheManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.ReplicationException;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.concurrent.ConcurrentHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxInterceptor
extends BaseTransactionalContextInterceptor {
    protected CommandsFactory commandsFactory;
    private CacheNotifier notifier;
    private InvocationContextContainer invocationContextContainer;
    private ComponentRegistry componentRegistry;
    private ContextFactory contextFactory;
    private CacheManager cacheManager;
    private TransactionLog transactionLog;
    private final Set<Transaction> transactions = new ConcurrentHashSet<Transaction>();
    private final Map<Transaction, GlobalTransaction> rollbackTransactions = new ConcurrentHashMap<Transaction, GlobalTransaction>(16);
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    private LockManager lockManager;
    private boolean statsEnabled;

    @Inject
    public void intialize(CacheManager cacheManager, ContextFactory contextFactory, CacheNotifier notifier, InvocationContextContainer icc, CommandsFactory factory, ComponentRegistry componentRegistry, LockManager lockManager, TransactionLog transactionLog) {
        this.contextFactory = contextFactory;
        this.commandsFactory = factory;
        this.cacheManager = cacheManager;
        this.notifier = notifier;
        this.invocationContextContainer = icc;
        this.componentRegistry = componentRegistry;
        this.lockManager = lockManager;
        this.transactionLog = transactionLog;
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Got gtx from invocation context " + ctx.getGlobalTransaction());
        }
        try {
            if (ctx.getGlobalTransaction().isRemote()) {
                result = this.handleRemotePrepare(ctx, command);
                if (this.getStatisticsEnabled()) {
                    this.prepares.incrementAndGet();
                }
            } else {
                if (this.trace) {
                    this.log.trace("received my own message (discarding it)");
                }
                result = null;
            }
        }
        catch (Throwable e) {
            this.throwIfNeeded(ctx, e);
        }
        return result;
    }

    private void throwIfNeeded(InvocationContext ctx, Throwable throwable) throws Throwable {
        if (!ctx.hasFlag(Flag.FAIL_SILENTLY)) {
            throw throwable;
        }
        this.log.trace((Object)"There was a problem handling this request, but FAIL_SLIENTLY was set, so suppressing exception", throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.getGlobalTransaction().isRemote()) {
            if (this.trace) {
                this.log.trace("received my own message (discarding it)");
            }
            return null;
        }
        try {
            if (this.trace) {
                this.log.trace("(" + this.cacheManager.getAddress() + ") call on command [" + command + "]");
            }
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            Transaction ltx = this.txTable.getLocalTransaction(gtx, true);
            Transaction currentTx = this.txManager.getTransaction();
            boolean resumeCurrentTxOnCompletion = false;
            try {
                if (!ltx.equals(currentTx)) {
                    currentTx = this.txManager.suspend();
                    resumeCurrentTxOnCompletion = true;
                    this.txManager.resume(ltx);
                    ctx.setTransaction(ltx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(" executing commit() with local TX " + ltx + " under global tx " + gtx);
                }
                this.txManager.commit();
                if (this.getStatisticsEnabled()) {
                    this.commits.incrementAndGet();
                }
            }
            finally {
                if (resumeCurrentTxOnCompletion) {
                    this.resumeTransactionOnCompletion(ctx, currentTx);
                }
                this.transactions.remove(ltx);
                this.txTable.cleanup(gtx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished remote rollback method for " + gtx);
            }
        }
        catch (Throwable throwable) {
            this.throwIfNeeded(ctx, throwable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!ctx.getGlobalTransaction().isRemote()) {
            if (this.trace) {
                this.log.trace("received my own message (discarding it)");
            }
            return null;
        }
        try {
            GlobalTransaction gtx;
            Transaction ltx;
            if (this.trace) {
                this.log.trace("(" + this.cacheManager.getAddress() + ") call on command [" + command + "]");
            }
            if ((ltx = this.txTable.getLocalTransaction(gtx = ctx.getGlobalTransaction())) == null) {
                this.log.warn("No local transaction for this remotely originating rollback.  Possibly rolling back before a prepare call was broadcast?");
                this.txTable.cleanup(gtx);
                return null;
            }
            Transaction currentTx = this.txManager.getTransaction();
            boolean resumeCurrentTxOnCompletion = false;
            try {
                if (!ltx.equals(currentTx)) {
                    currentTx = this.txManager.suspend();
                    resumeCurrentTxOnCompletion = true;
                    this.txManager.resume(ltx);
                    ctx.setTransaction(ltx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("executing with local TX " + ltx + " under global tx " + gtx);
                }
                this.txManager.rollback();
                if (this.getStatisticsEnabled()) {
                    this.rollbacks.incrementAndGet();
                }
            }
            finally {
                if (resumeCurrentTxOnCompletion) {
                    this.resumeTransactionOnCompletion(ctx, currentTx);
                }
                this.transactions.remove(ltx);
                this.txTable.cleanup(gtx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished remote commit/rollback method for " + gtx);
            }
        }
        catch (Throwable throwable) {
            this.throwIfNeeded(ctx, throwable);
        }
        return null;
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            Object retval = this.attachGtxAndPassUpChain(ctx, command);
            if (command instanceof WriteCommand && ctx.getTransaction() == null) {
                this.transactionLog.logNoTxWrite((WriteCommand)command);
            }
            return retval;
        }
        catch (Throwable throwable) {
            this.throwIfNeeded(ctx, throwable);
            return null;
        }
    }

    protected Object attachGtxAndPassUpChain(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            this.attachGlobalTransaction(ctx, tx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object handleRemotePrepare(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval;
        Transaction currentTx;
        GlobalTransaction gtx;
        block37: {
            gtx = ctx.getGlobalTransaction();
            Transaction ltx = this.txTable.getLocalTransaction(gtx);
            currentTx = this.txManager.getTransaction();
            retval = null;
            boolean success = false;
            try {
                TransactionContext transactionContext;
                if (ltx == null) {
                    if (currentTx != null) {
                        this.txManager.suspend();
                    }
                    ltx = this.createLocalTx();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("creating new tx transactionContext");
                    }
                    transactionContext = this.contextFactory.createTransactionContext(ltx);
                    this.txTable.associateTransaction(ltx, gtx, transactionContext);
                    if (this.trace) {
                        this.log.trace("Created new tx for gtx " + gtx);
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Started new local tx as result of remote prepare: local tx=" + ltx + " (status=" + ltx.getStatus() + "), gtx=" + gtx);
                    }
                } else {
                    if (!TransactionTable.isValid(ltx)) {
                        throw new CacheException("Transaction " + ltx + " not in correct state to be prepared");
                    }
                    if (currentTx == null || !ltx.equals(currentTx)) {
                        if (this.trace) {
                            this.log.trace("Suspending current tx " + currentTx);
                        }
                        this.txManager.suspend();
                        this.txManager.resume(ltx);
                    }
                    if ((transactionContext = this.txTable.getTransactionContext(gtx)) == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("creating new tx transactionContext");
                        }
                        transactionContext = this.contextFactory.createTransactionContext(ltx);
                        this.txTable.associateTransaction(ltx, gtx, transactionContext);
                    }
                }
                if (this.trace) {
                    this.log.trace("Resuming existing tx " + ltx + ", global tx=" + gtx);
                }
                ctx.setTransactionContext(transactionContext);
                ctx.setTransaction(ltx);
                ctx.setGlobalTransaction(gtx);
                this.registerHandler(ltx, new RemoteSynchronizationHandler(gtx, ltx, transactionContext), ctx);
                success = false;
                this.replayModifications(ctx, ltx, command);
                success = true;
                if (command.isOnePhaseCommit()) {
                    if (this.trace) {
                        this.log.trace("Using one-phase prepare.  Not propagating the prepare call up the stack until called to do so by the sync handler.");
                    }
                } else {
                    this.transactionLog.logPrepare(command);
                    this.invokeNextInterceptor(ctx, command);
                }
                this.assertTxIsStillValid(ltx);
                Object var10_9 = null;
                if (this.trace) {
                    this.log.trace("Are we running a 1-phase commit? " + command.isOnePhaseCommit());
                }
                if (!command.isOnePhaseCommit()) break block37;
            }
            catch (Throwable throwable) {
                block41: {
                    Object var10_10 = null;
                    if (this.trace) {
                        this.log.trace("Are we running a 1-phase commit? " + command.isOnePhaseCommit());
                    }
                    if (command.isOnePhaseCommit()) {
                        try {
                            block40: {
                                if (success) {
                                    ltx.commit();
                                    break block40;
                                }
                                ltx.rollback();
                            }
                            Object var14_14 = null;
                            this.transactions.remove(ltx);
                        }
                        catch (Throwable throwable2) {
                            Object var14_16 = null;
                            this.transactions.remove(ltx);
                            throw throwable2;
                        }
                        {
                            break block41;
                            catch (Throwable t) {
                                this.log.error((Object)"Commit/rollback failed.", t);
                                if (success) {
                                    try {
                                        this.log.info("Attempting anotehr rollback");
                                        ltx.rollback();
                                    }
                                    catch (Throwable t2) {
                                        this.log.error((Object)"Unable to rollback", t2);
                                    }
                                }
                                Object var14_15 = null;
                                this.transactions.remove(ltx);
                            }
                        }
                    }
                }
                this.txManager.suspend();
                if (currentTx != null) {
                    this.txManager.resume(currentTx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Finished remote prepare " + gtx);
                }
                throw throwable;
            }
            try {
                block38: {
                    if (success) {
                        ltx.commit();
                        break block38;
                    }
                    ltx.rollback();
                }
                Object var14_11 = null;
                this.transactions.remove(ltx);
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                this.transactions.remove(ltx);
                throw throwable;
            }
            {
                break block37;
                catch (Throwable t) {
                    this.log.error((Object)"Commit/rollback failed.", t);
                    if (success) {
                        try {
                            this.log.info("Attempting anotehr rollback");
                            ltx.rollback();
                        }
                        catch (Throwable t2) {
                            this.log.error((Object)"Unable to rollback", t2);
                        }
                    }
                    Object var14_12 = null;
                    this.transactions.remove(ltx);
                }
            }
        }
        this.txManager.suspend();
        if (currentTx != null) {
            this.txManager.resume(currentTx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished remote prepare " + gtx);
        }
        return retval;
    }

    private ReplicableCommand attachGlobalTransaction(InvocationContext ctx, Transaction tx, VisitableCommand command) throws Throwable {
        GlobalTransaction gtx;
        if (this.trace) {
            this.log.trace(" local transaction exists - registering global tx if not present for " + Thread.currentThread());
        }
        if (this.trace) {
            GlobalTransaction tempGtx = this.txTable.get(tx);
            this.log.trace("Associated gtx in txTable is " + tempGtx);
        }
        if ((gtx = this.registerTransaction(tx, ctx)) == null) {
            gtx = this.txTable.get(tx);
        }
        ctx.setGlobalTransaction(gtx);
        return command;
    }

    protected void replayModifications(InvocationContext ctx, Transaction ltx, PrepareCommand command) throws Throwable {
        try {
            for (WriteCommand modification : command.getModifications()) {
                this.invokeNextInterceptor(ctx, modification);
                this.assertTxIsStillValid(ltx);
            }
        }
        catch (Throwable th) {
            this.log.error((Object)"prepare failed!", th);
            throw th;
        }
    }

    private void resumeTransactionOnCompletion(InvocationContext ctx, Transaction currentTx) throws SystemException, InvalidTransactionException {
        if (this.trace) {
            this.log.trace("Resuming suspended transaction " + currentTx);
        }
        this.txManager.suspend();
        if (currentTx != null) {
            this.txManager.resume(currentTx);
            ctx.setTransaction(currentTx);
        }
    }

    private Object handleCommitRollback(InvocationContext ctx, VisitableCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        Object result = this.invokeNextInterceptor(ctx, command);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finished local commit/rollback method for " + gtx);
        }
        return result;
    }

    protected PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return this.commandsFactory.buildPrepareCommand(gtx, modifications, this.cacheManager.getAddress(), onePhaseCommit);
    }

    protected void runCommitPhase(InvocationContext ctx, GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        try {
            AbstractTransactionBoundaryCommand commitCommand;
            AbstractTransactionBoundaryCommand abstractTransactionBoundaryCommand = commitCommand = onePhaseCommit ? this.buildPrepareCommand(gtx, modifications, true) : this.commandsFactory.buildCommitCommand(gtx);
            if (this.trace) {
                this.log.trace("Running commit for " + gtx);
            }
            this.handleCommitRollback(ctx, commitCommand);
            if (onePhaseCommit) {
                this.transactionLog.logOnePhaseCommit(gtx, modifications);
            } else {
                this.transactionLog.logCommit(gtx);
            }
        }
        catch (Throwable e) {
            this.log.warn("Commit failed.  Clearing stale locks.");
            try {
                this.cleanupStaleLocks(ctx);
            }
            catch (RuntimeException re) {
                this.log.error((Object)"Unable to clear stale locks", re);
                throw re;
            }
            catch (Throwable e2) {
                this.log.error((Object)"Unable to clear stale locks", e2);
                throw new RuntimeException(e2);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Commit failed.", e);
        }
    }

    protected void cleanupStaleLocks(InvocationContext ctx) throws Throwable {
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext != null) {
            this.lockManager.unlock(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runRollbackPhase(InvocationContext ctx, GlobalTransaction gtx, Transaction tx) {
        try {
            try {
                RollbackCommand rollbackCommand = this.commandsFactory.buildRollbackCommand(gtx);
                if (this.trace) {
                    this.log.trace((Object)" running rollback for {0}", gtx);
                }
                this.transactionLog.rollback(gtx);
                this.rollbackTransactions.put(tx, gtx);
                this.handleCommitRollback(ctx, rollbackCommand);
            }
            catch (Throwable e) {
                this.log.warn((Object)"Rollback had a problem", e);
                Object var6_7 = null;
                this.rollbackTransactions.remove(tx);
                return;
            }
            Object var6_6 = null;
            this.rollbackTransactions.remove(tx);
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.rollbackTransactions.remove(tx);
            throw throwable;
        }
    }

    private boolean isOnePhaseCommit() {
        if (!this.configuration.getCacheMode().isSynchronous()) {
            if (this.trace) {
                this.log.trace("This is a REPL_ASYNC call (1 phase commit) - do nothing for beforeCompletion()");
            }
            return true;
        }
        return false;
    }

    public Object runPreparePhase(InvocationContext ctx, GlobalTransaction gtx, List<WriteCommand> modifications) throws Throwable {
        PrepareCommand prepareCommand = this.buildPrepareCommand(gtx, modifications, false);
        this.transactionLog.logPrepare(prepareCommand);
        Transaction ltx = ctx.getTransaction();
        Transaction currentTransaction = this.txManager.getTransaction();
        if (currentTransaction == null || ltx == null || !currentTransaction.equals(ltx)) {
            this.log.warn("Local transaction does not exist or does not match expected transaction " + gtx);
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction " + gtx);
        }
        Object result = this.invokeNextInterceptor(ctx, prepareCommand);
        return result;
    }

    protected void assertTxIsStillValid(Transaction tx) {
        if (!TransactionTable.isActive(tx)) {
            try {
                throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + tx.getStatus());
            }
            catch (SystemException e) {
                throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; Unable to retrieve transaction status.");
            }
        }
    }

    private GlobalTransaction registerTransaction(Transaction tx, InvocationContext ctx) throws Exception {
        GlobalTransaction gtx;
        boolean txValid = TransactionTable.isValid(tx);
        if (!txValid) {
            throw new IllegalStateException("Transaction " + tx + " is not in a valid state to be invoking cache operations on.");
        }
        if (this.transactions.add(tx)) {
            TransactionContext transactionContext;
            gtx = this.txTable.getCurrentTransaction(tx, true);
            if (ctx.getGlobalTransaction() == null) {
                ctx.setGlobalTransaction(gtx);
                transactionContext = this.txTable.getTransactionContext(gtx);
                ctx.setTransactionContext(transactionContext);
            } else {
                transactionContext = ctx.getTransactionContext();
            }
            if (gtx.isRemote()) {
                if (this.trace) {
                    this.log.trace("is a remotely initiated gtx so no need to register a tx for it");
                }
            } else {
                if (this.trace) {
                    this.log.trace((Object)"Registering sync handler for tx {0} and gtx {1}", tx, gtx);
                }
                LocalSynchronizationHandler myHandler = new LocalSynchronizationHandler(gtx, tx, transactionContext, !ctx.isOriginLocal());
                this.registerHandler(tx, myHandler, ctx);
            }
        } else {
            gtx = this.rollbackTransactions.get(tx);
            if (gtx != null) {
                if (this.trace) {
                    this.log.trace((Object)"Transaction {0} is already registered and is rolling back.", tx);
                }
            } else if (this.trace) {
                this.log.trace((Object)"Transaction {0} is already registered.", tx);
            }
        }
        return gtx;
    }

    private void registerHandler(Transaction tx, Synchronization sync, InvocationContext ctx) throws Exception {
        if (this.trace) {
            this.log.trace("registering for TX completion: Synchronization (" + sync + ")");
        }
        tx.registerSynchronization(sync);
        this.notifier.notifyTransactionRegistered(tx, ctx);
    }

    protected Transaction createLocalTx() throws Exception {
        if (this.trace) {
            this.log.trace("Creating transaction for thread " + Thread.currentThread());
        }
        if (this.txManager == null) {
            throw new Exception("Failed to create local transaction; TransactionManager is null");
        }
        this.txManager.begin();
        Transaction localTx = this.txManager.getTransaction();
        return localTx;
    }

    @ManagedOperation
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of transaction prepares")
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="number of transaction commits")
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="number of transaction rollbacks")
    public long getRollbacks() {
        return this.rollbacks.get();
    }

    private class LocalSynchronizationHandler
    extends RemoteSynchronizationHandler {
        private boolean localRollbackOnly;
        private boolean remoteLocal;
        private Set<Flag> originalFlags;
        private Set<Flag> transactionalFlags;

        LocalSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TransactionContext transactionContext, boolean remoteLocal) {
            super(gtx, tx, transactionContext);
            this.localRollbackOnly = true;
            this.remoteLocal = false;
            this.remoteLocal = remoteLocal;
        }

        public void beforeCompletion() {
            super.beforeCompletion();
            this.ctx.setOriginLocal(!this.remoteLocal);
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (!this.transactionContext.hasModifications()) {
                if (TxInterceptor.this.trace) {
                    TxInterceptor.this.log.trace("No modifications in this tx.  Skipping beforeCompletion()");
                }
                this.modifications = Collections.emptyList();
                return;
            }
            this.modifications = this.transactionContext.getModifications();
            this.originalFlags = this.ctx.getFlags();
            this.transactionalFlags = this.transactionContext.getFlags();
            this.ctx.setFlags(this.transactionalFlags);
            try {
                switch (this.tx.getStatus()) {
                    case 0: 
                    case 7: {
                        Object result;
                        Object object = result = TxInterceptor.this.isOnePhaseCommit() ? null : TxInterceptor.this.runPreparePhase(this.ctx, this.gtx, this.modifications);
                        if (result instanceof Throwable) {
                            if (TxInterceptor.this.log.isDebugEnabled()) {
                                TxInterceptor.this.log.debug((Object)("Transaction needs to be rolled back - the cache returned an instance of Throwable for this prepare call (tx=" + this.tx + " and gtx=" + this.gtx + ")"), (Throwable)result);
                            }
                            this.tx.setRollbackOnly();
                            throw (Throwable)result;
                        }
                        break;
                    }
                    default: {
                        throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unable to start transaction");
                    }
                }
            }
            catch (Throwable t) {
                if (TxInterceptor.this.log.isWarnEnabled()) {
                    TxInterceptor.this.log.warn((Object)"Caught exception, will now set transaction to roll back", t);
                }
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new RuntimeException("setting tx rollback failed ", se);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("", t);
            }
            finally {
                this.localRollbackOnly = false;
                TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                this.ctx.setFlags(this.originalFlags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (this.ctx == null) {
                this.ctx = (InvocationContext)TxInterceptor.this.invocationContextContainer.get();
            }
            this.ctx.setLocalRollbackOnly(this.localRollbackOnly);
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (this.transactionalFlags != null) {
                this.ctx.setFlags(this.transactionalFlags);
            }
            try {
                super.afterCompletion(status);
            }
            finally {
                this.ctx.setFlags(this.originalFlags);
                if (TxInterceptor.this.getStatisticsEnabled()) {
                    if (status == 4) {
                        TxInterceptor.this.rollbacks.incrementAndGet();
                    } else if (status == 3) {
                        TxInterceptor.this.commits.incrementAndGet();
                    }
                }
            }
        }

        public String toString() {
            return "TxInterceptor.LocalSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.getTxAsString() + ")";
        }
    }

    private class RemoteSynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        List<WriteCommand> modifications = null;
        TransactionContext transactionContext = null;
        protected InvocationContext ctx;

        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TransactionContext entry) {
            this.gtx = gtx;
            this.tx = tx;
            this.transactionContext = entry;
        }

        public void beforeCompletion() {
            if (TxInterceptor.this.trace) {
                TxInterceptor.this.log.trace("Running beforeCompletion on gtx " + this.gtx);
            }
            if (this.transactionContext == null) {
                TxInterceptor.this.log.error("Transaction has a null transaction entry - beforeCompletion() will fail.");
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = this.transactionContext.getModifications();
            this.ctx = (InvocationContext)TxInterceptor.this.invocationContextContainer.get();
            TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
            if (this.ctx.isFlagsUninitialized()) {
                this.ctx.setFlags(this.transactionContext.getFlags());
            }
            this.assertCanContinue();
            this.ctx.setOriginLocal(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void afterCompletion(int status) {
            if (this.ctx == null) {
                this.ctx = (InvocationContext)TxInterceptor.this.invocationContextContainer.get();
                TxInterceptor.this.setTransactionalContext(this.tx, this.gtx, this.transactionContext, this.ctx);
                if (this.ctx.isFlagsUninitialized() && this.transactionContext != null) {
                    this.ctx.setFlags(this.transactionContext.getFlags());
                }
            }
            try {
                this.assertCanContinue();
                try {
                    if (TxInterceptor.this.txManager.getTransaction() != null && !TxInterceptor.this.txManager.getTransaction().equals(this.tx)) {
                        TxInterceptor.this.txManager.resume(this.tx);
                    }
                }
                catch (Exception e) {
                    TxInterceptor.this.log.error((Object)("afterCompletion error: " + status), e);
                }
                if (TxInterceptor.this.trace) {
                    TxInterceptor.this.log.trace("calling aftercompletion for " + this.gtx);
                }
                if (this.transactionContext != null) {
                    if (this.modifications == null) {
                        this.modifications = this.transactionContext.getModifications();
                    }
                    this.ctx.setFlags(this.transactionContext.getFlags());
                }
                if (this.tx != null) {
                    TxInterceptor.this.transactions.remove(this.tx);
                }
                switch (status) {
                    case 3: {
                        boolean onePhaseCommit = TxInterceptor.this.isOnePhaseCommit();
                        if (TxInterceptor.this.log.isDebugEnabled()) {
                            TxInterceptor.this.log.debug("Running commit phase.  One phase? " + onePhaseCommit);
                        }
                        TxInterceptor.this.runCommitPhase(this.ctx, this.gtx, this.modifications, onePhaseCommit);
                        TxInterceptor.this.log.debug("Finished commit phase");
                        return;
                    }
                    case 5: {
                        TxInterceptor.this.log.warn("Received JTA STATUS_UNKNOWN in afterCompletion()!  XA resources may not be in sync.  The app should manually clean up resources at this point.");
                    }
                    case 1: 
                    case 4: {
                        TxInterceptor.this.log.debug("Running rollback phase");
                        TxInterceptor.this.runRollbackPhase(this.ctx, this.gtx, this.tx);
                        TxInterceptor.this.log.debug("Finished rollback phase");
                        return;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status);
                    }
                }
            }
            catch (Exception th) {
                TxInterceptor.this.log.trace((Object)"Caught exception ", th);
                return;
            }
            finally {
                TxInterceptor.this.txTable.cleanup(this.gtx);
                TxInterceptor.this.setTransactionalContext(null, null, null, this.ctx);
                this.cleanupInternalState();
            }
        }

        private void assertCanContinue() {
            if (!TxInterceptor.this.componentRegistry.invocationsAllowed(true) && !this.ctx.hasFlag(Flag.SKIP_CACHE_STATUS_CHECK)) {
                throw new IllegalStateException("Cache not in STARTED state!");
            }
        }

        private void cleanupInternalState() {
            this.tx = null;
            this.gtx = null;
            this.modifications = null;
            if (this.transactionContext != null) {
                this.transactionContext.reset();
            }
            this.transactionContext = null;
        }

        public String toString() {
            return "TxInterceptor.RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.getTxAsString() + ")";
        }

        protected String getTxAsString() {
            if (this.tx == null) {
                return null;
            }
            return this.tx.getClass().getName() + "@" + System.identityHashCode(this.tx);
        }
    }
}

