/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loader;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loader.AbstractCacheStore;
import org.infinispan.loader.CacheLoaderConfig;
import org.infinispan.loader.CacheLoaderException;
import org.infinispan.loader.LockSupportCacheStoreConfig;
import org.infinispan.lock.StripedLock;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockSupportCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(LockSupportCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private StripedLock locks;
    private long globalLockTimeoutMillis;
    private LockSupportCacheStoreConfig config;

    @Override
    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) {
        super.init(config, cache, m);
        this.config = (LockSupportCacheStoreConfig)config;
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        if (this.config == null) {
            throw new CacheLoaderException("Null config. Possible reason is not calling super.init(...)");
        }
        this.locks = new StripedLock(this.config.getLockConcurrencyLevel());
        this.globalLockTimeoutMillis = this.config.getLockAcquistionTimeout();
    }

    protected void unlock(String key) {
        this.locks.releaseLock(key);
    }

    protected void lockForWritting(String key) throws CacheLoaderException {
        this.locks.acquireLock(key, true);
    }

    protected void lockForReading(String key) throws CacheLoaderException {
        this.locks.acquireLock(key, false);
    }

    protected boolean immediateLockForWritting(String key) throws CacheLoaderException {
        return this.locks.acquireLock(key, true, 0L);
    }

    protected void acquireGlobalLock(boolean exclusive) throws CacheLoaderException {
        this.locks.aquireGlobalLock(exclusive, this.globalLockTimeoutMillis);
    }

    protected void releaseGlobalLock(boolean exclusive) {
        this.locks.releaseGlobalLock(exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InternalCacheEntry load(Object key) throws CacheLoaderException {
        if (trace) {
            log.trace((Object)"load ({0})", key);
        }
        String lockingKey = this.getLockFromKey(key);
        this.lockForReading(lockingKey);
        try {
            InternalCacheEntry internalCacheEntry = this.loadLockSafe(key, lockingKey);
            return internalCacheEntry;
        }
        finally {
            this.unlock(lockingKey);
            if (trace) {
                log.trace("Exit load (" + key + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        if (trace) {
            log.trace("loadAll()");
        }
        this.acquireGlobalLock(false);
        try {
            Set<InternalCacheEntry> set = this.loadAllLockSafe();
            return set;
        }
        finally {
            this.releaseGlobalLock(false);
            if (trace) {
                log.trace("Exit loadAll()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void store(InternalCacheEntry ed) throws CacheLoaderException {
        if (trace) {
            log.trace("store(" + ed + ")");
        }
        if (ed == null) {
            return;
        }
        if (ed.isExpired()) {
            if (trace) {
                log.trace("Entry " + ed + " is expired!  Not doing anything.");
            }
            return;
        }
        String keyHashCode = this.getLockFromKey(ed.getKey());
        this.lockForWritting(keyHashCode);
        try {
            this.storeLockSafe(ed, keyHashCode);
        }
        finally {
            this.unlock(keyHashCode);
        }
        if (trace) {
            log.trace("exit store(" + ed + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object key) throws CacheLoaderException {
        if (trace) {
            log.trace("remove(" + key + ")");
        }
        String keyHashCodeStr = this.getLockFromKey(key);
        try {
            this.lockForWritting(keyHashCodeStr);
            boolean bl = this.removeLockSafe(key, keyHashCodeStr);
            return bl;
        }
        finally {
            this.unlock(keyHashCodeStr);
            if (trace) {
                log.trace("Exit remove(" + key + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fromStream(ObjectInput objectInput) throws CacheLoaderException {
        try {
            this.acquireGlobalLock(true);
            this.clear();
            this.fromStreamLockSafe(objectInput);
        }
        finally {
            this.releaseGlobalLock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toStream(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            this.acquireGlobalLock(false);
            this.toStreamLockSafe(objectOutput);
        }
        finally {
            this.releaseGlobalLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() throws CacheLoaderException {
        if (trace) {
            log.trace("Clearing store");
        }
        try {
            this.acquireGlobalLock(true);
            this.clearLockSafe();
        }
        finally {
            this.releaseGlobalLock(true);
        }
    }

    public int getTotalLockCount() {
        return this.locks.getTotalLockCount();
    }

    protected abstract void clearLockSafe() throws CacheLoaderException;

    protected abstract Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException;

    protected abstract void toStreamLockSafe(ObjectOutput var1) throws CacheLoaderException;

    protected abstract void fromStreamLockSafe(ObjectInput var1) throws CacheLoaderException;

    protected abstract boolean removeLockSafe(Object var1, String var2) throws CacheLoaderException;

    protected abstract void storeLockSafe(InternalCacheEntry var1, String var2) throws CacheLoaderException;

    protected abstract InternalCacheEntry loadLockSafe(Object var1, String var2) throws CacheLoaderException;

    protected abstract String getLockFromKey(Object var1) throws CacheLoaderException;
}

