/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.logging.AbstractLogImpl;

public class JDKLogImpl
extends AbstractLogImpl {
    private final Logger logger;

    public JDKLogImpl(String category) {
        this.logger = Logger.getLogger(category);
    }

    private void log(Level level, Object object, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String className = "unknown";
            String methodName = "unknown";
            int depth = 2;
            if (locations != null && locations.length > depth) {
                StackTraceElement caller = locations[depth];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, className, methodName, String.valueOf(object));
            } else {
                this.logger.logp(level, className, methodName, String.valueOf(object), ex);
            }
        }
    }

    public void trace(Object message) {
        this.log(Level.FINER, message, null);
    }

    public void debug(Object message) {
        this.log(Level.FINE, message, null);
    }

    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    public void warn(Object message) {
        this.log(Level.WARNING, message, null);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, message, null);
    }

    public void fatal(Object message) {
        this.log(Level.SEVERE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }
}

