/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging;

import org.infinispan.logging.JDKLogImpl;
import org.infinispan.logging.Log;
import org.infinispan.logging.Log4JLogImpl;

public class LogFactory {
    private static final boolean IS_LOG4J_AVAILABLE;

    public static Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String category) {
        if (IS_LOG4J_AVAILABLE) {
            return new Log4JLogImpl(category);
        }
        return new JDKLogImpl(category);
    }

    static {
        boolean available;
        try {
            Class.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (ClassNotFoundException cnfe) {
            available = false;
        }
        IS_LOG4J_AVAILABLE = available;
    }
}

