/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.jcip.annotations.Immutable;
import org.infinispan.CacheException;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.jboss.CustomObjectTable;
import org.infinispan.marshall.jboss.externalizers.ArrayListExternalizer;
import org.infinispan.marshall.jboss.externalizers.DeltaAwareExternalizer;
import org.infinispan.marshall.jboss.externalizers.ExceptionResponseExternalizer;
import org.infinispan.marshall.jboss.externalizers.ExtendedResponseExternalizer;
import org.infinispan.marshall.jboss.externalizers.GlobalTransactionExternalizer;
import org.infinispan.marshall.jboss.externalizers.ImmutableMapExternalizer;
import org.infinispan.marshall.jboss.externalizers.InternalCachedEntryExternalizer;
import org.infinispan.marshall.jboss.externalizers.JGroupsAddressExternalizer;
import org.infinispan.marshall.jboss.externalizers.LinkedListExternalizer;
import org.infinispan.marshall.jboss.externalizers.MapExternalizer;
import org.infinispan.marshall.jboss.externalizers.MarshalledValueExternalizer;
import org.infinispan.marshall.jboss.externalizers.ReplicableCommandExternalizer;
import org.infinispan.marshall.jboss.externalizers.RequestIgnoredResponseExternalizer;
import org.infinispan.marshall.jboss.externalizers.SetExternalizer;
import org.infinispan.marshall.jboss.externalizers.SingletonListExternalizer;
import org.infinispan.marshall.jboss.externalizers.StateTransferControlCommandExternalizer;
import org.infinispan.marshall.jboss.externalizers.SuccessfulResponseExternalizer;
import org.infinispan.marshall.jboss.externalizers.TransactionLogExternalizer;
import org.infinispan.marshall.jboss.externalizers.UnsuccessfulResponseExternalizer;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.ExtendedResponse;
import org.infinispan.remoting.responses.RequestIgnoredResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.transaction.GlobalTransaction;
import org.infinispan.util.FastCopyHashMap;
import org.infinispan.util.Util;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Externalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ExternalizerClassFactory
implements ClassExternalizerFactory {
    private static final Map<String, String> EXTERNALIZERS = new HashMap<String, String>();
    private final Map<Class<?>, Externalizer> externalizers = new WeakHashMap();
    private final RpcManager rpcManager;
    private final CustomObjectTable objectTable;

    public ExternalizerClassFactory(RpcManager rpcManager, CustomObjectTable objectTable) {
        this.rpcManager = rpcManager;
        this.objectTable = objectTable;
    }

    public void init() {
        try {
            for (Map.Entry<String, String> entry : EXTERNALIZERS.entrySet()) {
                Class typeClazz = Util.loadClass(entry.getKey());
                Externalizer ext = (Externalizer)Util.getInstance(entry.getValue());
                if (ext instanceof StateTransferControlCommandExternalizer) {
                    ((StateTransferControlCommandExternalizer)ext).init(this.rpcManager);
                }
                this.externalizers.put(typeClazz, ext);
                this.objectTable.add(ext);
            }
        }
        catch (IOException e) {
            throw new CacheException("Unable to open load magicnumbers.properties", e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Unable to load one of the classes defined in the magicnumbers.properties", e);
        }
        catch (Exception e) {
            throw new CacheException("Unable to instantiate Externalizer class", e);
        }
    }

    public void stop() {
        this.externalizers.clear();
    }

    public Externalizer getExternalizer(Class<?> clazz) {
        return this.externalizers.get(clazz);
    }

    static {
        EXTERNALIZERS.put(GlobalTransaction.class.getName(), GlobalTransactionExternalizer.class.getName());
        EXTERNALIZERS.put(JGroupsAddress.class.getName(), JGroupsAddressExternalizer.class.getName());
        EXTERNALIZERS.put(ArrayList.class.getName(), ArrayListExternalizer.class.getName());
        EXTERNALIZERS.put(LinkedList.class.getName(), LinkedListExternalizer.class.getName());
        EXTERNALIZERS.put(HashMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put(TreeMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put(HashSet.class.getName(), SetExternalizer.class.getName());
        EXTERNALIZERS.put(TreeSet.class.getName(), SetExternalizer.class.getName());
        EXTERNALIZERS.put("org.infinispan.util.Immutables$ImmutableMapWrapper", ImmutableMapExternalizer.class.getName());
        EXTERNALIZERS.put(MarshalledValue.class.getName(), MarshalledValueExternalizer.class.getName());
        EXTERNALIZERS.put(FastCopyHashMap.class.getName(), MapExternalizer.class.getName());
        EXTERNALIZERS.put("java.util.Collections$SingletonList", SingletonListExternalizer.class.getName());
        EXTERNALIZERS.put("org.infinispan.transaction.TransactionLog$LogEntry", TransactionLogExternalizer.class.getName());
        EXTERNALIZERS.put(ExtendedResponse.class.getName(), ExtendedResponseExternalizer.class.getName());
        EXTERNALIZERS.put(RequestIgnoredResponse.class.getName(), RequestIgnoredResponseExternalizer.class.getName());
        EXTERNALIZERS.put(SuccessfulResponse.class.getName(), SuccessfulResponseExternalizer.class.getName());
        EXTERNALIZERS.put(UnsuccessfulResponse.class.getName(), UnsuccessfulResponseExternalizer.class.getName());
        EXTERNALIZERS.put(ExceptionResponse.class.getName(), ExceptionResponseExternalizer.class.getName());
        EXTERNALIZERS.put(AtomicHashMap.class.getName(), DeltaAwareExternalizer.class.getName());
        EXTERNALIZERS.put(StateTransferControlCommand.class.getName(), StateTransferControlCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ClusteredGetCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(MultipleRpcCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(SingleRpcCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(GetKeyValueCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PutKeyValueCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(RemoveCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(InvalidateCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ReplaceCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ClearCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PutMapCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(PrepareCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(CommitCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(RollbackCommand.class.getName(), ReplicableCommandExternalizer.class.getName());
        EXTERNALIZERS.put(ImmortalCacheEntry.class.getName(), InternalCachedEntryExternalizer.class.getName());
        EXTERNALIZERS.put(MortalCacheEntry.class.getName(), InternalCachedEntryExternalizer.class.getName());
        EXTERNALIZERS.put(TransientCacheEntry.class.getName(), InternalCachedEntryExternalizer.class.getName());
        EXTERNALIZERS.put(TransientMortalCacheEntry.class.getName(), InternalCachedEntryExternalizer.class.getName());
    }
}

