/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jcip.annotations.Immutable;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.util.Util;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.Externalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ReplicableCommandExternalizer
implements Externalizer {
    private static final long serialVersionUID = 6915200269446867084L;

    public void writeExternal(Object subject, ObjectOutput output) throws IOException {
        ReplicableCommand command = (ReplicableCommand)subject;
        output.writeShort(command.getCommandId());
        Object[] args = command.getParameters();
        int numArgs = args == null ? 0 : args.length;
        output.writeByte(numArgs);
        for (int i = 0; i < numArgs; ++i) {
            output.writeObject(args[i]);
        }
    }

    public Object createExternal(Class<?> subjectType, ObjectInput input, Creator defaultCreator) throws IOException, ClassNotFoundException {
        try {
            ReplicableCommand command = (ReplicableCommand)Util.getInstance(subjectType);
            return command;
        }
        catch (Exception e) {
            throw new CacheException("Unable to create new instance of ReplicableCommand", e);
        }
    }

    public void readExternal(Object subject, ObjectInput input) throws IOException, ClassNotFoundException {
        ReplicableCommand command = (ReplicableCommand)subject;
        short methodId = input.readShort();
        int numArgs = input.readByte();
        Object[] args = null;
        if (numArgs > 0) {
            args = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                args[i] = input.readObject();
            }
        }
        command.setParameters(methodId, args);
    }
}

