/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.text.NumberFormat;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.marshall.Marshaller;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.ResponseFilter;
import org.infinispan.remoting.ResponseMode;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="RpcManager")
public class RpcManagerImpl
implements RpcManager {
    Transport t;
    private final AtomicLong replicationCount = new AtomicLong(0L);
    private final AtomicLong replicationFailures = new AtomicLong(0L);
    boolean statisticsEnabled = false;
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    private volatile Address currentStateTransferSource;

    @Inject
    public void injectDependencies(GlobalConfiguration globalConfiguration, Transport t, InboundInvocationHandler handler, Marshaller marshaller, @ComponentName(value="org.infinispan.executors.serialization") ExecutorService e, CacheManagerNotifier notifier) {
        this.t = t;
        this.t.initialize(globalConfiguration, globalConfiguration.getTransportProperties(), marshaller, e, handler, notifier, globalConfiguration.getDistributedSyncTimeout());
    }

    @Override
    @Start(priority=10)
    public void start() {
        this.t.start();
    }

    @Override
    @Stop
    public void stop() {
        this.t.stop();
    }

    @Override
    public List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean stateTransferEnabled) throws Exception {
        try {
            List<Response> result = this.t.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter, stateTransferEnabled);
            if (this.isStatisticsEnabled()) {
                this.replicationCount.incrementAndGet();
            }
            return result;
        }
        catch (Throwable e) {
            if (this.isStatisticsEnabled()) {
                this.replicationFailures.incrementAndGet();
            }
            throw new CacheException(e);
        }
    }

    @Override
    public List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, boolean stateTransferEnabled) throws Exception {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, null, stateTransferEnabled);
    }

    @Override
    public List<Response> invokeRemotely(List<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean stateTransferEnabled) throws Exception {
        return this.invokeRemotely(recipients, rpcCommand, mode, timeout, false, null, stateTransferEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieveState(String cacheName, long timeout) throws StateTransferException {
        if (this.t.isSupportStateTransfer()) {
            Random r = new Random();
            int initialWaitTime = (r.nextInt(10) + 1) * 100;
            int waitTimeIncreaseFactor = 2;
            int numRetries = 5;
            List<Address> members = this.t.getMembers();
            if (members.size() < 2) {
                if (log.isDebugEnabled()) {
                    log.debug("We're the only member in the cluster; no one to retrieve state from. Not doing anything!");
                }
                return;
            }
            boolean success = false;
            try {
                int wait = initialWaitTime;
                block8: for (int i = 0; i < numRetries; ++i) {
                    for (Address member : members) {
                        Object var16_15;
                        if (member.equals(this.t.getAddress())) continue;
                        try {
                            try {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)"Trying to fetch state from {0}", member);
                                }
                                this.currentStateTransferSource = member;
                                if (this.t.retrieveState(cacheName, member, timeout)) {
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)"Successfully retrieved and applied state from {0}", member);
                                    }
                                    success = true;
                                    var16_15 = null;
                                    this.currentStateTransferSource = null;
                                    break block8;
                                }
                                var16_15 = null;
                                this.currentStateTransferSource = null;
                            }
                            catch (StateTransferException e) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Error while fetching state from member " + member), e);
                                }
                                var16_15 = null;
                                this.currentStateTransferSource = null;
                            }
                        }
                        catch (Throwable throwable) {
                            var16_15 = null;
                            this.currentStateTransferSource = null;
                            throw throwable;
                        }
                    }
                    if (success) continue;
                    if (log.isWarnEnabled()) {
                        log.warn("Could not find available peer for state, backing off and retrying");
                    }
                    try {
                        Thread.sleep(wait *= waitTimeIncreaseFactor);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Object var18_17 = null;
                this.currentStateTransferSource = null;
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                this.currentStateTransferSource = null;
                throw throwable;
            }
            if (!success) {
                throw new StateTransferException("Unable to fetch state on startup");
            }
        } else {
            throw new StateTransferException("Transport does not, or is not configured to, support state transfer.  Please disable fetching state on startup, or reconfigure your transport.");
        }
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    @Override
    public Address getCurrentStateTransferSource() {
        return this.currentStateTransferSource;
    }

    @Override
    public Address getLocalAddress() {
        if (this.t == null) {
            return null;
        }
        return this.t.getAddress();
    }

    @ManagedOperation
    public void resetStatistics() {
        this.replicationCount.set(0L);
        this.replicationFailures.set(0L);
    }

    @ManagedAttribute(description="number of successful replications")
    public String getReplicationCount() {
        if (!this.isStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.replicationCount.get());
    }

    @ManagedAttribute(description="number of failed replications")
    public String getReplicationFailures() {
        if (!this.isStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.replicationFailures.get());
    }

    @ManagedAttribute(description="whether or not jmx statistics are enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute
    public String getAddress() {
        if (this.t == null || !this.isStatisticsEnabled()) {
            return "N/A";
        }
        Address address = this.t.getAddress();
        return address == null ? "N/A" : address.toString();
    }

    @ManagedAttribute
    public String getMembers() {
        if (this.t == null || !this.isStatisticsEnabled()) {
            return "N/A";
        }
        List<Address> addressList = this.t.getMembers();
        return addressList.toString();
    }

    @ManagedAttribute
    public String getSuccessRatio() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double totalCount = this.replicationCount.get() + this.replicationFailures.get();
        double ration = (double)this.replicationCount.get() / totalCount * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    public void setTransport(Transport t) {
        this.t = t;
    }
}

