/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.TransactionContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.context.ContextFactory;
import org.infinispan.logging.Log;
import org.infinispan.logging.LogFactory;
import org.infinispan.remoting.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.GlobalTransaction;

@NonVolatile
public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final Map<Transaction, TransactionContext> txMapping = new ConcurrentHashMap<Transaction, TransactionContext>();
    protected final Map<GlobalTransaction, TransactionContext> gtxMapping = new ConcurrentHashMap<GlobalTransaction, TransactionContext>();
    private TransactionManager transactionManager = null;
    private RpcManager rpcManager;
    private Transport transport;
    private ContextFactory contextFactory;

    @Inject
    public void initialize(TransactionManager transactionManager, RpcManager rpcManager, ContextFactory contextFactory) {
        this.transactionManager = transactionManager;
        this.rpcManager = rpcManager;
        this.contextFactory = contextFactory;
    }

    @Start(priority=12)
    public void start() {
        this.transport = this.rpcManager == null ? null : this.rpcManager.getTransport();
    }

    public int getNumLocalTransactions() {
        return this.txMapping.size();
    }

    public int getNumGlobalTransactions() {
        return this.txMapping.size();
    }

    public GlobalTransaction get(Transaction tx) {
        if (tx == null) {
            return null;
        }
        TransactionContext ctx = this.txMapping.get(tx);
        return ctx == null ? null : ctx.getGobalTransaction();
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx, boolean assertExists) {
        Transaction ltx = this.getLocalTransaction(gtx);
        if (!assertExists) {
            return ltx;
        }
        if (ltx != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found local TX=" + ltx + ", global TX=" + gtx);
            }
            return ltx;
        }
        throw new IllegalStateException(" found no local TX for global TX " + gtx);
    }

    public void associateTransaction(Transaction tx, GlobalTransaction gtx, TransactionContext ctx) {
        if (ctx.getTransaction() == null) {
            ctx.setTransaction(tx);
        }
        if (ctx.getGobalTransaction() == null) {
            ctx.setGlobalTransaction(gtx);
        }
        this.txMapping.put(tx, ctx);
        this.gtxMapping.put(gtx, ctx);
    }

    public Transaction getLocalTransaction(GlobalTransaction gtx) {
        TransactionContext ctx = this.gtxMapping.get(gtx);
        return ctx == null ? null : ctx.getTransaction();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.txMapping.size()).append(" transactions");
        return sb.toString();
    }

    public String toString(boolean printDetails) {
        if (!printDetails) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Transactions: ").append(this.txMapping.size()).append("\n");
        sb.append("mappings:\n");
        for (Map.Entry<Transaction, TransactionContext> entry : this.txMapping.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public GlobalTransaction getCurrentTransaction() {
        return this.getCurrentTransaction(true);
    }

    public GlobalTransaction getCurrentTransaction(boolean createIfNotExists) {
        Transaction tx = this.getLocalTransaction();
        if (tx == null) {
            return null;
        }
        if (!TransactionTable.isValid(tx)) {
            int status = -1;
            try {
                status = tx.getStatus();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (status != 3) {
                log.warn("status is " + status + " (not ACTIVE or PREPARING); returning null)");
            } else {
                log.trace("status is COMMITTED; returning null");
            }
            return null;
        }
        return this.getCurrentTransaction(tx, createIfNotExists);
    }

    protected Transaction getLocalTransaction() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.getTransaction();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public static boolean isValid(Transaction tx) {
        return TransactionTable.isActive(tx) || TransactionTable.isPreparing(tx);
    }

    public static void assertTransactionValid(InvocationContext ctx) {
        Transaction tx = ctx.getTransaction();
        if (!TransactionTable.isValid(tx)) {
            try {
                throw new CacheException("Invalid transaction " + tx + ", status = " + (tx == null ? null : Integer.valueOf(tx.getStatus())));
            }
            catch (SystemException e) {
                throw new CacheException("Exception trying to analyse status of transaction " + tx, e);
            }
        }
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx) {
        return this.getCurrentTransaction(tx, true);
    }

    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        GlobalTransaction gtx = this.get(tx);
        if (gtx == null && createIfNotExists) {
            TransactionContext transactionContext;
            Address addr = this.getAddress();
            gtx = GlobalTransaction.create(addr);
            if (trace) {
                log.trace("Creating new GlobalTransaction " + gtx);
            }
            try {
                transactionContext = this.contextFactory.createTransactionContext(tx);
            }
            catch (Exception e) {
                throw new CacheException("Unable to create a transaction entry!", e);
            }
            this.associateTransaction(tx, gtx, transactionContext);
            if (trace) {
                log.trace("created new GTX: " + gtx + ", local TX=" + tx);
            }
        }
        return gtx;
    }

    private Address getAddress() {
        return this.transport == null ? null : this.transport.getAddress();
    }

    public TransactionContext getTransactionContext(GlobalTransaction gtx) {
        return this.gtxMapping.get(gtx);
    }

    public void cleanup(GlobalTransaction gtx) {
        TransactionContext ctx = this.gtxMapping.remove(gtx);
        if (ctx != null) {
            this.txMapping.remove(ctx.getTransaction());
        }
    }
}

