/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.infinispan.CacheException;
import org.infinispan.config.AbstractConfigurationBean;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.Dynamic;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.OverrideConfigurationVisitor;
import org.infinispan.distribution.DefaultConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;

@SurvivesRestarts
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
public class Configuration
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 5553791890144997466L;
    @XmlTransient
    private GlobalConfiguration globalConfiguration;
    @XmlAttribute
    protected String name;
    @XmlElement
    private LockingType locking = new LockingType();
    @XmlElement
    private CacheLoaderManagerConfig loaders = new CacheLoaderManagerConfig();
    @XmlElement
    private TransactionType transaction = new TransactionType(null);
    @XmlElement
    private CustomInterceptorsType customInterceptors = new CustomInterceptorsType();
    @XmlElement
    private EvictionType eviction = new EvictionType();
    @XmlElement
    private ExpirationType expiration = new ExpirationType();
    @XmlElement
    private UnsafeType unsafe = new UnsafeType();
    @XmlElement
    private ClusteringType clustering = new ClusteringType();
    @XmlElement
    private JmxStatistics jmxStatistics = new JmxStatistics();
    @XmlElement
    private LazyDeserialization lazyDeserialization = new LazyDeserialization();
    @XmlElement
    private InvocationBatching invocationBatching = new InvocationBatching();
    @XmlElement
    private DeadlockDetectionType deadlockDetection = new DeadlockDetectionType();
    @XmlElement
    private QueryConfigurationBean indexing = new QueryConfigurationBean();

    @Start(priority=1)
    private void correctIsolationLevels() {
        switch (this.locking.isolationLevel) {
            case NONE: 
            case READ_UNCOMMITTED: {
                this.locking.isolationLevel = IsolationLevel.READ_COMMITTED;
                break;
            }
            case SERIALIZABLE: {
                this.locking.isolationLevel = IsolationLevel.REPEATABLE_READ;
            }
        }
    }

    public void applyOverrides(Configuration overrides) {
        OverrideConfigurationVisitor v1 = new OverrideConfigurationVisitor();
        this.accept(v1);
        OverrideConfigurationVisitor v2 = new OverrideConfigurationVisitor();
        overrides.accept(v2);
        v1.override(v2);
    }

    @Override
    public void inject(ComponentRegistry cr) {
        this.accept(new AbstractNamedCacheConfigurationBean.InjectComponentRegistryVisitor(cr));
    }

    @Deprecated
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public void setGlobalConfiguration(GlobalConfiguration gc) {
        this.globalConfiguration = gc;
    }

    public String getName() {
        return this.name;
    }

    @Inject
    private void injectGlobalConfiguration(GlobalConfiguration globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public boolean isStateTransferEnabled() {
        return this.clustering.stateRetrieval.fetchInMemoryState != false || this.loaders != null && this.loaders.isFetchPersistentState() != false;
    }

    public long getDeadlockDetectionSpinDuration() {
        return this.deadlockDetection.spinDuration;
    }

    public void setDeadlockDetectionSpinDuration(long eagerDeadlockSpinDuration) {
        this.deadlockDetection.setSpinDuration(eagerDeadlockSpinDuration);
    }

    public boolean isEnableDeadlockDetection() {
        return this.deadlockDetection.enabled;
    }

    public void setEnableDeadlockDetection(boolean useEagerDeadlockDetection) {
        this.deadlockDetection.setEnabled(useEagerDeadlockDetection);
    }

    public void setUseLockStriping(boolean useLockStriping) {
        this.locking.setUseLockStriping(useLockStriping);
    }

    public boolean isUseLockStriping() {
        return this.locking.useLockStriping;
    }

    public boolean isUnsafeUnreliableReturnValues() {
        return this.unsafe.unreliableReturnValues;
    }

    public void setUnsafeUnreliableReturnValues(boolean unsafeUnreliableReturnValues) {
        this.unsafe.setUnreliableReturnValues(unsafeUnreliableReturnValues);
    }

    public void setRehashRpcTimeout(long rehashRpcTimeout) {
        this.clustering.hash.setRehashRpcTimeout(rehashRpcTimeout);
    }

    public long getRehashRpcTimeout() {
        return this.clustering.hash.rehashRpcTimeout;
    }

    public boolean isWriteSkewCheck() {
        return this.locking.writeSkewCheck;
    }

    public void setWriteSkewCheck(boolean writeSkewCheck) {
        this.locking.setWriteSkewCheck(writeSkewCheck);
    }

    public int getConcurrencyLevel() {
        return this.locking.concurrencyLevel;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.locking.setConcurrencyLevel(concurrencyLevel);
    }

    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.clustering.async.setReplQueueMaxElements(replQueueMaxElements);
    }

    public void setReplQueueInterval(long replQueueInterval) {
        this.clustering.async.setReplQueueInterval(replQueueInterval);
    }

    public void setReplQueueInterval(long replQueueInterval, TimeUnit timeUnit) {
        this.setReplQueueInterval(timeUnit.toMillis(replQueueInterval));
    }

    public void setReplQueueClass(String classname) {
        this.clustering.async.setReplQueueClass(classname);
    }

    public void setExposeJmxStatistics(boolean useMbean) {
        this.jmxStatistics.setEnabled(useMbean);
    }

    public void setInvocationBatchingEnabled(boolean enabled) {
        this.invocationBatching.setEnabled(enabled);
    }

    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.clustering.stateRetrieval.setFetchInMemoryState(fetchInMemoryState);
    }

    public void setAlwaysProvideInMemoryState(boolean alwaysProvideInMemoryState) {
        this.clustering.stateRetrieval.setAlwaysProvideInMemoryState(alwaysProvideInMemoryState);
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.locking.setLockAcquisitionTimeout(lockAcquisitionTimeout);
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout, TimeUnit timeUnit) {
        this.setLockAcquisitionTimeout(timeUnit.toMillis(lockAcquisitionTimeout));
    }

    public void setSyncReplTimeout(long syncReplTimeout) {
        this.clustering.sync.setReplTimeout(syncReplTimeout);
    }

    public void setSyncReplTimeout(long syncReplTimeout, TimeUnit timeUnit) {
        this.setSyncReplTimeout(timeUnit.toMillis(syncReplTimeout));
    }

    public void setCacheMode(CacheMode cacheModeInt) {
        this.clustering.setMode(cacheModeInt);
    }

    public void setCacheMode(String cacheMode) {
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.clustering.setMode(CacheMode.valueOf(this.uc(cacheMode)));
        if (this.clustering.mode == null) {
            this.log.warn("Unknown cache mode '" + cacheMode + "', using defaults.");
            this.clustering.setMode(CacheMode.LOCAL);
        }
    }

    public String getCacheModeString() {
        return this.clustering.mode == null ? null : this.clustering.mode.toString();
    }

    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    public long getEvictionWakeUpInterval() {
        return this.eviction.wakeUpInterval;
    }

    public void setEvictionWakeUpInterval(long evictionWakeUpInterval) {
        this.eviction.setWakeUpInterval(evictionWakeUpInterval);
    }

    public EvictionStrategy getEvictionStrategy() {
        return this.eviction.strategy;
    }

    public void setEvictionStrategy(EvictionStrategy evictionStrategy) {
        this.eviction.setStrategy(evictionStrategy);
    }

    public void setEvictionStrategy(String eStrategy) {
        this.eviction.strategy = EvictionStrategy.valueOf(this.uc(eStrategy));
        if (this.eviction.strategy == null) {
            this.log.warn("Unknown evictionStrategy  '" + eStrategy + "'!  Using EvictionStrategy.NONE.");
            this.eviction.setStrategy(EvictionStrategy.NONE);
        }
    }

    public EvictionThreadPolicy getEvictionThreadPolicy() {
        return this.eviction.threadPolicy;
    }

    public void setEvictionThreadPolicy(EvictionThreadPolicy policy) {
        this.eviction.setThreadPolicy(policy);
    }

    public void setEvictionThreadPolicy(String policy) {
        this.eviction.threadPolicy = EvictionThreadPolicy.valueOf(this.uc(policy));
        if (this.eviction.threadPolicy == null) {
            this.log.warn("Unknown thread eviction policy  '" + policy + "'!  Using EvictionThreadPolicy.DEFAULT");
            this.eviction.setThreadPolicy(EvictionThreadPolicy.DEFAULT);
        }
    }

    public int getEvictionMaxEntries() {
        return this.eviction.maxEntries;
    }

    public void setEvictionMaxEntries(int evictionMaxEntries) {
        this.eviction.setMaxEntries(evictionMaxEntries);
    }

    public long getExpirationLifespan() {
        return this.expiration.lifespan;
    }

    public void setExpirationLifespan(long expirationLifespan) {
        this.expiration.setLifespan(expirationLifespan);
    }

    public long getExpirationMaxIdle() {
        return this.expiration.maxIdle;
    }

    public void setExpirationMaxIdle(long expirationMaxIdle) {
        this.expiration.setMaxIdle(expirationMaxIdle);
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.transaction.setTransactionManagerLookupClass(transactionManagerLookupClass);
    }

    public void setTransactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transaction.transactionManagerLookup = transactionManagerLookup;
    }

    public void setCacheLoaderManagerConfig(CacheLoaderManagerConfig cacheLoaderManagerConfig) {
        this.loaders = cacheLoaderManagerConfig;
    }

    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.transaction.setSyncCommitPhase(syncCommitPhase);
    }

    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.transaction.setSyncRollbackPhase(syncRollbackPhase);
    }

    public void setUseEagerLocking(boolean useEagerLocking) {
        this.transaction.setUseEagerLocking(useEagerLocking);
    }

    public void setEagerLockSingleNode(boolean eagerLockSingleNode) {
        this.transaction.setEagerLockSingleNode(eagerLockSingleNode);
    }

    public void setUseReplQueue(boolean useReplQueue) {
        this.clustering.async.setUseReplQueue(useReplQueue);
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.locking.setIsolationLevel(isolationLevel);
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.clustering.stateRetrieval.setTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout, TimeUnit timeUnit) {
        this.setStateRetrievalTimeout(timeUnit.toMillis(stateRetrievalTimeout));
    }

    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout) {
        this.clustering.stateRetrieval.setLogFlushTimeout(logFlushTimeout);
    }

    public void setStateRetrievalLogFlushTimeout(long logFlushTimeout, TimeUnit timeUnit) {
        this.clustering.stateRetrieval.setLogFlushTimeout(timeUnit.toMillis(logFlushTimeout));
    }

    public void setStateRetrievalMaxNonProgressingLogWrites(int maxNonProgressingLogWrites) {
        this.clustering.stateRetrieval.setMaxNonProgressingLogWrites(maxNonProgressingLogWrites);
    }

    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime) {
        this.clustering.stateRetrieval.setInitialRetryWaitTime(initialRetryWaitTime);
    }

    public void setStateRetrievalInitialRetryWaitTime(long initialRetryWaitTime, TimeUnit timeUnit) {
        this.setStateRetrievalInitialRetryWaitTime(timeUnit.toMillis(initialRetryWaitTime));
    }

    public void setStateRetrievalRetryWaitTimeIncreaseFactor(int retryWaitTimeIncreaseFactor) {
        this.clustering.stateRetrieval.setRetryWaitTimeIncreaseFactor(retryWaitTimeIncreaseFactor);
    }

    public void setStateRetrievalNumRetries(int numRetries) {
        this.clustering.stateRetrieval.setNumRetries(numRetries);
    }

    public void setIsolationLevel(String isolationLevel) {
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.locking.setIsolationLevel(IsolationLevel.valueOf(this.uc(isolationLevel)));
        if (this.locking.isolationLevel == null) {
            this.log.warn("Unknown isolation level '" + isolationLevel + "', using defaults.");
            this.locking.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        }
    }

    public void setUseLazyDeserialization(boolean useLazyDeserialization) {
        this.lazyDeserialization.setEnabled(useLazyDeserialization);
    }

    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.clustering.l1.setEnabled(l1CacheEnabled);
    }

    public void setL1Lifespan(long l1Lifespan) {
        this.clustering.l1.setLifespan(l1Lifespan);
    }

    public void setL1OnRehash(boolean l1OnRehash) {
        this.clustering.l1.setOnRehash(l1OnRehash);
    }

    public void setConsistentHashClass(String consistentHashClass) {
        this.clustering.hash.setConsistentHashClass(consistentHashClass);
    }

    public void setNumOwners(int numOwners) {
        this.clustering.hash.setNumOwners(numOwners);
    }

    public void setRehashEnabled(boolean rehashEnabled) {
        this.clustering.hash.setRehashEnabled(rehashEnabled);
    }

    public void setRehashWaitTime(long rehashWaitTime) {
        this.clustering.hash.setRehashWait(rehashWaitTime);
    }

    public void setUseAsyncMarshalling(boolean useAsyncMarshalling) {
        this.clustering.async.setAsyncMarshalling(useAsyncMarshalling);
    }

    public void setIndexingEnabled(boolean enabled) {
        this.indexing.setEnabled(enabled);
    }

    public void setIndexLocalOnly(boolean indexLocalOnly) {
        this.indexing.setIndexLocalOnly(indexLocalOnly);
    }

    public boolean isUseAsyncMarshalling() {
        return this.clustering.async.asyncMarshalling;
    }

    public boolean isUseReplQueue() {
        return this.clustering.async.useReplQueue;
    }

    public int getReplQueueMaxElements() {
        return this.clustering.async.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.clustering.async.replQueueInterval;
    }

    public String getReplQueueClass() {
        return this.clustering.async.replQueueClass;
    }

    public boolean isExposeJmxStatistics() {
        return this.jmxStatistics.enabled;
    }

    public boolean isInvocationBatchingEnabled() {
        return this.invocationBatching.enabled;
    }

    public boolean isIndexingEnabled() {
        return this.indexing.isEnabled();
    }

    public boolean isIndexLocalOnly() {
        return this.indexing.isIndexLocalOnly();
    }

    public boolean isFetchInMemoryState() {
        return this.clustering.stateRetrieval.fetchInMemoryState;
    }

    public boolean isAlwaysProvideInMemoryState() {
        return this.clustering.stateRetrieval.alwaysProvideInMemoryState;
    }

    public long getLockAcquisitionTimeout() {
        return this.locking.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.clustering.sync.replTimeout;
    }

    public CacheMode getCacheMode() {
        return this.clustering.mode;
    }

    public IsolationLevel getIsolationLevel() {
        return this.locking.isolationLevel;
    }

    public String getTransactionManagerLookupClass() {
        return this.transaction.transactionManagerLookupClass;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transaction.transactionManagerLookup;
    }

    public CacheLoaderManagerConfig getCacheLoaderManagerConfig() {
        return this.loaders;
    }

    public boolean isSyncCommitPhase() {
        return this.transaction.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.transaction.syncRollbackPhase;
    }

    public boolean isUseEagerLocking() {
        return this.transaction.useEagerLocking;
    }

    public boolean isEagerLockSingleNode() {
        return this.transaction.eagerLockSingleNode;
    }

    public long getStateRetrievalTimeout() {
        return this.clustering.stateRetrieval.timeout;
    }

    public long getStateRetrievalInitialRetryWaitTime() {
        return this.clustering.stateRetrieval.initialRetryWaitTime;
    }

    public int getStateRetrievalRetryWaitTimeIncreaseFactor() {
        return this.clustering.stateRetrieval.retryWaitTimeIncreaseFactor;
    }

    public int getStateRetrievalNumRetries() {
        return this.clustering.stateRetrieval.numRetries;
    }

    public int getStateRetrievalMaxNonProgressingLogWrites() {
        return this.clustering.stateRetrieval.maxNonProgressingLogWrites;
    }

    public long getStateRetrievalLogFlushTimeout() {
        return this.clustering.stateRetrieval.logFlushTimeout;
    }

    public boolean isUseLazyDeserialization() {
        return this.lazyDeserialization.enabled;
    }

    public boolean isL1CacheEnabled() {
        return this.clustering.l1.enabled;
    }

    public long getL1Lifespan() {
        return this.clustering.l1.lifespan;
    }

    public boolean isL1OnRehash() {
        return this.clustering.l1.onRehash;
    }

    public String getConsistentHashClass() {
        return this.clustering.hash.consistentHashClass;
    }

    public int getNumOwners() {
        return this.clustering.hash.numOwners;
    }

    public boolean isRehashEnabled() {
        return this.clustering.hash.rehashEnabled;
    }

    public long getRehashWaitTime() {
        return this.clustering.hash.rehashWait;
    }

    public void accept(ConfigurationBeanVisitor v) {
        this.clustering.accept(v);
        this.customInterceptors.accept(v);
        this.deadlockDetection.accept(v);
        this.eviction.accept(v);
        this.expiration.accept(v);
        this.invocationBatching.accept(v);
        this.jmxStatistics.accept(v);
        this.lazyDeserialization.accept(v);
        this.loaders.accept(v);
        this.locking.accept(v);
        this.transaction.accept(v);
        this.unsafe.accept(v);
        this.indexing.accept(v);
        v.visitConfiguration(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.clustering != null ? !this.clustering.equals(that.clustering) : that.clustering != null) {
            return false;
        }
        if (this.customInterceptors != null ? !this.customInterceptors.equals(that.customInterceptors) : that.customInterceptors != null) {
            return false;
        }
        if (this.deadlockDetection != null ? !this.deadlockDetection.equals(that.deadlockDetection) : that.deadlockDetection != null) {
            return false;
        }
        if (this.eviction != null ? !this.eviction.equals(that.eviction) : that.eviction != null) {
            return false;
        }
        if (this.expiration != null ? !this.expiration.equals(that.expiration) : that.expiration != null) {
            return false;
        }
        if (this.globalConfiguration != null ? !this.globalConfiguration.equals(that.globalConfiguration) : that.globalConfiguration != null) {
            return false;
        }
        if (this.invocationBatching != null ? !this.invocationBatching.equals(that.invocationBatching) : that.invocationBatching != null) {
            return false;
        }
        if (this.jmxStatistics != null ? !this.jmxStatistics.equals(that.jmxStatistics) : that.jmxStatistics != null) {
            return false;
        }
        if (this.lazyDeserialization != null ? !this.lazyDeserialization.equals(that.lazyDeserialization) : that.lazyDeserialization != null) {
            return false;
        }
        if (this.loaders != null ? !this.loaders.equals(that.loaders) : that.loaders != null) {
            return false;
        }
        if (this.locking != null ? !this.locking.equals(that.locking) : that.locking != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.transaction != null ? !this.transaction.equals(that.transaction) : that.transaction != null) {
            return false;
        }
        return !(this.unsafe != null ? !this.unsafe.equals(that.unsafe) : that.unsafe != null);
    }

    public int hashCode() {
        int result = this.globalConfiguration != null ? this.globalConfiguration.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.locking != null ? this.locking.hashCode() : 0);
        result = 31 * result + (this.loaders != null ? this.loaders.hashCode() : 0);
        result = 31 * result + (this.transaction != null ? this.transaction.hashCode() : 0);
        result = 31 * result + (this.customInterceptors != null ? this.customInterceptors.hashCode() : 0);
        result = 31 * result + (this.eviction != null ? this.eviction.hashCode() : 0);
        result = 31 * result + (this.expiration != null ? this.expiration.hashCode() : 0);
        result = 31 * result + (this.unsafe != null ? this.unsafe.hashCode() : 0);
        result = 31 * result + (this.clustering != null ? this.clustering.hashCode() : 0);
        result = 31 * result + (this.jmxStatistics != null ? this.jmxStatistics.hashCode() : 0);
        result = 31 * result + (this.lazyDeserialization != null ? this.lazyDeserialization.hashCode() : 0);
        result = 31 * result + (this.invocationBatching != null ? this.invocationBatching.hashCode() : 0);
        result = 31 * result + (this.deadlockDetection != null ? this.deadlockDetection.hashCode() : 0);
        return result;
    }

    @Override
    public Configuration clone() {
        try {
            Configuration dolly = (Configuration)super.clone();
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
            }
            if (this.globalConfiguration != null) {
                dolly.globalConfiguration = this.globalConfiguration.clone();
            }
            if (this.locking != null) {
                dolly.locking = (LockingType)this.locking.clone();
            }
            if (this.loaders != null) {
                dolly.loaders = this.loaders.clone();
            }
            if (this.transaction != null) {
                dolly.transaction = (TransactionType)this.transaction.clone();
            }
            if (this.customInterceptors != null) {
                dolly.customInterceptors = this.customInterceptors.clone();
            }
            if (this.eviction != null) {
                dolly.eviction = (EvictionType)this.eviction.clone();
            }
            if (this.expiration != null) {
                dolly.expiration = (ExpirationType)this.expiration.clone();
            }
            if (this.unsafe != null) {
                dolly.unsafe = (UnsafeType)this.unsafe.clone();
            }
            if (this.clustering != null) {
                dolly.clustering = this.clustering.clone();
            }
            if (this.jmxStatistics != null) {
                dolly.jmxStatistics = (JmxStatistics)this.jmxStatistics.clone();
            }
            if (this.lazyDeserialization != null) {
                dolly.lazyDeserialization = (LazyDeserialization)this.lazyDeserialization.clone();
            }
            if (this.invocationBatching != null) {
                dolly.invocationBatching = (InvocationBatching)this.invocationBatching.clone();
            }
            if (this.deadlockDetection != null) {
                dolly.deadlockDetection = (DeadlockDetectionType)this.deadlockDetection.clone();
            }
            if (this.indexing != null) {
                dolly.indexing = this.indexing.clone();
            }
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Unexpected!", e);
        }
    }

    public boolean isUsingCacheLoaders() {
        return this.getCacheLoaderManagerConfig() != null && !this.getCacheLoaderManagerConfig().getCacheLoaderConfigs().isEmpty();
    }

    public List<CustomInterceptorConfig> getCustomInterceptors() {
        return this.customInterceptors.customInterceptors == null ? Collections.EMPTY_LIST : this.customInterceptors.customInterceptors;
    }

    public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
        this.customInterceptors.setCustomInterceptors(customInterceptors);
    }

    public void assertValid() throws ConfigurationException {
        if (this.clustering.mode.isDistributed() && this.clustering.stateRetrieval.fetchInMemoryState.booleanValue()) {
            throw new ConfigurationException("Cache cannot use DISTRIBUTION mode and have fetchInMemoryState set to true.  Perhaps you meant to enable rehashing?");
        }
        if (this.clustering.mode.isClustered() && (this.globalConfiguration.getTransportClass() == null || this.globalConfiguration.getTransportClass().length() == 0)) {
            throw new ConfigurationException("Cache cannot use a clustered mode (" + (Object)((Object)this.clustering.mode) + ") mode and not define a transport!");
        }
    }

    public boolean isOnePhaseCommit() {
        return !this.getCacheMode().isSynchronous();
    }

    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC,
        DIST_SYNC,
        DIST_ASYNC;


        public boolean isInvalidation() {
            return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
        }

        public boolean isSynchronous() {
            return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == LOCAL;
        }

        public boolean isClustered() {
            return this != LOCAL;
        }

        public boolean isDistributed() {
            return this == DIST_SYNC || this == DIST_ASYNC;
        }

        public boolean isReplicated() {
            return this == REPL_SYNC || this == REPL_ASYNC;
        }

        public CacheMode toSync() {
            switch (this) {
                case REPL_ASYNC: {
                    return REPL_SYNC;
                }
                case INVALIDATION_ASYNC: {
                    return INVALIDATION_SYNC;
                }
                case DIST_ASYNC: {
                    return DIST_SYNC;
                }
            }
            return this;
        }

        public CacheMode toAsync() {
            switch (this) {
                case REPL_SYNC: {
                    return REPL_ASYNC;
                }
                case INVALIDATION_SYNC: {
                    return INVALIDATION_ASYNC;
                }
                case DIST_SYNC: {
                    return DIST_ASYNC;
                }
            }
            return this;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class QueryConfigurationBean
    extends AbstractConfigurationBean {
        private static final long serialVersionUID = 2891683014353342549L;
        protected Boolean enabled = false;
        protected Boolean indexLocalOnly = false;

        public Boolean isEnabled() {
            return this.enabled;
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public Boolean isIndexLocalOnly() {
            return this.indexLocalOnly;
        }

        @XmlAttribute
        public void setIndexLocalOnly(Boolean indexLocalOnly) {
            this.testImmutability("indexLocalOnly");
            this.indexLocalOnly = indexLocalOnly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitQueryConfigurationBean(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QueryConfigurationBean)) {
                return false;
            }
            QueryConfigurationBean that = (QueryConfigurationBean)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            return !(this.indexLocalOnly != null ? !this.indexLocalOnly.equals(that.indexLocalOnly) : that.indexLocalOnly != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.indexLocalOnly != null ? this.indexLocalOnly.hashCode() : 0);
            return result;
        }

        @Override
        protected boolean hasComponentStarted() {
            return false;
        }

        @Override
        public QueryConfigurationBean clone() {
            try {
                QueryConfigurationBean dolly = (QueryConfigurationBean)super.clone();
                dolly.enabled = this.enabled;
                dolly.indexLocalOnly = this.indexLocalOnly;
                return dolly;
            }
            catch (CloneNotSupportedException shouldNotHappen) {
                throw new RuntimeException("Should not happen!", shouldNotHappen);
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CustomInterceptorsType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 7187545782011884661L;
        @XmlElement(name="interceptor")
        private List<CustomInterceptorConfig> customInterceptors = new ArrayList<CustomInterceptorConfig>();

        @Override
        public CustomInterceptorsType clone() throws CloneNotSupportedException {
            CustomInterceptorsType dolly = (CustomInterceptorsType)super.clone();
            if (this.customInterceptors != null) {
                dolly.customInterceptors = new ArrayList<CustomInterceptorConfig>();
                for (CustomInterceptorConfig config : this.customInterceptors) {
                    CustomInterceptorConfig clone = config.clone();
                    dolly.customInterceptors.add(clone);
                }
            }
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            for (CustomInterceptorConfig i : this.customInterceptors) {
                i.accept(v);
            }
            v.visitCustomInterceptorsType(this);
        }

        public List<CustomInterceptorConfig> getCustomInterceptors() {
            return this.customInterceptors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomInterceptorsType)) {
                return false;
            }
            CustomInterceptorsType that = (CustomInterceptorsType)o;
            return !(this.customInterceptors != null ? !((Object)this.customInterceptors).equals(that.customInterceptors) : that.customInterceptors != null);
        }

        public int hashCode() {
            return this.customInterceptors != null ? ((Object)this.customInterceptors).hashCode() : 0;
        }

        public void setCustomInterceptors(List<CustomInterceptorConfig> customInterceptors) {
            this.testImmutability("customInterceptors");
            this.customInterceptors = customInterceptors;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class UnsafeType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -9200921443651234163L;
        protected Boolean unreliableReturnValues = false;

        @XmlAttribute
        public void setUnreliableReturnValues(Boolean unreliableReturnValues) {
            this.testImmutability("unreliableReturnValues");
            this.unreliableReturnValues = unreliableReturnValues;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitUnsafeType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnsafeType)) {
                return false;
            }
            UnsafeType that = (UnsafeType)o;
            return !(this.unreliableReturnValues != null ? !this.unreliableReturnValues.equals(that.unreliableReturnValues) : that.unreliableReturnValues != null);
        }

        public int hashCode() {
            return this.unreliableReturnValues != null ? this.unreliableReturnValues.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class DeadlockDetectionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -7178286048602531152L;
        protected Boolean enabled = false;
        protected Long spinDuration = 100L;

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitDeadlockDetectionType(this);
        }

        @XmlAttribute
        public void setSpinDuration(Long spinDuration) {
            this.testImmutability("spinDuration");
            this.spinDuration = spinDuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeadlockDetectionType)) {
                return false;
            }
            DeadlockDetectionType that = (DeadlockDetectionType)o;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
                return false;
            }
            return !(this.spinDuration != null ? !this.spinDuration.equals(that.spinDuration) : that.spinDuration != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.spinDuration != null ? this.spinDuration.hashCode() : 0);
            return result;
        }
    }

    public static class InvocationBatching
    extends BooleanAttributeType {
        private static final long serialVersionUID = 5854115656815587815L;

        public InvocationBatching() {
            super("invocationBatching");
        }
    }

    public static class JmxStatistics
    extends BooleanAttributeType {
        private static final long serialVersionUID = 8716456707015486673L;

        public JmxStatistics() {
            super("jmxStatistics");
        }
    }

    public static class LazyDeserialization
    extends BooleanAttributeType {
        private static final long serialVersionUID = 7404820498857564962L;

        public LazyDeserialization() {
            super("lazyDeserialization");
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class BooleanAttributeType
    extends AbstractNamedCacheConfigurationBean {
        @XmlTransient
        protected final String fieldName;
        private static final long serialVersionUID = 2296863404153834686L;
        protected Boolean enabled = false;

        public BooleanAttributeType() {
            this.fieldName = "undefined";
        }

        public BooleanAttributeType(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitBooleanAttributeType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanAttributeType)) {
                return false;
            }
            BooleanAttributeType that = (BooleanAttributeType)o;
            return !(this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null);
        }

        public int hashCode() {
            return this.enabled != null ? this.enabled.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class L1Type
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -4703587764861110638L;
        protected Boolean enabled = true;
        protected Long lifespan = 600000L;
        protected Boolean onRehash = true;

        @XmlAttribute
        public void setEnabled(Boolean enabled) {
            this.testImmutability("enabled");
            this.enabled = enabled;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitL1Type(this);
        }

        @XmlAttribute
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        @XmlAttribute
        public void setOnRehash(Boolean onRehash) {
            this.testImmutability("onRehash");
            this.onRehash = onRehash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof L1Type)) {
                return false;
            }
            L1Type l1Type = (L1Type)o;
            if (this.enabled != null ? !this.enabled.equals(l1Type.enabled) : l1Type.enabled != null) {
                return false;
            }
            if (this.lifespan != null ? !this.lifespan.equals(l1Type.lifespan) : l1Type.lifespan != null) {
                return false;
            }
            return !(this.onRehash != null ? !this.onRehash.equals(l1Type.onRehash) : l1Type.onRehash != null);
        }

        public int hashCode() {
            int result = this.enabled != null ? this.enabled.hashCode() : 0;
            result = 31 * result + (this.lifespan != null ? this.lifespan.hashCode() : 0);
            result = 31 * result + (this.onRehash != null ? this.onRehash.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class HashType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 752218766840948822L;
        protected String consistentHashClass = DefaultConsistentHash.class.getName();
        protected Integer numOwners = 2;
        protected Long rehashWait = TimeUnit.MINUTES.toMillis(1L);
        protected Long rehashRpcTimeout = TimeUnit.MINUTES.toMillis(10L);
        protected Boolean rehashEnabled = true;

        @XmlAttribute(name="class")
        public void setConsistentHashClass(String consistentHashClass) {
            this.testImmutability("consistentHashClass");
            this.consistentHashClass = consistentHashClass;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitHashType(this);
        }

        @XmlAttribute
        public void setNumOwners(Integer numOwners) {
            this.testImmutability("numOwners");
            this.numOwners = numOwners;
        }

        @XmlAttribute
        public void setRehashWait(Long rehashWaitTime) {
            this.testImmutability("rehashWait");
            this.rehashWait = rehashWaitTime;
        }

        @XmlAttribute
        public void setRehashRpcTimeout(Long rehashRpcTimeout) {
            this.testImmutability("rehashRpcTimeout");
            this.rehashRpcTimeout = rehashRpcTimeout;
        }

        @XmlAttribute
        public void setRehashEnabled(Boolean rehashEnabled) {
            this.testImmutability("rehashEnabled");
            this.rehashEnabled = rehashEnabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashType)) {
                return false;
            }
            HashType hashType = (HashType)o;
            if (this.consistentHashClass != null ? !this.consistentHashClass.equals(hashType.consistentHashClass) : hashType.consistentHashClass != null) {
                return false;
            }
            if (this.numOwners != null ? !this.numOwners.equals(hashType.numOwners) : hashType.numOwners != null) {
                return false;
            }
            if (this.rehashRpcTimeout != null ? !this.rehashRpcTimeout.equals(hashType.rehashRpcTimeout) : hashType.rehashRpcTimeout != null) {
                return false;
            }
            if (this.rehashWait != null ? !this.rehashWait.equals(hashType.rehashWait) : hashType.rehashWait != null) {
                return false;
            }
            return this.rehashEnabled == hashType.rehashEnabled;
        }

        public int hashCode() {
            int result = this.consistentHashClass != null ? this.consistentHashClass.hashCode() : 0;
            result = 31 * result + (this.numOwners != null ? this.numOwners.hashCode() : 0);
            result = 31 * result + (this.rehashWait != null ? this.rehashWait.hashCode() : 0);
            result = 31 * result + (this.rehashRpcTimeout != null ? this.rehashRpcTimeout.hashCode() : 0);
            result = 31 * result + (this.rehashEnabled != false ? 0 : 1);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class SyncType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 8419216253674289524L;
        @Dynamic
        protected Long replTimeout = 15000L;

        @XmlAttribute
        public void setReplTimeout(Long replTimeout) {
            this.testImmutability("replTimeout");
            this.replTimeout = replTimeout;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitSyncType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SyncType)) {
                return false;
            }
            SyncType syncType = (SyncType)o;
            return !(this.replTimeout != null ? !this.replTimeout.equals(syncType.replTimeout) : syncType.replTimeout != null);
        }

        public int hashCode() {
            return this.replTimeout != null ? this.replTimeout.hashCode() : 0;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class StateRetrievalType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 3709234918426217096L;
        @Dynamic
        protected Boolean fetchInMemoryState = false;
        protected Boolean alwaysProvideInMemoryState = false;
        @Dynamic
        protected Long timeout = 10000L;
        protected Long initialRetryWaitTime = 500L;
        protected Integer retryWaitTimeIncreaseFactor = 2;
        protected Integer numRetries = 5;
        protected Long logFlushTimeout = 60000L;
        protected Integer maxNonProgressingLogWrites = 100;

        @XmlAttribute
        public void setFetchInMemoryState(Boolean fetchInMemoryState) {
            this.testImmutability("fetchInMemoryState");
            this.fetchInMemoryState = fetchInMemoryState;
        }

        @XmlAttribute
        public void setAlwaysProvideInMemoryState(Boolean alwaysProvideInMemoryState) {
            this.testImmutability("alwaysProvideInMemoryState");
            this.alwaysProvideInMemoryState = alwaysProvideInMemoryState;
        }

        @XmlAttribute
        public void setInitialRetryWaitTime(Long initialRetryWaitTime) {
            this.testImmutability("initialWaitTime");
            this.initialRetryWaitTime = initialRetryWaitTime;
        }

        @XmlAttribute
        public void setRetryWaitTimeIncreaseFactor(Integer retryWaitTimeIncreaseFactor) {
            this.testImmutability("retryWaitTimeIncreaseFactor");
            this.retryWaitTimeIncreaseFactor = retryWaitTimeIncreaseFactor;
        }

        @XmlAttribute
        public void setNumRetries(Integer numRetries) {
            this.testImmutability("numRetries");
            this.numRetries = numRetries;
        }

        @XmlAttribute
        public void setTimeout(Long timeout) {
            this.testImmutability("timeout");
            this.timeout = timeout;
        }

        @XmlAttribute
        public void setLogFlushTimeout(Long logFlushTimeout) {
            this.testImmutability("logFlushTimeout");
            this.logFlushTimeout = logFlushTimeout;
        }

        @XmlAttribute
        public void setMaxNonProgressingLogWrites(Integer maxNonProgressingLogWrites) {
            this.testImmutability("maxNonProgressingLogWrites");
            this.maxNonProgressingLogWrites = maxNonProgressingLogWrites;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitStateRetrievalType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateRetrievalType)) {
                return false;
            }
            StateRetrievalType that = (StateRetrievalType)o;
            if (this.fetchInMemoryState != null ? !this.fetchInMemoryState.equals(that.fetchInMemoryState) : that.fetchInMemoryState != null) {
                return false;
            }
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) {
                return false;
            }
            if (this.initialRetryWaitTime != null ? !this.initialRetryWaitTime.equals(that.initialRetryWaitTime) : that.initialRetryWaitTime != null) {
                return false;
            }
            if (this.retryWaitTimeIncreaseFactor != null ? !this.retryWaitTimeIncreaseFactor.equals(that.retryWaitTimeIncreaseFactor) : that.retryWaitTimeIncreaseFactor != null) {
                return false;
            }
            return !(this.numRetries != null ? !this.numRetries.equals(that.numRetries) : that.numRetries != null);
        }

        public int hashCode() {
            int result = this.fetchInMemoryState != null ? this.fetchInMemoryState.hashCode() : 0;
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.initialRetryWaitTime != null ? this.initialRetryWaitTime.hashCode() : 0);
            result = 31 * result + (this.retryWaitTimeIncreaseFactor != null ? this.retryWaitTimeIncreaseFactor.hashCode() : 0);
            result = 31 * result + (this.numRetries != null ? this.numRetries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EvictionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -1248563712058858791L;
        protected Long wakeUpInterval = 5000L;
        protected EvictionStrategy strategy = EvictionStrategy.NONE;
        protected Integer maxEntries = -1;
        protected EvictionThreadPolicy threadPolicy = EvictionThreadPolicy.DEFAULT;

        @XmlAttribute
        public void setWakeUpInterval(Long wakeUpInterval) {
            this.testImmutability("wakeUpInterval");
            this.wakeUpInterval = wakeUpInterval;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitEvictionType(this);
        }

        @XmlAttribute
        public void setStrategy(EvictionStrategy strategy) {
            this.testImmutability("strategy");
            this.strategy = strategy;
        }

        @XmlAttribute
        public void setThreadPolicy(EvictionThreadPolicy threadPolicy) {
            this.testImmutability("threadPolicy");
            this.threadPolicy = threadPolicy;
        }

        @XmlAttribute
        public void setMaxEntries(Integer maxEntries) {
            this.testImmutability("maxEntries");
            this.maxEntries = maxEntries;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EvictionType)) {
                return false;
            }
            EvictionType that = (EvictionType)o;
            if (this.maxEntries != null ? !this.maxEntries.equals(that.maxEntries) : that.maxEntries != null) {
                return false;
            }
            if (this.strategy != that.strategy) {
                return false;
            }
            if (this.threadPolicy != that.threadPolicy) {
                return false;
            }
            return !(this.wakeUpInterval != null ? !this.wakeUpInterval.equals(that.wakeUpInterval) : that.wakeUpInterval != null);
        }

        public int hashCode() {
            int result = this.wakeUpInterval != null ? this.wakeUpInterval.hashCode() : 0;
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            result = 31 * result + (this.threadPolicy != null ? this.threadPolicy.hashCode() : 0);
            result = 31 * result + (this.maxEntries != null ? this.maxEntries.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class ExpirationType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 5757161438110848530L;
        protected Long lifespan = -1L;
        protected Long maxIdle = -1L;

        @XmlAttribute
        public void setLifespan(Long lifespan) {
            this.testImmutability("lifespan");
            this.lifespan = lifespan;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitExpirationType(this);
        }

        @XmlAttribute
        public void setMaxIdle(Long maxIdle) {
            this.testImmutability("maxIdle");
            this.maxIdle = maxIdle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExpirationType)) {
                return false;
            }
            ExpirationType that = (ExpirationType)o;
            if (this.lifespan != null ? !this.lifespan.equals(that.lifespan) : that.lifespan != null) {
                return false;
            }
            return !(this.maxIdle != null ? !this.maxIdle.equals(that.maxIdle) : that.maxIdle != null);
        }

        public int hashCode() {
            int result = this.lifespan != null ? this.lifespan.hashCode() : 0;
            result = 31 * result + (this.maxIdle != null ? this.maxIdle.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AsyncType
    extends AbstractNamedCacheConfigurationBean {
        @XmlTransient
        private boolean readFromXml = false;
        private static final long serialVersionUID = -7726319188826197399L;
        protected Boolean useReplQueue = false;
        protected Integer replQueueMaxElements = 1000;
        protected Long replQueueInterval = 5000L;
        protected Boolean asyncMarshalling = false;
        protected String replQueueClass = ReplicationQueueImpl.class.getName();

        private AsyncType(boolean readFromXml) {
            this.readFromXml = readFromXml;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitAsyncType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AsyncType)) {
                return false;
            }
            AsyncType asyncType = (AsyncType)o;
            if (this.readFromXml != asyncType.readFromXml) {
                return false;
            }
            if (this.asyncMarshalling != null ? !this.asyncMarshalling.equals(asyncType.asyncMarshalling) : asyncType.asyncMarshalling != null) {
                return false;
            }
            if (this.replQueueInterval != null ? !this.replQueueInterval.equals(asyncType.replQueueInterval) : asyncType.replQueueInterval != null) {
                return false;
            }
            if (this.replQueueMaxElements != null ? !this.replQueueMaxElements.equals(asyncType.replQueueMaxElements) : asyncType.replQueueMaxElements != null) {
                return false;
            }
            if (this.useReplQueue != null ? !this.useReplQueue.equals(asyncType.useReplQueue) : asyncType.useReplQueue != null) {
                return false;
            }
            return Util.safeEquals(this.replQueueClass, asyncType.replQueueClass);
        }

        public int hashCode() {
            int result = this.readFromXml ? 1 : 0;
            result = 31 * result + (this.useReplQueue != null ? this.useReplQueue.hashCode() : 0);
            result = 31 * result + (this.replQueueMaxElements != null ? this.replQueueMaxElements.hashCode() : 0);
            result = 31 * result + (this.replQueueInterval != null ? this.replQueueInterval.hashCode() : 0);
            result = 31 * result + (this.asyncMarshalling != null ? this.asyncMarshalling.hashCode() : 0);
            result = 31 * result + (this.replQueueClass != null ? this.replQueueClass.hashCode() : 0);
            return result;
        }

        private AsyncType() {
            this(true);
        }

        @XmlAttribute
        public void setUseReplQueue(Boolean useReplQueue) {
            this.testImmutability("useReplQueue");
            this.useReplQueue = useReplQueue;
        }

        @XmlAttribute
        public void setReplQueueMaxElements(Integer replQueueMaxElements) {
            this.testImmutability("replQueueMaxElements");
            this.replQueueMaxElements = replQueueMaxElements;
        }

        @XmlAttribute
        public void setReplQueueInterval(Long replQueueInterval) {
            this.testImmutability("replQueueInterval");
            this.replQueueInterval = replQueueInterval;
        }

        @XmlAttribute
        public void setAsyncMarshalling(Boolean asyncMarshalling) {
            this.testImmutability("asyncMarshalling");
            this.asyncMarshalling = asyncMarshalling;
        }

        @XmlAttribute
        public void setReplQueueClass(String replQueueClass) {
            this.testImmutability("replQueueClass");
            this.replQueueClass = replQueueClass;
        }
    }

    public static class ClusteringTypeAdapter
    extends XmlAdapter<ClusteringType, ClusteringType> {
        public ClusteringType marshal(ClusteringType ct) throws Exception {
            return ct;
        }

        public ClusteringType unmarshal(ClusteringType ct) throws Exception {
            if (ct.stringMode != null) {
                String mode = ct.stringMode.toLowerCase();
                if (mode.startsWith("r")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.REPL_SYNC);
                    } else {
                        ct.setMode(CacheMode.REPL_ASYNC);
                    }
                } else if (mode.startsWith("i")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.INVALIDATION_SYNC);
                    } else {
                        ct.setMode(CacheMode.INVALIDATION_ASYNC);
                    }
                } else if (mode.startsWith("d")) {
                    if (ct.isSynchronous()) {
                        ct.setMode(CacheMode.DIST_SYNC);
                    } else {
                        ct.setMode(CacheMode.DIST_ASYNC);
                    }
                } else {
                    throw new ConfigurationException("Invalid clustering mode" + ct.stringMode);
                }
            }
            return ct;
        }
    }

    @XmlJavaTypeAdapter(value=ClusteringTypeAdapter.class)
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlType(propOrder={})
    public static class ClusteringType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 4048135465543498430L;
        @XmlAttribute(name="mode")
        protected String stringMode;
        @XmlTransient
        protected CacheMode mode = CacheMode.LOCAL;
        @XmlElement
        protected SyncType sync = new SyncType();
        @XmlElement
        protected StateRetrievalType stateRetrieval = new StateRetrievalType();
        @XmlElement
        protected L1Type l1 = new L1Type();
        @XmlElement
        protected AsyncType async = new AsyncType(false);
        @XmlElement
        protected HashType hash = new HashType();

        public void setMode(CacheMode mode) {
            this.testImmutability("mode");
            this.mode = mode;
        }

        public boolean isSynchronous() {
            return !this.async.readFromXml;
        }

        @Override
        public ClusteringType clone() throws CloneNotSupportedException {
            ClusteringType dolly = (ClusteringType)super.clone();
            dolly.sync = (SyncType)this.sync.clone();
            dolly.stateRetrieval = (StateRetrievalType)this.stateRetrieval.clone();
            dolly.l1 = (L1Type)this.l1.clone();
            dolly.async = (AsyncType)this.async.clone();
            dolly.hash = (HashType)this.hash.clone();
            return dolly;
        }

        public void accept(ConfigurationBeanVisitor v) {
            this.async.accept(v);
            this.hash.accept(v);
            this.l1.accept(v);
            this.stateRetrieval.accept(v);
            this.sync.accept(v);
            v.visitClusteringType(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusteringType)) {
                return false;
            }
            ClusteringType that = (ClusteringType)o;
            if (this.async != null ? !this.async.equals(that.async) : that.async != null) {
                return false;
            }
            if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
                return false;
            }
            if (this.l1 != null ? !this.l1.equals(that.l1) : that.l1 != null) {
                return false;
            }
            if (this.mode != that.mode) {
                return false;
            }
            if (this.stateRetrieval != null ? !this.stateRetrieval.equals(that.stateRetrieval) : that.stateRetrieval != null) {
                return false;
            }
            return !(this.sync != null ? !this.sync.equals(that.sync) : that.sync != null);
        }

        public int hashCode() {
            int result = this.stringMode != null ? this.stringMode.hashCode() : 0;
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.sync != null ? this.sync.hashCode() : 0);
            result = 31 * result + (this.stateRetrieval != null ? this.stateRetrieval.hashCode() : 0);
            result = 31 * result + (this.l1 != null ? this.l1.hashCode() : 0);
            result = 31 * result + (this.async != null ? this.async.hashCode() : 0);
            result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class LockingType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = 8142143187082119506L;
        @Dynamic
        protected Long lockAcquisitionTimeout = 10000L;
        protected IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
        protected Boolean writeSkewCheck = false;
        protected Boolean useLockStriping = true;
        protected Integer concurrencyLevel = 32;

        @XmlAttribute
        public void setLockAcquisitionTimeout(Long lockAcquisitionTimeout) {
            this.testImmutability("lockAcquisitionTimeout");
            this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitLockingType(this);
        }

        @XmlAttribute
        public void setIsolationLevel(IsolationLevel isolationLevel) {
            this.testImmutability("isolationLevel");
            this.isolationLevel = isolationLevel;
        }

        @XmlAttribute
        public void setWriteSkewCheck(Boolean writeSkewCheck) {
            this.testImmutability("writeSkewCheck");
            this.writeSkewCheck = writeSkewCheck;
        }

        @XmlAttribute
        public void setUseLockStriping(Boolean useLockStriping) {
            this.testImmutability("useLockStriping");
            this.useLockStriping = useLockStriping;
        }

        @XmlAttribute
        public void setConcurrencyLevel(Integer concurrencyLevel) {
            this.testImmutability("concurrencyLevel");
            this.concurrencyLevel = concurrencyLevel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LockingType)) {
                return false;
            }
            LockingType that = (LockingType)o;
            if (this.concurrencyLevel != null ? !this.concurrencyLevel.equals(that.concurrencyLevel) : that.concurrencyLevel != null) {
                return false;
            }
            if (this.isolationLevel != that.isolationLevel) {
                return false;
            }
            if (this.lockAcquisitionTimeout != null ? !this.lockAcquisitionTimeout.equals(that.lockAcquisitionTimeout) : that.lockAcquisitionTimeout != null) {
                return false;
            }
            if (this.useLockStriping != null ? !this.useLockStriping.equals(that.useLockStriping) : that.useLockStriping != null) {
                return false;
            }
            return !(this.writeSkewCheck != null ? !this.writeSkewCheck.equals(that.writeSkewCheck) : that.writeSkewCheck != null);
        }

        public int hashCode() {
            int result = this.lockAcquisitionTimeout != null ? this.lockAcquisitionTimeout.hashCode() : 0;
            result = 31 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
            result = 31 * result + (this.writeSkewCheck != null ? this.writeSkewCheck.hashCode() : 0);
            result = 31 * result + (this.useLockStriping != null ? this.useLockStriping.hashCode() : 0);
            result = 31 * result + (this.concurrencyLevel != null ? this.concurrencyLevel.hashCode() : 0);
            return result;
        }
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class TransactionType
    extends AbstractNamedCacheConfigurationBean {
        private static final long serialVersionUID = -3867090839830874603L;
        protected String transactionManagerLookupClass;
        @XmlTransient
        protected TransactionManagerLookup transactionManagerLookup;
        @Dynamic
        protected Boolean syncCommitPhase = false;
        @Dynamic
        protected Boolean syncRollbackPhase = false;
        @Dynamic
        protected Boolean useEagerLocking = false;
        @Dynamic
        protected Boolean eagerLockSingleNode = false;

        public TransactionType(String transactionManagerLookupClass) {
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        public void accept(ConfigurationBeanVisitor v) {
            v.visitTransactionType(this);
        }

        public TransactionType() {
            this.transactionManagerLookupClass = GenericTransactionManagerLookup.class.getName();
        }

        @XmlAttribute
        public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
            this.testImmutability("transactionManagerLookupClass");
            this.transactionManagerLookupClass = transactionManagerLookupClass;
        }

        @XmlAttribute
        public void setSyncCommitPhase(Boolean syncCommitPhase) {
            this.testImmutability("syncCommitPhase");
            this.syncCommitPhase = syncCommitPhase;
        }

        @XmlAttribute
        public void setSyncRollbackPhase(Boolean syncRollbackPhase) {
            this.testImmutability("syncRollbackPhase");
            this.syncRollbackPhase = syncRollbackPhase;
        }

        @XmlAttribute
        public void setUseEagerLocking(Boolean useEagerLocking) {
            this.testImmutability("useEagerLocking");
            this.useEagerLocking = useEagerLocking;
        }

        @XmlAttribute
        public void setEagerLockSingleNode(Boolean eagerLockSingleNode) {
            this.testImmutability("eagerLockSingleNode");
            this.eagerLockSingleNode = eagerLockSingleNode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransactionType)) {
                return false;
            }
            TransactionType that = (TransactionType)o;
            if (this.syncCommitPhase != null ? !this.syncCommitPhase.equals(that.syncCommitPhase) : that.syncCommitPhase != null) {
                return false;
            }
            if (this.syncRollbackPhase != null ? !this.syncRollbackPhase.equals(that.syncRollbackPhase) : that.syncRollbackPhase != null) {
                return false;
            }
            if (this.transactionManagerLookup != null ? !this.transactionManagerLookup.equals(that.transactionManagerLookup) : that.transactionManagerLookup != null) {
                return false;
            }
            if (this.transactionManagerLookupClass != null ? !this.transactionManagerLookupClass.equals(that.transactionManagerLookupClass) : that.transactionManagerLookupClass != null) {
                return false;
            }
            return !(this.useEagerLocking != null ? !this.useEagerLocking.equals(that.useEagerLocking) : that.useEagerLocking != null);
        }

        public int hashCode() {
            int result = this.transactionManagerLookupClass != null ? this.transactionManagerLookupClass.hashCode() : 0;
            result = 31 * result + (this.transactionManagerLookup != null ? this.transactionManagerLookup.hashCode() : 0);
            result = 31 * result + (this.syncCommitPhase != null ? this.syncCommitPhase.hashCode() : 0);
            result = 31 * result + (this.syncRollbackPhase != null ? this.syncRollbackPhase.hashCode() : 0);
            result = 31 * result + (this.useEagerLocking != null ? this.useEagerLocking.hashCode() : 0);
            return result;
        }
    }
}

