/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.AbstractListenerImpl;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.EventImpl;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheManagerNotifierImpl
extends AbstractListenerImpl
implements CacheManagerNotifier {
    private static final Log log = LogFactory.getLog(CacheManagerNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class> allowedListeners = new HashMap<Class<? extends Annotation>, Class>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheStartedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheStoppedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> viewChangedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> mergeListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    private EmbeddedCacheManager cacheManager;

    public CacheManagerNotifierImpl() {
        this.listenersMap.put(CacheStarted.class, this.cacheStartedListeners);
        this.listenersMap.put(CacheStopped.class, this.cacheStoppedListeners);
        this.listenersMap.put(ViewChanged.class, this.viewChangedListeners);
    }

    @Inject
    public void injectCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void notifyViewChange(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId, boolean needsToRejoin) {
        if (!this.viewChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setViewId(viewId);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setNeedsToRejoin(needsToRejoin);
            e.setType(Event.Type.VIEW_CHANGED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.viewChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyMerge(List<Address> members, List<Address> oldMembers, Address myAddress, int viewId, boolean needsToRejoin, List<List<Address>> subgroupsMerged) {
        if (!this.viewChangedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setLocalAddress(myAddress);
            e.setViewId(viewId);
            e.setNewMembers(members);
            e.setOldMembers(oldMembers);
            e.setCacheManager(this.cacheManager);
            e.setNeedsToRejoin(needsToRejoin);
            e.setSubgroupsMerged(subgroupsMerged);
            e.setType(Event.Type.MERGED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.mergeListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheStarted(String cacheName) {
        if (!this.cacheStartedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STARTED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheStartedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyCacheStopped(String cacheName) {
        if (!this.cacheStoppedListeners.isEmpty()) {
            EventImpl e = new EventImpl();
            e.setCacheName(cacheName);
            e.setCacheManager(this.cacheManager);
            e.setType(Event.Type.CACHE_STOPPED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheStoppedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Stop
    void stop() {
        if (this.syncProcessor != null) {
            this.syncProcessor.shutdownNow();
        }
        if (this.asyncProcessor != null) {
            this.asyncProcessor.shutdownNow();
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class> getAllowedMethodAnnotations() {
        return allowedListeners;
    }

    static {
        allowedListeners.put(CacheStarted.class, CacheStartedEvent.class);
        allowedListeners.put(CacheStopped.class, CacheStoppedEvent.class);
        allowedListeners.put(ViewChanged.class, ViewChangedEvent.class);
    }
}

