/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
implements CacheTransaction,
Cloneable {
    private static Log log = LogFactory.getLog(RemoteTransaction.class);
    private List<WriteCommand> modifications;
    private BidirectionalLinkedHashMap<Object, CacheEntry> lookedUpEntries;
    private GlobalTransaction tx;

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        this.modifications = Arrays.asList(modifications);
        this.lookedUpEntries = new BidirectionalLinkedHashMap(modifications.length);
        this.tx = tx;
    }

    public RemoteTransaction(GlobalTransaction tx) {
        this.modifications = new LinkedList<WriteCommand>();
        this.lookedUpEntries = new BidirectionalLinkedHashMap();
        this.tx = tx;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public void setModifications(WriteCommand[] modifications) {
        this.modifications = Arrays.asList(modifications);
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        return this.lookedUpEntries.get(key);
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (log.isTraceEnabled()) {
            log.trace("Adding key " + key + " to tx " + this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.lookedUpEntries.remove(key);
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList<WriteCommand>(this.modifications);
            dolly.lookedUpEntries = this.lookedUpEntries.clone();
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", tx=" + this.tx + '}';
    }

    public Set<Object> getLockedKeys() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object e : this.getLookedUpEntries().keySet()) {
            result.add(e);
        }
        if (this.lookedUpEntries.entrySet().size() != result.size()) {
            throw new IllegalStateException("Different sizes!");
        }
        return result;
    }
}

