/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.infinispan.Version;
import org.infinispan.config.InfinispanConfiguration;

public class JaxbSchemaGenerator {
    public static void main(String[] args) throws Exception {
        try {
            String dir;
            File baseDir = new File(System.getProperty("user.dir"));
            if (args.length > 0 && (dir = args[0]) != null && dir.length() > 0) {
                baseDir = new File(dir);
            }
            if (!baseDir.exists()) {
                baseDir.mkdirs();
            }
            System.out.println("Generating schema file in " + baseDir.getAbsolutePath());
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{InfinispanConfiguration.class});
                context.generateSchema((SchemaOutputResolver)new InfinispanSchemaOutputResolver(baseDir));
                System.out.println("Generated schema file successfully");
            }
            catch (Exception e) {
                System.err.println("Failed generating schema file " + e);
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Failed generating schema file " + e);
            e.printStackTrace(System.err);
        }
    }

    static class InfinispanSchemaOutputResolver
    extends SchemaOutputResolver {
        private File dir;

        private InfinispanSchemaOutputResolver(File dir) {
            this.dir = dir;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return new StreamResult(new File(this.dir, "infinispan-config-" + Version.getMajorVersion() + ".xsd"));
        }
    }
}

