/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;

public class DistributionInterceptor
extends BaseRpcInterceptor {
    DistributionManager dm;
    CommandsFactory cf;
    DataContainer dataContainer;
    boolean isL1CacheEnabled;
    boolean needReliableReturnValues;
    EntryFactory entryFactory;
    static final RecipientGenerator CLEAR_COMMAND_GENERATOR = new RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return Collections.emptySet();
        }
    };

    @Inject
    public void injectDependencies(DistributionManager distributionManager, CommandsFactory cf, DataContainer dataContainer, EntryFactory entryFactory) {
        this.dm = distributionManager;
        this.cf = cf;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
    }

    @Start
    public void start() {
        this.isL1CacheEnabled = this.configuration.isL1CacheEnabled();
        this.needReliableReturnValues = !this.configuration.isUnsafeUnreliableReturnValues();
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        boolean isStillRehashingOnJoin = !this.dm.isJoinComplete();
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!ctx.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && returnValue == null && ctx.lookupEntry(command.getKey()) == null) {
            returnValue = this.remoteGetAndStoreInL1(ctx, command.getKey(), isStillRehashingOnJoin);
        }
        return returnValue;
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key, boolean dmWasRehashingDuringLocalLookup) throws Throwable {
        boolean isMappedToLocalNode = false;
        if (ctx.isOriginLocal() && !(isMappedToLocalNode = this.dm.isLocal(key)) && this.isNotInL1(key)) {
            return this.realRemoteGet(ctx, key, true);
        }
        if (isMappedToLocalNode && dmWasRehashingDuringLocalLookup) {
            if (this.trace) {
                this.log.trace("Key is mapped to local node, but a rehash is in progress so may need to look elsewhere");
            }
            return this.realRemoteGet(ctx, key, false);
        }
        if (this.trace) {
            this.log.trace((Object)"Not doing a remote get for key {0} since entry is mapped to current node, or is in L1", key);
        }
        return null;
    }

    private Object realRemoteGet(InvocationContext ctx, Object key, boolean storeInL1) throws Throwable {
        InternalCacheEntry ice;
        if (this.trace) {
            this.log.trace((Object)"Doing a remote get for key {0}", key);
        }
        if ((ice = this.dm.retrieveFromRemoteSource(key)) != null) {
            if (storeInL1 && this.isL1CacheEnabled) {
                if (this.trace) {
                    this.log.trace((Object)"Caching remotely retrieved entry for key {0} in L1", key);
                }
                long lifespan = ice.getLifespan() < 0L ? this.configuration.getL1Lifespan() : Math.min(ice.getLifespan(), this.configuration.getL1Lifespan());
                PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), lifespan, -1L);
                this.entryFactory.wrapEntryForWriting(ctx, key, true, false, ctx.hasLockedKey(key), false, false);
                this.invokeNextInterceptor(ctx, put);
            } else if (this.trace) {
                this.log.trace((Object)"Not caching remotely retrieved entry for key {0} in L1", key);
            }
            return ice.getValue();
        }
        return null;
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new MultipleKeysRecipientGenerator(command.getMap().keySet()), true);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command, new SingleKeyRecipientGenerator(command.getKey()), false);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            if (this.configuration.isEagerLockSingleNode()) {
                LinkedList<Address> where;
                Map<Object, List<Address>> toMulticast = this.dm.locateAll(command.getKeys(), 1);
                if (toMulticast.size() == 1) {
                    where = toMulticast.values().iterator().next();
                } else {
                    where = new LinkedList();
                    for (List<Address> values : toMulticast.values()) {
                        where.addAll(values);
                    }
                }
                this.rpcManager.invokeRemotely(where, (ReplicableCommand)command, true, true);
                ((LocalTxInvocationContext)ctx).remoteLocksAcquired(where);
            } else {
                this.rpcManager.invokeRemotely(this.dm.getAffectedNodes(command.getKeys()), (ReplicableCommand)command, true, true);
            }
            ctx.addAffectedKeys(command.getKeys());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            List<Address> recipients = this.dm.getAffectedNodes(ctx.getAffectedKeys());
            NotifyingNotifiableFuture<Object> f = this.flushL1Cache(recipients.size(), ctx.getLockedKeys(), null);
            this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, this.configuration.isSyncCommitPhase(), true);
            if (f != null) {
                f.get();
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        boolean sync = this.isSynchronous(ctx);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            List<Address> recipients = this.dm.getAffectedNodes(ctx.getAffectedKeys());
            NotifyingNotifiableFuture<Object> f = null;
            if (command.isOnePhaseCommit()) {
                f = this.flushL1Cache(recipients.size(), ctx.getLockedKeys(), null);
            }
            this.rpcManager.invokeRemotely(recipients, command, sync);
            if (f != null) {
                f.get();
            }
        }
        return retVal;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.dm.getAffectedNodes(ctx.getAffectedKeys()), (ReplicableCommand)command, this.configuration.isSyncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, boolean isConditionalCommand, KeyGenerator keygen) throws Throwable {
        boolean isStillRehashingOnJoin;
        boolean bl = isStillRehashingOnJoin = !this.dm.isJoinComplete();
        if (this.isNeedReliableReturnValues(ctx) || isConditionalCommand && ctx.isInTxScope()) {
            for (Object k : keygen.getKeys()) {
                this.remoteGetAndStoreInL1(ctx, k, isStillRehashingOnJoin);
            }
        }
    }

    private boolean isNeedReliableReturnValues(InvocationContext ctx) {
        return !ctx.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && this.needReliableReturnValues;
    }

    private NotifyingNotifiableFuture<Object> flushL1Cache(int numCallRecipients, Collection<Object> keys, Object retval) {
        if (this.isL1CacheEnabled && numCallRecipients > 0 && this.rpcManager.getTransport().getMembers().size() > numCallRecipients) {
            if (this.trace) {
                this.log.trace("Invalidating L1 caches");
            }
            InvalidateCommand ic = this.cf.buildInvalidateFromL1Command(false, keys);
            AggregatingNotifyingFutureImpl future = new AggregatingNotifyingFutureImpl(retval, 2);
            this.rpcManager.broadcastRpcCommandInFuture(ic, future);
            return future;
        }
        return null;
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command, RecipientGenerator recipientGenerator, boolean skipRemoteGet) throws Throwable {
        boolean localModeForced;
        boolean bl = localModeForced = this.isLocalModeForced(ctx) || this.isSingleOwnerAndLocal(recipientGenerator);
        if (!skipRemoteGet) {
            this.remoteGetBeforeWrite(ctx, command.isConditional(), recipientGenerator);
        }
        if (localModeForced) {
            this.log.trace("LOCAL mode forced.  No RPC needed.");
            return this.invokeNextInterceptor(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful()) {
            if (!ctx.isInTxScope()) {
                if (ctx.isOriginLocal()) {
                    List<Address> rec = recipientGenerator.generateRecipients();
                    if (this.trace) {
                        this.log.trace((Object)"Invoking command {0} on hosts {1}", command, rec);
                    }
                    boolean useFuture = ctx.isUseFutureReturnType();
                    boolean sync = this.isSynchronous(ctx);
                    NotifyingFutureImpl future = this.flushL1Cache(rec == null ? 0 : rec.size(), recipientGenerator.getKeys(), returnValue);
                    if (useFuture) {
                        if (future == null) {
                            future = new NotifyingFutureImpl(returnValue);
                        }
                        this.rpcManager.invokeRemotelyInFuture(rec, command, future);
                        return future;
                    }
                    this.rpcManager.invokeRemotely(rec, command, sync);
                    if (future != null && !sync) {
                        future.get();
                    }
                }
            } else {
                ((TxInvocationContext)ctx).addAffectedKeys(recipientGenerator.getKeys());
            }
        }
        return returnValue;
    }

    private boolean isSingleOwnerAndLocal(RecipientGenerator recipientGenerator) {
        List<Address> recipients;
        return this.configuration.getNumOwners() == 1 && (recipients = recipientGenerator.generateRecipients()) != null && recipients.get(0).equals(this.rpcManager.getTransport().getAddress());
    }

    class MultipleKeysRecipientGenerator
    implements RecipientGenerator {
        final Collection<Object> keys;
        List<Address> recipients = null;

        MultipleKeysRecipientGenerator(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                HashSet<Address> addresses = new HashSet<Address>();
                Map<Object, List<Address>> recipientsMap = DistributionInterceptor.this.dm.locateAll(this.keys);
                for (List<Address> a : recipientsMap.values()) {
                    addresses.addAll(a);
                }
                this.recipients = Immutables.immutableListConvert(addresses);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    class SingleKeyRecipientGenerator
    implements RecipientGenerator {
        final Object key;
        final Set<Object> keys;
        List<Address> recipients = null;

        SingleKeyRecipientGenerator(Object key) {
            this.key = key;
            this.keys = Collections.singleton(key);
        }

        @Override
        public List<Address> generateRecipients() {
            if (this.recipients == null) {
                this.recipients = DistributionInterceptor.this.dm.locate(this.key);
            }
            return this.recipients;
        }

        @Override
        public Collection<Object> getKeys() {
            return this.keys;
        }
    }

    static interface RecipientGenerator
    extends KeyGenerator {
        public List<Address> generateRecipients();
    }

    static interface KeyGenerator {
        public Collection<Object> getKeys();
    }
}

