/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractStreamingMarshaller;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionAwareMarshaller
extends AbstractStreamingMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private boolean trace = log.isTraceEnabled();
    private static final int VERSION_500 = 500;
    private static final int CUSTOM_MARSHALLER = 999;
    private final JBossMarshaller defaultMarshaller = new JBossMarshaller();
    private ClassLoader loader;
    private RemoteCommandsFactory remoteCommandsFactory;

    @Inject
    public void inject(ClassLoader loader, RemoteCommandsFactory remoteCommandsFactory) {
        this.loader = loader;
        this.remoteCommandsFactory = remoteCommandsFactory;
    }

    @Start(priority=9)
    public void start() {
        this.defaultMarshaller.start(this.loader, this.remoteCommandsFactory, this);
    }

    @Stop(priority=11)
    public void stop() {
        this.defaultMarshaller.stop();
    }

    protected int getCustomMarshallerVersionInt() {
        return 999;
    }

    @Override
    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput out = this.startObjectOutput(baos, false);
        try {
            this.defaultMarshaller.objectToObjectStream(obj, out);
        }
        catch (java.io.NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Object is not serializable", nse);
            }
            throw new NotSerializableException(nse.getMessage(), nse.getCause());
        }
        catch (IOException ioe) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exception while marshalling object", ioe);
            }
            if (ioe.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ioe.getCause();
            }
            throw ioe;
        }
        finally {
            this.finishObjectOutput(out);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, offset, len);
        ObjectInput in = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.defaultMarshaller.objectFromObjectStream(in);
        }
        finally {
            this.finishObjectInput(in);
        }
        return o;
    }

    @Override
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        ObjectOutput out = this.defaultMarshaller.startObjectOutput(os, isReentrant);
        try {
            out.writeShort(500);
            if (this.trace) {
                log.trace((Object)"Wrote version {0}", 500);
            }
        }
        catch (Exception e) {
            this.finishObjectOutput(out);
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream : " + e.getMessage());
        }
        return out;
    }

    @Override
    public void finishObjectOutput(ObjectOutput oo) {
        this.defaultMarshaller.finishObjectOutput(oo);
    }

    @Override
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    @Override
    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        ObjectInput in = this.defaultMarshaller.startObjectInput(is, isReentrant);
        try {
            short versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)"Read version {0}", versionId);
            }
        }
        catch (Exception e) {
            this.finishObjectInput(in);
            log.error("Unable to read version id from first two bytes of stream, barfing.");
            throw new IOException("Unable to read version id from first two bytes of stream: " + e.getMessage());
        }
        return in;
    }

    @Override
    public void finishObjectInput(ObjectInput oi) {
        this.defaultMarshaller.finishObjectInput(oi);
    }

    @Override
    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException, InterruptedException {
        try {
            return this.defaultMarshaller.objectFromObjectStream(in);
        }
        catch (IOException ioe) {
            if (this.trace) {
                log.trace((Object)"Log exception reported", ioe);
            }
            if (ioe.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ioe.getCause();
            }
            throw ioe;
        }
    }

    @Override
    public boolean isMarshallable(Object o) {
        return this.defaultMarshaller.isMarshallable(o);
    }
}

