/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=Externalizer.class, id=43)
public class DldGlobalTransaction
extends GlobalTransaction {
    private static Log log = LogFactory.getLog(DldGlobalTransaction.class);
    public static final boolean trace = log.isTraceEnabled();
    private volatile long coinToss;
    private volatile boolean isMarkedForRollback;
    private volatile transient Object localLockIntention;
    protected volatile Set<Object> remoteLockIntention = Collections.EMPTY_SET;
    private volatile Set<Object> locksAtOrigin = Collections.EMPTY_SET;

    public DldGlobalTransaction() {
    }

    DldGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    public void setCoinToss(long coinToss) {
        this.coinToss = coinToss;
    }

    public long getCoinToss() {
        return this.coinToss;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DldGlobalTransaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DldGlobalTransaction that = (DldGlobalTransaction)o;
        return this.coinToss == that.coinToss;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.coinToss ^ this.coinToss >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "DldGlobalTransaction{coinToss=" + this.coinToss + ", isMarkedForRollback=" + this.isMarkedForRollback + ", lockIntention=" + this.localLockIntention + ", affectedKeys=" + this.remoteLockIntention + ", locksAtOrigin=" + this.locksAtOrigin + "} " + super.toString();
    }

    public synchronized boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public synchronized void setMarkedForRollback(boolean markedForRollback) {
        this.isMarkedForRollback = markedForRollback;
    }

    public Object getLockIntention() {
        return this.localLockIntention;
    }

    public void setLockIntention(Object lockIntention) {
        this.localLockIntention = lockIntention;
    }

    public boolean wouldLose(DldGlobalTransaction other) {
        return this.coinToss < other.coinToss;
    }

    public boolean isAcquiringRemoteLock(Object key, Address address) {
        boolean contains = this.remoteLockIntention.contains(key);
        if (trace) {
            log.trace("Intention check: does " + this.remoteLockIntention + " contain " + key + "? " + contains);
        }
        return contains;
    }

    public void setRemoteLockIntention(Set<Object> remoteLockIntention) {
        if (trace) {
            log.trace("Setting the remote lock intention: " + remoteLockIntention);
        }
        this.remoteLockIntention = remoteLockIntention;
    }

    public Set<Object> getRemoteLockIntention() {
        return this.remoteLockIntention;
    }

    public boolean hasLockAtOrigin(Set<Object> remoteLockIntention) {
        if (log.isTraceEnabled()) {
            log.trace("Our(" + this + ") locks at origin are: " + this.locksAtOrigin + ". Others remote lock intention is: " + remoteLockIntention);
        }
        for (Object key : remoteLockIntention) {
            if (!this.locksAtOrigin.contains(key)) continue;
            return true;
        }
        return false;
    }

    public void setLocksHeldAtOrigin(Set<Object> locksAtOrigin) {
        if (trace) {
            log.trace("Setting locks at origin for (" + this + ")  to " + locksAtOrigin);
        }
        this.locksAtOrigin = locksAtOrigin;
    }

    public Set<Object> getLocksHeldAtOrigin() {
        return this.locksAtOrigin;
    }

    public static class Externalizer
    extends GlobalTransaction.Externalizer {
        public Externalizer() {
            this.gtxFactory = new GlobalTransactionFactory(true);
        }

        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            super.writeObject(output, subject);
            DldGlobalTransaction ddGt = (DldGlobalTransaction)subject;
            output.writeLong(ddGt.getCoinToss());
            if (ddGt.locksAtOrigin.isEmpty()) {
                output.writeObject(null);
            } else {
                output.writeObject(ddGt.locksAtOrigin);
            }
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            DldGlobalTransaction ddGt = (DldGlobalTransaction)super.readObject(input);
            ddGt.setCoinToss(input.readLong());
            Object locksAtOriginObj = input.readObject();
            if (locksAtOriginObj == null) {
                ddGt.setLocksHeldAtOrigin(Collections.EMPTY_SET);
            } else {
                ddGt.setLocksHeldAtOrigin((Set)locksAtOriginObj);
            }
            return ddGt;
        }
    }
}

