/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.AtomicHashMapDelta;
import org.infinispan.atomic.AtomicHashMapProxy;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class FineGrainedAtomicHashMapProxy<K, V>
extends AtomicHashMapProxy<K, V>
implements FineGrainedAtomicMap<K, V> {
    private static final Log log = LogFactory.getLog(FineGrainedAtomicHashMapProxy.class);
    private static final boolean trace = log.isTraceEnabled();

    FineGrainedAtomicHashMapProxy(AdvancedCache<?, ?> cache, Object deltaMapKey) {
        super(cache, deltaMapKey);
    }

    @Override
    protected AtomicHashMap<K, V> getDeltaMapForWrite() {
        AtomicHashMap map;
        boolean suppressLocks;
        boolean lockedAndCopied;
        CacheEntry lookedUpEntry = this.lookupEntryFromCurrentTransaction();
        boolean bl = lockedAndCopied = lookedUpEntry != null && lookedUpEntry.isChanged() && this.toMap((Object)lookedUpEntry.getValue()).copied;
        if (lockedAndCopied) {
            return this.getDeltaMapForRead();
        }
        boolean bl2 = suppressLocks = this.flagContainer != null && this.flagContainer.hasFlag(Flag.SKIP_LOCKING);
        if (!suppressLocks && this.flagContainer != null) {
            this.flagContainer.setFlags(Flag.FORCE_WRITE_LOCK);
        }
        if (trace) {
            if (suppressLocks) {
                log.trace("Skip locking flag used.  Skipping locking.");
            } else {
                log.trace("Forcing write lock even for reads");
            }
        }
        if (suppressLocks) {
            this.flagContainer.setFlags(Flag.SKIP_LOCKING);
        }
        boolean insertNewMap = (map = this.getDeltaMapForRead()) == null;
        AtomicHashMap copy = insertNewMap ? new AtomicHashMap(true) : map.copy();
        copy.initForWriting();
        if (insertNewMap) {
            this.cache.put(this.deltaMapKey, copy);
        }
        return copy;
    }

    @Override
    public Set<K> keySet() {
        AtomicHashMap map = this.getDeltaMapForRead().copy();
        HashSet<K> result = new HashSet<K>(this.keySetUncommitted());
        if (map != null) {
            result.addAll(map.keySet());
        }
        return result;
    }

    private Set<K> keySetUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().keySet() : Collections.emptySet();
    }

    @Override
    public Collection<V> values() {
        AtomicHashMap map = this.getDeltaMapForRead().copy();
        HashSet<V> result = new HashSet<V>(this.valuesUncommitted());
        if (map != null) {
            result.addAll(map.values());
        }
        return result;
    }

    private Collection<V> valuesUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().values() : Collections.emptySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AtomicHashMap map = this.getDeltaMapForRead().copy();
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>(this.entrySetUncommitted());
        if (map != null) {
            result.addAll(map.entrySet());
        }
        return result;
    }

    private Set<Map.Entry<K, V>> entrySetUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().entrySet() : Collections.emptySet();
    }

    @Override
    public int size() {
        AtomicHashMap map = this.getDeltaMapForRead();
        int su = this.sizeUncommitted();
        return map == null ? su : su + map.size();
    }

    public int sizeUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? entry.getUncommittedChages().size() : 0;
    }

    @Override
    public boolean isEmpty() {
        AtomicHashMap map = this.getDeltaMapForRead();
        return this.isEmptyUncommitted() && (map == null || map.isEmpty());
    }

    private boolean isEmptyUncommitted() {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && entry.getUncommittedChages().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        AtomicHashMap map = this.getDeltaMapForRead();
        return this.containsKeyUncommitted(key) || map != null && map.containsKey(key);
    }

    private boolean containsKeyUncommitted(Object key) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && entry.getUncommittedChages().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        AtomicHashMap map = this.getDeltaMapForRead();
        return this.containsValueUncommitted(value) || map != null && map.containsValue(value);
    }

    private boolean containsValueUncommitted(Object value) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null && entry.getUncommittedChages().containsValue(value);
    }

    @Override
    public V get(Object key) {
        V result = this.getUncommitted(key);
        if (result == null) {
            AtomicHashMap map = this.getDeltaMapForRead();
            result = map == null ? null : map.get(key);
        }
        return result;
    }

    public V getUncommitted(Object key) {
        DeltaAwareCacheEntry entry = this.lookupEntry();
        return entry != null ? (V)entry.getUncommittedChages().get(key) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            V toReturn = deltaMapForWrite.put(key, value);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
            V v = toReturn;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            V toReturn = deltaMapForWrite.remove(key);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
            V v = toReturn;
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        AtomicHashMap<? extends K, ? extends V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.putAll(m);
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
        }
        finally {
            this.endAtomic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        AtomicHashMap<K, V> deltaMapForWrite = null;
        try {
            this.startAtomic();
            deltaMapForWrite = this.getDeltaMapForWrite();
            deltaMapForWrite.clear();
            this.invokeApplyDelta(deltaMapForWrite.getDelta());
        }
        finally {
            this.endAtomic();
        }
    }

    private DeltaAwareCacheEntry lookupEntry() {
        CacheEntry entry = this.lookupEntryFromCurrentTransaction();
        if (entry instanceof DeltaAwareCacheEntry) {
            return (DeltaAwareCacheEntry)entry;
        }
        return null;
    }

    private void invokeApplyDelta(AtomicHashMapDelta delta) {
        Collection<Object> keys = Collections.emptyList();
        if (delta.hasClearOperation()) {
            AtomicHashMap map = (AtomicHashMap)this.cache.get(this.deltaMapKey);
            if (map != null) {
                keys = new ArrayList(map.keySet());
            }
        } else {
            keys = delta.getKeys();
        }
        this.cache.applyDelta(this.deltaMapKey, delta, keys);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("FineGrainedAtomicHashMapProxy{deltaMapKey=");
        sb.append(this.deltaMapKey);
        sb.append("}");
        return sb.toString();
    }
}

