/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<L1Configuration> {
    private static final Log log = LogFactory.getLog(L1ConfigurationBuilder.class);
    private boolean enabled = true;
    private int invalidationThreshold = 0;
    private long lifespan = TimeUnit.MINUTES.toMillis(10L);
    private Boolean onRehash = null;
    boolean activated = false;

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.invalidationThreshold = invalidationThreshold;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder lifespan(long livespan) {
        this.lifespan = livespan;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder enableOnRehash() {
        this.onRehash = true;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder onRehash(boolean enabled) {
        this.onRehash = enabled;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder disableOnRehash() {
        this.onRehash = false;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder enable() {
        this.enabled = true;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.enabled = false;
        this.activated = true;
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        this.activated = true;
        return this;
    }

    @Override
    void validate() {
        if (this.enabled) {
            if (!this.clustering().cacheMode().isDistributed() && this.activated) {
                throw new ConfigurationException("Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to " + this.clustering().cacheMode().friendlyCacheModeString());
            }
            if (this.lifespan < 1L) {
                throw new ConfigurationException("Using a L1 lifespan of 0 or a negative value is meaningless");
            }
        } else if (this.onRehash != null && this.onRehash.booleanValue()) {
            throw new ConfigurationException("Can only move entries to L1 on rehash when L1 is enabled");
        }
    }

    @Override
    L1Configuration create() {
        if (this.enabled && this.onRehash == null) {
            log.debug("L1 is enabled and L1OnRehash was not defined, enabling it");
            this.onRehash = true;
        } else {
            this.onRehash = false;
        }
        return new L1Configuration(this.enabled, this.invalidationThreshold, this.lifespan, this.onRehash, this.activated);
    }

    public L1ConfigurationBuilder read(L1Configuration template) {
        this.enabled = template.enabled();
        this.invalidationThreshold = template.invalidationThreshold();
        this.lifespan = template.lifespan();
        this.onRehash = template.onRehash();
        return this;
    }
}

