/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParsedCacheMode;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.file.FileCacheStore;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.StringPropertyReplacer;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Parser {
    private static final Log log = LogFactory.getLog(Parser.class);
    private final ClassLoader cl;

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.failedToCloseResource(t);
            }
        }
    }

    private static String replaceSystemProperties(String value) {
        int dollar = value.indexOf(36);
        if (dollar >= 0 && value.indexOf(123, dollar) > 0 && value.indexOf(125, dollar) > 0) {
            String replacedValue = StringPropertyReplacer.replaceProperties(value);
            if (value.equals(replacedValue)) {
                log.propertyCouldNotBeReplaced(value.substring(value.indexOf(123) + 1, value.indexOf(125)));
            }
            return replacedValue;
        }
        return value;
    }

    public Parser(ClassLoader cl) {
        this.cl = cl;
    }

    public ConfigurationBuilderHolder parse(String filename) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        return this.parse(fileLookup.lookupFile(filename, this.cl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parse(InputStream is) {
        ConfigurationBuilderHolder configurationBuilderHolder;
        try {
            BufferedInputStream input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            ConfigurationBuilderHolder holder = this.doParse(streamReader);
            streamReader.close();
            input.close();
            is.close();
            configurationBuilderHolder = holder;
        }
        catch (Throwable throwable) {
            try {
                Parser.safeClose(is);
                throw throwable;
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        Parser.safeClose(is);
        return configurationBuilderHolder;
    }

    private ConfigurationBuilderHolder doParse(XMLStreamReader reader) throws XMLStreamException {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        Element root = ParseUtils.nextElement(reader);
        if (!root.getLocalName().equals(Element.ROOT.getLocalName())) {
            throw ParseUtils.missingRequiredElement(reader, Collections.singleton(Element.ROOT));
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEFAULT: {
                    this.parseDefaultCache(reader, holder.getDefaultConfigurationBuilder());
                    continue block5;
                }
                case GLOBAL: {
                    this.parseGlobal(reader, holder.getGlobalConfigurationBuilder());
                    continue block5;
                }
                case NAMED_CACHE: {
                    this.parseNamedCache(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return holder;
    }

    private void parseNamedCache(XMLStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String name = "";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        this.parseCache(reader, builder);
    }

    private void parseDefaultCache(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        this.parseCache(reader, builder);
    }

    private void parseCache(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERING: {
                    this.parseClustering(reader, builder);
                    continue block17;
                }
                case CUSTOM_INTERCEPTORS: {
                    this.parseCustomInterceptors(reader, builder);
                    continue block17;
                }
                case DATA_CONTAINER: {
                    this.parseDataContainer(reader, builder);
                    continue block17;
                }
                case DEADLOCK_DETECTION: {
                    this.parseDeadlockDetection(reader, builder);
                    continue block17;
                }
                case EVICTION: {
                    this.parseEviction(reader, builder);
                    continue block17;
                }
                case EXPIRATION: {
                    this.parseExpiration(reader, builder);
                    continue block17;
                }
                case INDEXING: {
                    this.parseIndexing(reader, builder);
                    continue block17;
                }
                case INVOCATION_BATCHING: {
                    this.parseInvocationBatching(reader, builder);
                    continue block17;
                }
                case JMX_STATISTICS: {
                    this.parseJmxStatistics(reader, builder);
                    continue block17;
                }
                case LOADERS: {
                    this.parseLoaders(reader, builder);
                    continue block17;
                }
                case LOCKING: {
                    this.parseLocking(reader, builder);
                    continue block17;
                }
                case LAZY_DESERIALIZATION: 
                case STORE_AS_BINARY: {
                    this.parseStoreAsBinary(reader, builder);
                    continue block17;
                }
                case TRANSACTION: {
                    this.parseTransaction(reader, builder);
                    continue block17;
                }
                case UNSAFE: {
                    this.parseUnsafe(reader, builder);
                    continue block17;
                }
                case VERSIONING: {
                    this.parseVersioning(reader, builder);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseVersioning(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.versioning().disable();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    builder.versioning().scheme(VersioningScheme.valueOf(value));
                    continue block4;
                }
                case ENABLED: {
                    builder.versioning().enable();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseTransaction(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        boolean forceSetTransactional = false;
        boolean transactionModeSpecified = false;
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.valueOf(value));
                    continue block16;
                }
                case CACHE_STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Integer.valueOf(value).intValue());
                    continue block16;
                }
                case EAGER_LOCK_SINGLE_NODE: {
                    builder.transaction().eagerLockingSingleNode(Boolean.valueOf(value));
                    continue block16;
                }
                case LOCKING_MODE: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block16;
                }
                case SYNC_COMMIT_PHASE: {
                    builder.transaction().syncCommitPhase(Boolean.valueOf(value));
                    continue block16;
                }
                case SYNC_ROLLBACK_PHASE: {
                    builder.transaction().syncRollbackPhase(Boolean.valueOf(value));
                    continue block16;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance(value, this.cl));
                    forceSetTransactional = true;
                    continue block16;
                }
                case TRANSACTION_MODE: {
                    builder.transaction().transactionMode(TransactionMode.valueOf(value));
                    transactionModeSpecified = true;
                    continue block16;
                }
                case USE_EAGER_LOCKING: {
                    builder.transaction().useEagerLocking(Boolean.valueOf(value));
                    continue block16;
                }
                case USE_SYNCHRONIZAION: {
                    builder.transaction().useSynchronization(Boolean.valueOf(value));
                    continue block16;
                }
                case USE_1PC_FOR_AUTOCOMMIT_TX: {
                    builder.transaction().use1PcForAutoCommitTransactions(Boolean.valueOf(value));
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!transactionModeSpecified && forceSetTransactional) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RECOVERY: {
                    this.parseRecovery(reader, builder);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseRecovery(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.transaction().recovery().enable();
                        continue block4;
                    }
                    builder.transaction().recovery().disable();
                    continue block4;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    builder.transaction().recovery().recoveryInfoCacheName(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseUnsafe(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case UNRELIABLE_RETURN_VALUES: {
                    builder.unsafe().unreliableReturnValues(Boolean.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.storeAsBinary().enable();
                        continue block5;
                    }
                    builder.storeAsBinary().disable();
                    continue block5;
                }
                case STORE_KEYS_AS_BINARY: {
                    builder.storeAsBinary().storeKeysAsBinary(Boolean.valueOf(value));
                    continue block5;
                }
                case STORE_VALUES_AS_BINARY: {
                    builder.storeAsBinary().storeValuesAsBinary(Boolean.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLocking(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.valueOf(value));
                    continue block7;
                }
                case ISOLATION_LEVEL: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block7;
                }
                case LOCK_ACQUISITION_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.valueOf(value));
                    continue block7;
                }
                case USE_LOCK_STRIPING: {
                    builder.locking().useLockStriping(Boolean.valueOf(value));
                    continue block7;
                }
                case WRITE_SKEW_CHECK: {
                    builder.locking().writeSkewCheck(Boolean.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLoaders(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.loaders().passivation(Boolean.valueOf(value));
                    continue block8;
                }
                case PRELOAD: {
                    builder.loaders().preload(Boolean.valueOf(value));
                    continue block8;
                }
                case SHARED: {
                    builder.loaders().shared(Boolean.valueOf(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOADER: {
                    this.parseLoader(reader, builder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseLoader(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        CacheLoader loader = null;
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Integer purgerThreads = null;
        Boolean purgeSynchronously = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    loader = (CacheLoader)Util.getInstance(value, this.cl);
                    continue block8;
                }
                case FETCH_PERSISTENT_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block8;
                }
                case IGNORE_MODIFICATIONS: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGE_ON_STARTUP: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGER_THREADS: {
                    purgerThreads = Integer.valueOf(value);
                    continue block8;
                }
                case PURGE_SYNCHRONOUSLY: {
                    purgeSynchronously = Boolean.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (loader != null) {
            if (loader instanceof FileCacheStore) {
                FileCacheStoreConfigurationBuilder fcscb = builder.loaders().addFileCacheStore();
                if (fetchPersistentState != null) {
                    fcscb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    fcscb.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    fcscb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    fcscb.purgeSynchronously(purgeSynchronously);
                }
                this.parseLoaderChildren(reader, fcscb);
            } else {
                LoaderConfigurationBuilder lcb = builder.loaders().addCacheLoader();
                lcb.cacheLoader(loader);
                if (fetchPersistentState != null) {
                    lcb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    lcb.ignoreModifications(ignoreModifications);
                }
                if (purgerThreads != null) {
                    lcb.purgerThreads(purgerThreads);
                }
                if (purgeOnStartup != null) {
                    lcb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    lcb.purgeSynchronously(purgeSynchronously);
                }
                this.parseLoaderChildren(reader, lcb);
            }
        }
    }

    private void parseLoaderChildren(XMLStreamReader reader, AbstractLoaderConfigurationBuilder<?> loaderBuilder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    this.parseAsyncLoader(reader, loaderBuilder);
                    continue block5;
                }
                case PROPERTIES: {
                    loaderBuilder.withProperties(Parser.parseProperties(reader));
                    continue block5;
                }
                case SINGLETON_STORE: {
                    this.parseSingletonStore(reader, loaderBuilder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSingletonStore(XMLStreamReader reader, AbstractLoaderConfigurationBuilder<?> loaderBuilder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        loaderBuilder.singletonStore().enable();
                        continue block5;
                    }
                    loaderBuilder.singletonStore().disable();
                    continue block5;
                }
                case PUSH_STATE_TIMEOUT: {
                    loaderBuilder.singletonStore().pushStateTimeout(Long.valueOf(value));
                    continue block5;
                }
                case PUSH_STATE_WHEN_COORDINATOR: {
                    loaderBuilder.singletonStore().pushStateWhenCoordinator(Boolean.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAsyncLoader(XMLStreamReader reader, AbstractLoaderConfigurationBuilder loaderBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        loaderBuilder.async().enable();
                        continue block7;
                    }
                    loaderBuilder.async().disable();
                    continue block7;
                }
                case FLUSH_LOCK_TIMEOUT: {
                    loaderBuilder.async().flushLockTimeout(Long.valueOf(value));
                    continue block7;
                }
                case MODIFICTION_QUEUE_SIZE: {
                    loaderBuilder.async().modificationQueueSize(Integer.valueOf(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    loaderBuilder.async().shutdownTimeout(Long.valueOf(value));
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    loaderBuilder.async().threadPoolSize(Integer.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmxStatistics(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.jmxStatistics().enable();
                        continue block3;
                    }
                    builder.jmxStatistics().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseInvocationBatching(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.invocationBatching().enable();
                        continue block3;
                    }
                    builder.invocationBatching().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexing(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.indexing().enable();
                        continue block7;
                    }
                    builder.indexing().disable();
                    continue block7;
                }
                case INDEX_LOCAL_ONLY: {
                    builder.indexing().indexLocalOnly(Boolean.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Properties indexingProperties = null;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    indexingProperties = Parser.parseProperties(reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        IndexingConfigurationBuilder indexing = builder.indexing();
        if (indexingProperties != null) {
            indexing.withProperties(indexingProperties);
        }
    }

    private void parseExpiration(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.valueOf(value));
                    continue block6;
                }
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.valueOf(value));
                    continue block6;
                }
                case REAPER_ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.expiration().enableReaper();
                        continue block6;
                    }
                    builder.expiration().disableReaper();
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.valueOf(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseEviction(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    builder.eviction().maxEntries(Integer.valueOf(value));
                    continue block6;
                }
                case STRATEGY: {
                    builder.eviction().strategy(EvictionStrategy.valueOf(value));
                    continue block6;
                }
                case THREAD_POLICY: {
                    builder.eviction().threadPolicy(EvictionThreadPolicy.valueOf(value));
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    Long wakeUpInterval = Long.valueOf(value);
                    log.evictionWakeUpIntervalDeprecated(wakeUpInterval);
                    builder.expiration().wakeUpInterval(wakeUpInterval);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDeadlockDetection(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.deadlockDetection().enable();
                        continue block4;
                    }
                    builder.deadlockDetection().disable();
                    continue block4;
                }
                case SPIN_DURATION: {
                    builder.deadlockDetection().spinDuration(Long.valueOf(value).intValue());
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDataContainer(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.dataContainer().dataContainer((DataContainer)Util.getInstance(value, this.cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.dataContainer().withProperties(Parser.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCustomInterceptors(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass(value, this.cl));
                    continue block7;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass(value, this.cl));
                    continue block7;
                }
                case CLASS: {
                    interceptorBuilder.interceptor((CommandInterceptor)Util.getInstance(value, this.cl));
                    continue block7;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.valueOf(value));
                    continue block7;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseClustering(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        String clusteringMode = null;
        boolean synchronous = false;
        boolean asynchronous = false;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MODE: {
                    clusteringMode = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    asynchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseAsync(reader, builder);
                    continue block12;
                }
                case HASH: {
                    this.parseHash(reader, builder);
                    continue block12;
                }
                case L1: {
                    this.parseL1reader(reader, builder);
                    continue block12;
                }
                case STATE_RETRIEVAL: {
                    this.parseStateRetrieval(reader, builder);
                    continue block12;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, builder);
                    continue block12;
                }
                case SYNC: {
                    synchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseSync(reader, builder);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!synchronous && !asynchronous) {
            this.setMode(builder, clusteringMode, asynchronous, asynchronous, reader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMode(ConfigurationBuilder builder, String clusteringMode, boolean asynchronous, boolean synchronous, XMLStreamReader reader) {
        if (synchronous && asynchronous) {
            throw new ConfigurationException("Cannot configure <sync> and <async> on the same cluster, " + reader.getLocation());
        }
        if (clusteringMode != null) {
            String mode = clusteringMode.toUpperCase();
            if (ParsedCacheMode.REPL.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.REPL_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.INVALIDATION.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.DIST.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                }
                return;
            } else {
                if (!ParsedCacheMode.LOCAL.matches(mode)) throw new ConfigurationException("Invalid clustering mode " + clusteringMode + ", " + reader.getLocation());
                builder.clustering().cacheMode(CacheMode.LOCAL);
            }
            return;
        } else if (synchronous) {
            builder.clustering().cacheMode(CacheMode.DIST_SYNC);
            return;
        } else {
            if (!asynchronous) return;
            builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
        }
    }

    private void parseSync(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REPL_TIMEOUT: {
                    builder.clustering().sync().replTimeout(Long.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStateRetrieval(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALWAYS_PROVIDE_IN_MEMORY_STATE: {
                    log.alwaysProvideInMemoryStateDeprecated();
                    continue block10;
                }
                case FETCH_IN_MEMORY_STATE: {
                    log.stateRetrievalConfigurationDeprecaced();
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.valueOf(value));
                    continue block10;
                }
                case INITIAL_RETRY_WAIT_TIME: {
                    log.initialRetryWaitTimeDeprecated();
                    continue block10;
                }
                case LOG_FLUSH_TIMEOUT: {
                    log.logFlushTimeoutDeprecated();
                    continue block10;
                }
                case MAX_NON_PROGRESSING_LOG_WRITES: {
                    log.maxProgressingLogWritesDeprecated();
                    continue block10;
                }
                case NUM_RETRIES: {
                    log.numRetriesDeprecated();
                    continue block10;
                }
                case RETRY_WAIT_TIME_INCREASE_FACTOR: {
                    log.retryWaitTimeIncreaseFactorDeprecated();
                    continue block10;
                }
                case TIMEOUT: {
                    log.stateRetrievalConfigurationDeprecaced();
                    builder.clustering().stateTransfer().timeout(Long.valueOf(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStateTransfer(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FETCH_IN_MEMORY_STATE: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.valueOf(value));
                    continue block5;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.valueOf(value));
                    continue block5;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseL1reader(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.clustering().l1().enable();
                        continue block6;
                    }
                    builder.clustering().l1().disable();
                    continue block6;
                }
                case INVALIDATION_THRESHOLD: {
                    builder.clustering().l1().invalidationThreshold(Integer.valueOf(value));
                    continue block6;
                }
                case LIFESPAN: {
                    builder.clustering().l1().lifespan(Long.valueOf(value));
                    continue block6;
                }
                case ON_REHASH: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.clustering().l1().enableOnRehash();
                        continue block6;
                    }
                    builder.clustering().l1().disableOnRehash();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseHash(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: 
                case HASH_FUNCTION_CLASS: {
                    builder.clustering().hash().consistentHash((ConsistentHash)Util.getInstance(value, this.cl));
                    continue block11;
                }
                case NUM_OWNERS: {
                    builder.clustering().hash().numOwners(Integer.valueOf(value));
                    continue block11;
                }
                case NUM_VIRTUAL_NODES: {
                    builder.clustering().hash().numVirtualNodes(Integer.valueOf(value));
                    continue block11;
                }
                case REHASH_ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.clustering().hash().rehashEnabled();
                        continue block11;
                    }
                    builder.clustering().hash().rehashDisabled();
                    continue block11;
                }
                case REHASH_RPC_TIMEOUT: {
                    builder.clustering().hash().rehashRpcTimeout(Long.valueOf(value));
                    continue block11;
                }
                case REHASH_WAIT: {
                    builder.clustering().hash().rehashWait(Long.valueOf(value));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, builder);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGroups(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        String value;
        ParseUtils.requireSingleAttribute(reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance(value, this.cl));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsync(XMLStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ASYNC_MARSHALLING: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        builder.clustering().async().asyncMarshalling();
                        continue block7;
                    }
                    builder.clustering().async().syncMarshalling();
                    continue block7;
                }
                case REPL_QUEUE_CLASS: {
                    builder.clustering().async().replQueue((ReplicationQueue)Util.getInstance(value, this.cl));
                    continue block7;
                }
                case REPL_QUEUE_INTERVAL: {
                    builder.clustering().async().replQueueInterval(Long.valueOf(value));
                    continue block7;
                }
                case REPL_QUEUE_MAX_ELEMENTS: {
                    builder.clustering().async().replQueueMaxElements(Integer.valueOf(value));
                    continue block7;
                }
                case USE_REPL_QUEUE: {
                    builder.clustering().async().useReplQueue(Boolean.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobal(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        boolean transportParsed = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_LISTENER_EXECUTOR: {
                    this.parseAsyncListenerExectuor(reader, builder);
                    continue block10;
                }
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, builder);
                    continue block10;
                }
                case EVICTION_SCHEDULED_EXECUTOR: {
                    this.parseEvictionScheduledExecutor(reader, builder);
                    continue block10;
                }
                case GLOBAL_JMX_STATISTICS: {
                    this.parseGlobalJMXStatistics(reader, builder);
                    continue block10;
                }
                case REPLICATION_QUEUE_SCHEDULED_EXECUTOR: {
                    this.parseReplicationQueueScheduledExecutor(reader, builder);
                    continue block10;
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, builder);
                    continue block10;
                }
                case SHUTDOWN: {
                    this.parseShutdown(reader, builder);
                    continue block10;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, builder);
                    transportParsed = true;
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!transportParsed) {
            builder.transport().transport(null);
        } else if (builder.transport().getTransport() == null) {
            builder.transport().transport(Util.getInstance(TransportConfigurationBuilder.DEFAULT_TRANSPORT));
        }
    }

    private void parseTransport(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLUSTER_NAME: {
                    builder.transport().clusterName(value);
                    continue block13;
                }
                case DISTRIBUTED_SYNC_TIMEOUT: {
                    builder.transport().distributedSyncTimeout(Long.valueOf(value));
                    continue block13;
                }
                case MACHINE_ID: {
                    builder.transport().machineId(value);
                    continue block13;
                }
                case NODE_NAME: {
                    builder.transport().nodeName(value);
                    continue block13;
                }
                case RACK_ID: {
                    builder.transport().rackId(value);
                    continue block13;
                }
                case SITE_ID: {
                    builder.transport().siteId(value);
                    continue block13;
                }
                case STRICT_PEER_TO_PEER: {
                    builder.transport().strictPeerToPeer(Boolean.valueOf(value));
                    continue block13;
                }
                case TRANSPORT_CLASS: {
                    builder.transport().transport((Transport)Util.getInstance(value, this.cl));
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.transport().withProperties(Parser.parseProperties(reader));
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseShutdown(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOOK_BEHAVIOR: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseSerialization(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance(value, this.cl));
                    continue block7;
                }
                case VERSION: {
                    builder.serialization().version(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZERS: {
                    this.parseAdvancedExternalizers(reader, builder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizers(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    int attributes = reader.getAttributeCount();
                    AdvancedExternalizer advancedExternalizer = null;
                    Integer id = null;
                    ParseUtils.requireAttributes(reader, Attribute.EXTERNALIZER_CLASS.getLocalName());
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case EXTERNALIZER_CLASS: {
                                advancedExternalizer = (AdvancedExternalizer)Util.getInstance(value, this.cl);
                                continue block8;
                            }
                            case ID: {
                                id = Integer.valueOf(value);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    if (id != null) {
                        builder.serialization().addAdvancedExternalizer(id, advancedExternalizer);
                        continue block7;
                    }
                    builder.serialization().addAdvancedExternalizer(advancedExternalizer);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseReplicationQueueScheduledExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance(value, this.cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.replicationQueueScheduledExecutor().withProperties(Parser.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalJMXStatistics(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(value));
                    continue block10;
                }
                case CACHE_MANAGER_NAME: {
                    builder.globalJmxStatistics().cacheManagerName(value);
                    continue block10;
                }
                case ENABLED: {
                    if (!Boolean.valueOf(value).booleanValue()) {
                        builder.globalJmxStatistics().disable();
                        continue block10;
                    }
                    builder.globalJmxStatistics().enable();
                    continue block10;
                }
                case JMX_DOMAIN: {
                    builder.globalJmxStatistics().jmxDomain(value);
                    continue block10;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance(value, this.cl));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.globalJmxStatistics().withProperties(Parser.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseEvictionScheduledExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance(value, this.cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.evictionScheduledExecutor().withProperties(Parser.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncTransportExecutor(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncTransportExecutor().factory((ExecutorFactory)Util.getInstance(value, this.cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncTransportExecutor().withProperties(Parser.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncListenerExectuor(XMLStreamReader reader, GlobalConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncListenerExecutor().factory((ExecutorFactory)Util.getInstance(value, this.cl));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncListenerExecutor().withProperties(Parser.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static Properties parseProperties(XMLStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        Properties p = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
                    String key = null;
                    String propertyValue = null;
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = Parser.replaceSystemProperties(reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                key = value;
                                continue block8;
                            }
                            case VALUE: {
                                propertyValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    p.put(key, propertyValue);
                    ParseUtils.requireNoContent(reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return p;
    }
}

