/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedTransientCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedTransientCacheValue
extends TransientCacheValue
implements Versioned {
    EntryVersion version;

    public VersionedTransientCacheValue(Object value, EntryVersion version, long maxIdle, long lastUsed) {
        super(value, maxIdle, lastUsed);
        this.version = version;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new VersionedTransientCacheEntry(key, this);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedTransientCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, VersionedTransientCacheValue tcv) throws IOException {
            output.writeObject(tcv.value);
            output.writeObject(tcv.version);
            UnsignedNumeric.writeUnsignedLong(output, tcv.lastUsed);
            output.writeLong(tcv.maxIdle);
        }

        @Override
        public VersionedTransientCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new VersionedTransientCacheValue(v, version, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 82;
        }

        @Override
        public Set<Class<? extends VersionedTransientCacheValue>> getTypeClasses() {
            return Util.asSet(VersionedTransientCacheValue.class);
        }
    }
}

