/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.CacheException;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClusteredRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public static final Log log = LogFactory.getLog(ClusteringDependentLogic.class);

    public boolean localNodeIsOwner(Object var1);

    public boolean localNodeIsPrimaryOwner(Object var1);

    public void commitEntry(CacheEntry var1, EntryVersion var2, boolean var3);

    public Collection<Address> getOwners(Collection<Object> var1);

    public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static final class DistributionLogic
    implements ClusteringDependentLogic {
        private DistributionManager dm;
        private DataContainer dataContainer;
        private Configuration configuration;
        private RpcManager rpcManager;

        @Inject
        public void init(DistributionManager dm, DataContainer dataContainer, Configuration configuration, RpcManager rpcManager) {
            this.dm = dm;
            this.dataContainer = dataContainer;
            this.configuration = configuration;
            this.rpcManager = rpcManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return this.dm.getLocality(key).isLocal();
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            Address address = this.rpcManager.getAddress();
            boolean result = this.dm.getPrimaryLocation(key).equals(address);
            log.tracef("My address is %s. Am I main owner? - %b", address, result);
            return result;
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck) {
            boolean doCommit = true;
            if (!(skipOwnershipCheck || entry.isRemoved() || this.localNodeIsOwner(entry.getKey()))) {
                if (this.configuration.isL1CacheEnabled()) {
                    this.dm.transformForL1(entry);
                } else {
                    doCommit = false;
                }
            }
            if (doCommit) {
                entry.commit(this.dataContainer, newVersion);
            } else {
                entry.rollback();
            }
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return this.dm.getAffectedNodes(keys);
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            EntryVersionsMap uv = new EntryVersionsMap();
            for (WriteCommand c : prepareCommand.getModifications()) {
                for (Object k : c.getAffectedKeys()) {
                    EntryVersion versionSeen;
                    if (!this.localNodeIsPrimaryOwner(k)) continue;
                    ClusteredRepeatableReadEntry entry = (ClusteredRepeatableReadEntry)context.lookupEntry(k);
                    if (!context.isOriginLocal() && (versionSeen = (EntryVersion)prepareCommand.getVersionsSeen().get(k)) != null) {
                        entry.setVersion(versionSeen);
                    }
                    if (entry.performWriteSkewCheck(this.dataContainer)) {
                        IncrementableEntryVersion newVersion = entry.isCreated() ? versionGenerator.generateNew() : versionGenerator.increment((IncrementableEntryVersion)entry.getVersion());
                        uv.put(k, newVersion);
                        continue;
                    }
                    throw new CacheException("Write skew detected on key " + k + " for transaction " + context.getTransaction());
                }
            }
            CacheTransaction cacheTransaction = context.getCacheTransaction();
            EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
            if (uvOld != null && !uvOld.isEmpty()) {
                uvOld.putAll(uv);
                uv = uvOld;
            }
            cacheTransaction.setUpdatedEntryVersions(uv);
            return uv.isEmpty() ? null : uv;
        }
    }

    public static final class AllNodesLogic
    implements ClusteringDependentLogic {
        private DataContainer dataContainer;
        private RpcManager rpcManager;

        @Inject
        public void init(DataContainer dc, RpcManager rpcManager) {
            this.dataContainer = dc;
            this.rpcManager = rpcManager;
        }

        @Override
        public boolean localNodeIsOwner(Object key) {
            return true;
        }

        @Override
        public boolean localNodeIsPrimaryOwner(Object key) {
            return this.rpcManager == null || this.rpcManager.getTransport().isCoordinator();
        }

        @Override
        public void commitEntry(CacheEntry entry, EntryVersion newVersion, boolean skipOwnershipCheck) {
            entry.commit(this.dataContainer, newVersion);
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            return null;
        }

        @Override
        public Address getAddress() {
            return this.rpcManager.getAddress();
        }

        @Override
        public EntryVersionsMap createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (this.rpcManager.getTransport().isCoordinator()) {
                EntryVersionsMap uv = new EntryVersionsMap();
                for (WriteCommand c : prepareCommand.getModifications()) {
                    for (Object k : c.getAffectedKeys()) {
                        ClusteredRepeatableReadEntry entry = (ClusteredRepeatableReadEntry)context.lookupEntry(k);
                        if (entry.performWriteSkewCheck(this.dataContainer)) {
                            IncrementableEntryVersion newVersion = entry.isCreated() ? versionGenerator.generateNew() : versionGenerator.increment((IncrementableEntryVersion)entry.getVersion());
                            uv.put(k, newVersion);
                            continue;
                        }
                        throw new CacheException("Write skew detected on key " + k + " for transaction " + context.getTransaction());
                    }
                }
                context.getCacheTransaction().setUpdatedEntryVersions(uv);
                return uv;
            }
            return null;
        }
    }
}

