/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.control.CacheViewControlCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.BufferSizePredictor;
import org.infinispan.marshall.BufferSizePredictorFactory;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.marshall.jboss.ExtendedRiverUnmarshaller;
import org.infinispan.util.Util;

public class CacheRpcCommandExternalizer
extends AbstractExternalizer<CacheRpcCommand> {
    private GlobalComponentRegistry gcr;
    private ReplicableCommandExternalizer commandExt = new ReplicableCommandExternalizer();

    public void inject(RemoteCommandsFactory cmdFactory, GlobalComponentRegistry gcr) {
        this.commandExt.inject(cmdFactory, gcr);
        this.gcr = gcr;
    }

    @Override
    public Set<Class<? extends CacheRpcCommand>> getTypeClasses() {
        Set<Class<? extends CacheRpcCommand>> coreCommands = Util.asSet(MapReduceCommand.class, LockControlCommand.class, StateTransferControlCommand.class, ClusteredGetCommand.class, MultipleRpcCommand.class, SingleRpcCommand.class, CommitCommand.class, PrepareCommand.class, RollbackCommand.class, RemoveCacheCommand.class, TxCompletionNotificationCommand.class, GetInDoubtTransactionsCommand.class, GetInDoubtTxInfoCommand.class, CompleteTransactionCommand.class, CacheViewControlCommand.class, VersionedPrepareCommand.class, VersionedCommitCommand.class);
        coreCommands.addAll(this.gcr.getModuleProperties().moduleCacheRpcCommands());
        return coreCommands;
    }

    @Override
    public void writeObject(ObjectOutput output, CacheRpcCommand command) throws IOException {
        this.commandExt.writeCommandHeader(output, command);
        String cacheName = command.getCacheName();
        output.writeUTF(cacheName);
        ComponentRegistry registry = this.gcr.getNamedComponentRegistry(cacheName);
        StreamingMarshaller marshaller = registry == null ? this.gcr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.global") : registry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        ExposedByteArrayOutputStream os = this.marshallParameters(command, marshaller);
        UnsignedNumeric.writeUnsignedInt(output, os.size());
        output.write(os.getRawBuffer(), 0, os.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExposedByteArrayOutputStream marshallParameters(CacheRpcCommand cmd, StreamingMarshaller marshaller) throws IOException {
        BufferSizePredictor sizePredictor = BufferSizePredictorFactory.getBufferSizePredictor();
        int estimatedSize = sizePredictor.nextSize(cmd);
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput output = marshaller.startObjectOutput(baos, true);
        try {
            ReplicableCommandExternalizer.writeCommandParameters(output, cmd);
        }
        finally {
            marshaller.finishObjectOutput(output);
        }
        return baos;
    }

    @Override
    public CacheRpcCommand readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte type = input.readByte();
        byte methodId = (byte)input.readShort();
        String cacheName = input.readUTF();
        ComponentRegistry registry = this.gcr.getNamedComponentRegistry(cacheName);
        StreamingMarshaller marshaller = registry == null ? this.gcr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.global") : registry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        byte[] paramsRaw = new byte[UnsignedNumeric.readUnsignedInt(input)];
        input.readFully(paramsRaw);
        ByteArrayInputStream is = new ByteArrayInputStream(paramsRaw, 0, paramsRaw.length);
        ObjectInput paramsInput = marshaller.startObjectInput(is, true);
        if (paramsInput instanceof ExtendedRiverUnmarshaller) {
            ((ExtendedRiverUnmarshaller)((Object)paramsInput)).setInfinispanMarshaller(marshaller);
        }
        try {
            Object[] args = ReplicableCommandExternalizer.readParameters(paramsInput);
            CacheRpcCommand cacheRpcCommand = this.commandExt.cmdFactory.fromStream(methodId, args, type, cacheName);
            return cacheRpcCommand;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            marshaller.finishObjectInput(paramsInput);
        }
    }

    @Override
    public Integer getId() {
        return 74;
    }
}

