/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxConcurrentDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxConcurrentDistributionInterceptor.class);

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            HashSet<Address> primaryOwners = new HashSet<Address>(command.getAffectedKeys().size());
            for (Object k : command.getAffectedKeys()) {
                primaryOwners.add(this.cdl.getPrimaryOwner(k));
            }
            primaryOwners.remove(this.rpcManager.getAddress());
            if (!primaryOwners.isEmpty()) {
                this.rpcManager.invokeRemotely(primaryOwners, command, this.isSynchronous(command));
            }
        } else if (!command.isForwarded()) {
            HashSet<Object> keysIOwn = new HashSet<Object>(command.getAffectedKeys());
            for (Object k : command.getAffectedKeys()) {
                if (!this.cdl.localNodeIsPrimaryOwner(k)) continue;
                keysIOwn.add(k);
            }
            Collection<Address> backupOwners = this.cdl.getOwners(keysIOwn);
            if (!backupOwners.isEmpty()) {
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                this.rpcManager.invokeRemotely(backupOwners, command, this.isSynchronous(command));
                command.setForwarded(false);
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    protected Object handleLocalWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator rg, boolean skipL1Invalidation, boolean sync) throws Throwable {
        Map<Address, Response> addressResponseMap;
        Object key = ((DataCommand)((Object)command)).getKey();
        Address primaryOwner = this.cdl.getPrimaryOwner(key);
        if (primaryOwner.equals(this.rpcManager.getAddress())) {
            List<Address> recipients = rg.generateRecipients();
            log.tracef("I'm the primary owner, sending the command to all (%s) the recipients in order to be applied.", recipients);
            Object result = this.invokeNextInterceptor(ctx, command);
            if (command.isSuccessful()) {
                this.checkForOutdatedTopology(command);
                if (!this.isSingleOwnerAndLocal(rg)) {
                    command.setIgnorePreviousValue(true);
                    this.rpcManager.invokeRemotely(recipients, command, sync);
                }
            }
            return result;
        }
        log.tracef("I'm not the primary owner, so sending the command to the primary owner(%s) in order to be forwarded", primaryOwner);
        Object localResult = this.invokeNextInterceptor(ctx, command);
        this.checkForOutdatedTopology(command);
        try {
            addressResponseMap = this.rpcManager.invokeRemotely(Collections.singletonList(primaryOwner), command, sync);
        }
        catch (RemoteException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (ce instanceof OutdatedTopologyException) {
                command.setIgnorePreviousValue(true);
            }
            throw e;
        }
        if (!sync) {
            return localResult;
        }
        return this.getResponseFromPrimaryOwner(primaryOwner, addressResponseMap);
    }

    @Override
    protected void handleRemoteWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipL1Invalidation, boolean sync) throws Throwable {
        if (command instanceof DataCommand) {
            DataCommand dataCommand = (DataCommand)((Object)command);
            Address primaryOwner = this.cdl.getPrimaryOwner(dataCommand.getKey());
            if (command.isSuccessful()) {
                this.checkForOutdatedTopology(command);
                if (primaryOwner.equals(this.rpcManager.getAddress())) {
                    command.setIgnorePreviousValue(true);
                    this.rpcManager.invokeRemotely(recipientGenerator.generateRecipients(), command, sync);
                }
            }
        }
    }

    @Override
    protected Object getResponseFromPrimaryOwner(Address primaryOwner, Map<Address, Response> addressResponseMap) {
        Response fromPrimaryOwner = addressResponseMap.get(primaryOwner);
        if (fromPrimaryOwner == null) {
            log.tracef("Primary owner %s returned null", primaryOwner);
            return null;
        }
        if (fromPrimaryOwner.isSuccessful()) {
            return ((SuccessfulResponse)fromPrimaryOwner).getResponseValue();
        }
        if (addressResponseMap.get(primaryOwner) instanceof CacheNotFoundResponse) {
            throw new OutdatedTopologyException("Cache is no longer running on primary owner " + primaryOwner);
        }
        Exception cause = fromPrimaryOwner instanceof ExceptionResponse ? ((ExceptionResponse)fromPrimaryOwner).getException() : null;
        throw new CacheException("Got unsuccessful response from primary owner: " + fromPrimaryOwner, cause);
    }
}

